/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CancelledException;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.ImportOptions;
import merlin.data.GeomComposite;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.DistributionEditor;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;

public class ImportCSV
implements IImporter {
    private static final IPropertySet.Prop<IUrn<OccProfile>> PROFILE_PROP = new IPropertySet.Prop<Object>("PROFILE", null);
    private static final IPropertySet.Prop<IUrn<Behavior>> BEHAVIOR_PROP = new IPropertySet.Prop<Object>("BEHAVIOR", null);

    @Override
    public String[] getFileFilters() {
        return new String[]{"csv", Intl.intl("Occupant Positions CSV")};
    }

    @Override
    public void initDefaultOptions(MerlinData md, String ext, IPropertySet options) {
    }

    @Override
    public boolean getAllowNewFile(MerlinData md, String ext, IPropertySet options) {
        return false;
    }

    @Override
    public void update(MerlinData md, Events events, IPropertySet options) {
        this.removeInvalidFromDist(md, events, options, PROFILE_PROP, OccProfile.class, md.profiles.flatten(OccProfile.class).stream().filter(p -> p.getName().equals(md.profiles.DEFAULT.getName())).findFirst());
        this.removeInvalidFromDist(md, events, options, BEHAVIOR_PROP, Behavior.class, Optional.empty());
    }

    private <T> void removeInvalidFromDist(MerlinData md, Events events, IPropertySet options, IPropertySet.Prop<IUrn<T>> prop, Class<T> type, Optional<T> defObj) {
        IUrn<T> urn = options.get(prop);
        if (urn == null) {
            return;
        }
        IEventRecord<T> evts = events.getEvents(type, new Class[0]);
        if (!evts.hasRemovedObjs()) {
            return;
        }
        LinkedIdentityHashMap<T, Double> weights = new LinkedIdentityHashMap<T, Double>(urn.getWeights());
        double weightsRemoved = 0.0;
        for (T obj : evts.getRemovedObjs()) {
            Double oldWeight = (Double)weights.remove(obj);
            if (oldWeight == null) continue;
            weightsRemoved += oldWeight.doubleValue();
        }
        if (weightsRemoved > 0.0) {
            if (weights.isEmpty()) {
                options.remove(prop);
            } else {
                Object defObject = defObj.orElse(null);
                if (defObject == null) {
                    defObject = weights.keySet().iterator().next();
                }
                weights.merge(defObject, weightsRemoved, Double::sum);
                options.setIfNotDefault(prop, UrnUtil.newUrn(weights));
            }
        }
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        MerlinData md = options.get(ImportOptions.MD);
        return new AgentPositionsImportCard(md);
    }

    @Override
    public void cleanup(IPropertySet options) {
    }

    @Override
    public IImporter.Result read(MerlinApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>();
        IUrn<Behavior> behavior = options.get(BEHAVIOR_PROP);
        IUrn<OccProfile> profile = options.get(PROFILE_PROP);
        MerlinData md = options.get(ImportOptions.MD);
        long rseed = 0L;
        if (System.getProperty("csvimport_rseed") != null) {
            try {
                rseed = Long.parseLong(System.getProperty("csvimport_rseed"));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        Random rand = new Random(rseed);
        try (BufferedReader r = new BufferedReader(new FileReader(fn));){
            String line = r.readLine();
            while (line != null) {
                List<String> toks = CSVLineParser.parse(line, ", ", "");
                try {
                    Point3d pt = new Point3d(Double.parseDouble(toks.get(0)), Double.parseDouble(toks.get(1)), Double.parseDouble(toks.get(2)));
                    Behavior behav = behavior.getValue(rand);
                    OccProfile op = new OccProfile(profile.getValue(rand));
                    EgressAgent agent = new EgressAgent(op, behav);
                    agent.setLocation(new OccLocation(pt));
                    agent.setName(md.occNameGen.nextName(true));
                    agents.add(agent);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                line = r.readLine();
            }
        }
        if (!agents.isEmpty()) {
            EgressAgentComp comp = new EgressAgentComp(Intl.intl("Imported Occupants"));
            comp.addAll(agents);
            return new IImporter.Result(new GeomComposite(""), new Pair<EgressAgentComp, EgressAgentComp>(md.agents, comp));
        }
        return IImporter.Result.EMPTY;
    }

    private static class AgentPositionsImportCard
    extends AWizardCard<IPropertySet> {
        private static final long serialVersionUID = -5480141221455494060L;
        private final DistributionEditor<OccProfile> d_profileDistEd;
        private final DistributionEditor<Behavior> d_behaviorDistEd;

        public AgentPositionsImportCard(MerlinData md) {
            super(Intl.intl("Import occupants from CSV positions."));
            this.d_profileDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
            this.d_behaviorDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Profile:"), this.d_profileDistEd, GridBagHelper.REMAINING, 1.0);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorDistEd, GridBagHelper.REMAINING, 1.0);
            gb.finalizeRows();
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            boolean configured = this.d_profileDistEd.getValue() != null && this.d_behaviorDistEd.getValue() != null;
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return configured;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            if (data.get(PROFILE_PROP) != null) {
                this.d_profileDistEd.setValue((OccProfile)((Object)data.get(PROFILE_PROP)));
            }
            if (data.get(BEHAVIOR_PROP) != null) {
                this.d_behaviorDistEd.setValue((Behavior)((Object)data.get(BEHAVIOR_PROP)));
            }
        }

        @Override
        public void saveTo(IPropertySet data) {
            data.set(PROFILE_PROP, (IUrn)this.d_profileDistEd.getValue());
            data.set(BEHAVIOR_PROP, (IUrn)this.d_behaviorDistEd.getValue());
        }

        @Override
        protected Dimension getMaxCardSize() {
            return this.getMaxSizeThisOrNext();
        }

        @Override
        public AWizardCard<?> getNext() {
            return null;
        }

        @Override
        public void cancel() {
        }
    }
}

