/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.Undo;
import merlin.builders.NewCompUtil;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public abstract class ANewGeomBoolOp
extends AMerlinOp
implements IEventObserver {
    public ANewGeomBoolOp() {
        SelectionObserver.add(this, IEgressOccupiable.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        Set selGeom = md.selection.getDeepSelected(IEgressOccupiable.class);
        this.setEnabled(selGeom.size() >= 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set selGeom = md.selection.getDeepSelected(IEgressOccupiable.class);
        if (selGeom.size() < 2) {
            return;
        }
        if (!md.selection.isDeepEmpty(EgressCorridor.class)) {
            String msg = Intl.intl("Merged stairs and ramps will be converted to rooms.\nWould you like to continue?");
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Convert Stairs and Ramps?"), 0, 3);
            if (option != 0) {
                return;
            }
        }
        LinkedIdentityHashSet<IEgressComp> toAdd = new LinkedIdentityHashSet<IEgressComp>();
        LinkedIdentityHashSet<IEgressOccupiable> toRemove = new LinkedIdentityHashSet<IEgressOccupiable>();
        ArrayList toClean = new ArrayList();
        boolean modified = this.performOp(selGeom, toAdd, toRemove, toClean::add);
        if (!modified) {
            return;
        }
        md.beginWrite();
        try {
            Undo.begin(this.getOpName());
            Undo.insertUndoEntry_add(md, toRemove);
            for (IEgressOccupiable geom : toRemove) {
                Composite parent = (Composite)md.hierarchy.getParent(geom);
                parent.remove(geom);
            }
            Delete.deleteAll(md, toRemove);
            NewCompUtil.addEgressComps(md, true, toAdd);
            EgressRoom.cleanup(md, toClean);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    protected abstract String getOpName();

    protected abstract boolean performOp(Set<? extends IEgressOccupiable> var1, Collection<IEgressComp> var2, Collection<IEgressOccupiable> var3, Consumer<EgressRoom> var4);
}

