/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.io.FileUtil;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import thunderheadeng.gui.Win32;

public class ShowFile
extends AMerlinOp {
    public static final UIHook SHOW_SUMMARY_HOOK = new UIHook(new ShowFile(new IFilename(){

        @Override
        public File get(File parentFile, String rootFn) {
            return FileUtil.getSummaryFn(parentFile, rootFn);
        }
    }), Intl.intl("Show Summary File"));
    public static final UIHook SHOW_PERFORMANCE_HOOK = new UIHook(new ShowFile(new IFilename(){

        @Override
        public File get(File parentFile, String rootFn) {
            return FileUtil.getPerformanceFn(parentFile, rootFn);
        }
    }), Intl.intl("Show Performance File"));
    public static final UIHook SHOW_REPORT_HOOK = new UIHook((MerlinOp)new ShowFile(new IFilename(){

        @Override
        public File get(File parentFile, String rootFn) {
            return FileUtil.getReportFn(parentFile, rootFn);
        }
    }), Intl.intl("Show PDF Report"), 1);
    private final IFilename d_filename;

    public ShowFile(IFilename filename) {
        this.d_filename = filename;
    }

    private File getDefaultFile(MerlinData md) {
        if (md.filename != null) {
            File f = new File(md.filename);
            String rootFn = InfernoUtil.rootFn(f.getPath());
            return this.d_filename.get(f.getParentFile(), rootFn);
        }
        return null;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        File file = this.getDefaultFile(md);
        if (file != null && file.exists()) {
            try {
                Win32.launchViaExtension(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String msg = Intl.intl("Unable to locate file. Have you run the simulation?");
            JOptionPane.showMessageDialog(app.getMainFrame(), msg);
        }
    }

    private static interface IFilename {
        public File get(File var1, String var2);
    }
}

