/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.ReorderGroupOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ReversePathAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CONTEXT_HOOK = new UIHook(new ReversePathAction(), Intl.intl("Reverse Path Direction"));

    public ReversePathAction() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(QueuePath.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginRead();
        Map<Object, Object> paths = Collections.emptyMap();
        MerlinSelectionModel sel = null;
        try {
            paths = md.selection.getSelected(QueuePath.class).stream().collect(Collectors.toMap(path -> path, path -> path.getMembers(QueuePathNode.class)));
            sel = md.selection;
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        Undo.begin(Intl.intl("Reverse Queue Path(s)"));
        try {
            for (Map.Entry<Object, Object> pathNodePair : paths.entrySet()) {
                ArrayList oldNodeOrder = new ArrayList((Collection)pathNodePair.getValue());
                ArrayList newNodeOrder = new ArrayList((Collection)pathNodePair.getValue());
                Collections.reverse(newNodeOrder);
                ReorderGroupOp op = new ReorderGroupOp((Composite)pathNodePair.getKey(), oldNodeOrder, newNodeOrder);
                Undo.insertEntry(md, op.perform(sel));
            }
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }
}

