/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Random;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IOrientable;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import org.jscience.physics.units.NonSI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class RandomizeOrientAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RandomizeOrientAction(), Intl.intl("Randomize Orientation,-,Randomizes the orientations of the selected occupants or occupant targets."));
    private static final Random s_rand = new Random(176124713L);

    public RandomizeOrientAction() {
        SelectionObserver.add(this, IOrientable.class);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        try {
            Set objs = md.selection.getDeepSelected(IOrientable.class);
            Undo.begin(Intl.intl("Randomize Orientation"));
            Undo.insertUndoEntry_restore(md, theUtil.filter(objs, IRestorable.class));
            for (IOrientable obj : objs) {
                obj.setOrient(new UnitDouble(s_rand.nextDouble() * 360.0 - 180.0, NonSI.DEGREE_ANGLE));
            }
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    @Override
    public void update(Events events) {
        MerlinSelectionModel sel = MerlinApp.getApp().getData().selection;
        this.setEnabled(!sel.isDeepEmpty(IOrientable.class));
    }
}

