/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleUnaryOperator;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.OccTarget;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.MerlinUDF;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import merlin.mv.tools.IPointPickListener;
import thunderheadeng.geometry.Util;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;

public class PrioritizeOccTargetOnDist
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new PrioritizeOccTargetOnDist(), Intl.intl("Prioritize Occ Targets on distance...,-,Assigns priorities to selected Occupant Targets based on their distance to a point."), 1);
    private PrioritizeParams d_prevParams = new PrioritizeParams();

    public PrioritizeOccTargetOnDist() {
        SelectionObserver.add(this, OccTarget.class);
        this.update(null);
    }

    @Override
    public void run(final MerlinApp app, final MerlinData md) {
        final ModelView mv = app.getModelView();
        final Set targets = md.selection.getDeepSelected(OccTarget.class);
        mv.getRenderComp().requestFocus();
        guiDialog dlg = new guiDialog((Window)app.getMainFrame(), Intl.intl("Choose Reference Point"), 9);
        guiPanel panel = dlg.getDialogPane();
        GridBagHelper gb = new GridBagHelper(panel);
        guiPanel pointPnl = new guiPanel();
        GridBagHelper gb2 = new GridBagHelper(pointPnl);
        final MerlinUDF xFld = new MerlinUDF(this.d_prevParams.ref.x, Geometry.LENGTH_UNIT);
        final MerlinUDF yFld = new MerlinUDF(this.d_prevParams.ref.y, Geometry.LENGTH_UNIT);
        final MerlinUDF zFld = new MerlinUDF(this.d_prevParams.ref.z, Geometry.LENGTH_UNIT);
        final guiDoubleField minPriority = new guiDoubleField(this.d_prevParams.minPriority);
        final guiDoubleField maxPriority = new guiDoubleField(this.d_prevParams.maxPriority);
        guiLabel binLbl = guiUtil.lbl(Intl.intl("Bin Priority Levels:"), "<html>" + Intl.intl("Specifies whether to bin the priority levels. Binning can help reduce<br>target reservation conflicts and may improve simulation performance."));
        final guiComboBox<PriorityBins> priorityBins = guiUtil.newCombo(bin -> guiUtil.encodeToHtmlLabel(bin.name, bin.desc), PriorityBins.values());
        priorityBins.setSelectedItem((Object)this.d_prevParams.bins);
        guiLabel numBinsLbl = guiUtil.lbl(Intl.intl("Number of bins:"), "<html>" + Intl.intl("The number of priority levels to generate. Smaller values will reduce<br>the number of reservation conflicts and may increase simulation performance."));
        final guiIntField numBins = new guiIntField(this.d_prevParams.numLevels, IntVR.above(2, true));
        Runnable updateLevelsStatus = () -> {
            boolean enabled = ((PriorityBins)((Object)((Object)priorityBins.getSelectedItem()))).isBinned;
            numBinsLbl.setEnabled(enabled);
            numBins.setEnabled(enabled);
        };
        updateLevelsStatus.run();
        priorityBins.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                updateLevelsStatus.run();
            }
        });
        gb2.addRow(Intl.intl("X:"), xFld, 1.0);
        gb2.addRow(Intl.intl("Y:"), yFld, 1.0);
        gb2.addRow(Intl.intl("Z:"), zFld, 1.0);
        gb2.finalizeRows();
        gb.addRow("<html>" + Intl.intl("Enter a reference point or select one <br>by clicking on the navigation mesh.") + "</html>", 0, 1.0);
        gb.addIdentRow(pointPnl, 0, 1.0);
        gb.addRow(guiUtil.lbl(Intl.intl("Closest priority:"), Intl.intl("The priority to assign to the closest target.")), minPriority, 1.0);
        gb.addRow(guiUtil.lbl(Intl.intl("Farthest priority:"), Intl.intl("The priority to assign to the farthest target.")), maxPriority, 1.0);
        gb.addRow(binLbl, priorityBins, 1.0);
        gb.addIdentRow(numBinsLbl, numBins, 1.0);
        gb.finalizeRows();
        dlg.addDlgListener(new AbstractDlgListener(){

            @Override
            public void okPressed() {
                mv.stopChoosingPoints();
                Point3d target = new Point3d(((UnitDouble)xFld.getValue()).getValue(Geometry.LENGTH_UNIT), ((UnitDouble)yFld.getValue()).getValue(Geometry.LENGTH_UNIT), ((UnitDouble)zFld.getValue()).getValue(Geometry.LENGTH_UNIT));
                PrioritizeOccTargetOnDist.this.d_prevParams = new PrioritizeParams(target, (Double)minPriority.getValue(), (Double)maxPriority.getValue(), (PriorityBins)((Object)priorityBins.getSelectedItem()), (Integer)numBins.getValue());
                PrioritizeOccTargetOnDist.orientAgentsOn(app, md, targets, PrioritizeOccTargetOnDist.this.d_prevParams);
                md.selection.selectAll(targets);
            }

            @Override
            public void cancelPressed() {
                mv.stopChoosingPoints();
                md.selection.selectAll(targets);
            }

            @Override
            public void closePressed() {
                mv.stopChoosingPoints();
                md.selection.selectAll(targets);
            }
        });
        IPointPickListener listener = new IPointPickListener(){

            @Override
            public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                if (p != null) {
                    xFld.setValue(p.xu());
                    yFld.setValue(p.yu());
                    zFld.setValue(p.zu());
                }
            }

            @Override
            public void stopPicking() {
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
                return new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }

            @Override
            public boolean allowPickFromFloorZ() {
                return true;
            }
        };
        dlg.doModeless();
        mv.startChoosingPoints(listener);
    }

    private static void orientAgentsOn(MerlinApp app, MerlinData md, final Set<? extends OccTarget> objs, final PrioritizeParams params) {
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                Undo.begin(Intl.intl("Prioritize on Distance"));
                try {
                    Undo.insertUndoEntry_propRestore(md, objs, OccTarget.PRIORITY);
                    BiConsumer<OccTarget, Double> setPriority = (target, priority) -> target.set(OccTarget.PRIORITY, priority);
                    if (objs.size() == 1) {
                        setPriority.accept((OccTarget)objs.iterator().next(), params.minPriority);
                        return;
                    }
                    ArrayList<Pair<OccTarget, Double>> dists = new ArrayList<Pair<OccTarget, Double>>(objs.size());
                    double minDist = Double.POSITIVE_INFINITY;
                    double maxDist = Double.NEGATIVE_INFINITY;
                    for (OccTarget obj : objs) {
                        Point3d p = obj.get(OccTarget.LOCATION);
                        double dist = p.distance(params.ref);
                        if (dist < minDist) {
                            minDist = dist;
                        }
                        if (dist > maxDist) {
                            maxDist = dist;
                        }
                        dists.add(new Pair<OccTarget, Double>(obj, dist));
                    }
                    DoubleUnaryOperator bin = params.bins.getBinner(params.numLevels);
                    if (params.bins == PriorityBins.EVENLY) {
                        Collections.sort(dists, (d1, d2) -> Double.compare((Double)d1.v2, (Double)d2.v2));
                        double range = params.maxPriority - params.minPriority;
                        for (int m = 0; m < dists.size(); ++m) {
                            double v = (double)m / (double)(dists.size() - 1);
                            double d = params.minPriority + range * bin.applyAsDouble(v);
                            setPriority.accept((OccTarget)((Pair)dists.get((int)m)).v1, d);
                        }
                    } else {
                        double iDistRange = 1.0 / (maxDist - minDist);
                        double priorityRange = params.maxPriority - params.minPriority;
                        for (Pair pair : dists) {
                            double v = ((Double)pair.v2 - minDist) * iDistRange;
                            double rv = bin.applyAsDouble(v);
                            double val = params.minPriority + priorityRange * rv;
                            setPriority.accept((OccTarget)pair.v1, val);
                        }
                    }
                }
                finally {
                    Undo.end(md);
                    md.endWrite();
                }
            }
        };
        UIHook.run(app.getMainFrame(), "PrioritizeOccTargetOnDist.run", op, 0);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(OccTarget.class));
    }

    private static class PrioritizeParams {
        public final Point3d ref;
        public final double minPriority;
        public final double maxPriority;
        public final PriorityBins bins;
        public final int numLevels;

        public PrioritizeParams() {
            this(new Point3d(), 0.0, 10.0, PriorityBins.DISTANCE, 10);
        }

        public PrioritizeParams(Point3d ref, double minPriority, double maxPriority, PriorityBins bins, int numLevels) {
            this.ref = ref;
            this.minPriority = minPriority;
            this.maxPriority = maxPriority;
            this.bins = bins;
            this.numLevels = numLevels;
        }
    }

    private static enum PriorityBins {
        NONE(Intl.intl("Disabled"), Intl.intl("Binning is disabled. Each Occupant Target receives its own\npriority level, which can lead to excessive reservation conflicts\n and negatively affect simulation performance."), false),
        DISTANCE(Intl.intl("By Distance"), Intl.intl("Priority levels are binned according to each target's distance, normalized\nagainst the targets closest and farthest from the reference point."), true),
        EVENLY(Intl.intl("Evenly"), Intl.intl("Priority levels are binned such that the levels are distributed evenly\namong the selected Occupant Targets."), true);

        public final String name;
        public final String desc;
        public boolean isBinned;

        private PriorityBins(String name, String desc, boolean isBinned) {
            this.name = name;
            this.desc = desc;
            this.isBinned = isBinned;
        }

        DoubleUnaryOperator getBinner(int numBins) {
            if (!this.isBinned) {
                return v -> v;
            }
            double ftol = 1.0 / (double)numBins;
            double scale = 1.0 / (double)(numBins - 1);
            return v -> Util.clampT(Math.floor(v / ftol) * scale, 0.0, 1.0);
        }
    }
}

