/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.FloorSortActions;
import merlin.actions.ReorderGroupOp;
import merlin.actions.SetActiveFloor;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.geom.IEgressComp;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.NewFloorDlg;
import merlin.mv.ModelView;
import merlin.mv.tools.ZPickListener;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class NewFloor
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new NewFloor(), Intl.intl("New Floor..."));
    private boolean d_resortComps = true;

    @Override
    public void run(MerlinApp app, final MerlinData md) {
        final ModelView mv = app.getModelView();
        final NewFloorDlg dlg = new NewFloorDlg(app.getMainFrame());
        dlg.setAutoResort(this.d_resortComps);
        ZPickListener pickListener = new ZPickListener(){
            final Set<UnitDouble> pickedHeights = new HashSet<UnitDouble>();

            @Override
            public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                dlg.setFloorLoc(p.zu());
            }

            @Override
            public void stopPicking() {
            }
        };
        dlg.addDlgListener(new AbstractDlgListener(){

            @Override
            public void okPressed() {
                NewFloor.this.d_resortComps = dlg.getAutoResort();
                NewFloor.createFloorOp(null, md, dlg.getFloorLoc(), dlg.setActive(), NewFloor.this.d_resortComps);
                mv.stopChoosingPoints();
            }

            @Override
            public void cancelPressed() {
                mv.stopChoosingPoints();
            }

            @Override
            public void closePressed() {
                mv.stopChoosingPoints();
            }
        });
        dlg.doModeless();
        md.ui(() -> mv.startChoosingPoints(pickListener));
    }

    private static void createFloorOp(Component c, MerlinData md, final UnitDouble loc, final boolean setActive, final boolean resortComps) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    Undo.begin(Intl.intl("New Floor"));
                    NewFloor.createFloor(md, loc, setActive, resortComps);
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
            }
        };
        UIHook.run(c, "NewFloor.createFloorOp", op, 0);
    }

    public static Floor createFloor(MerlinData md, UnitDouble loc, boolean setActive, boolean resortComponents) {
        Floor newFloor = new Floor(loc);
        Undo.insertUndoEntry_restore(md, md.floors);
        md.floors.add(newFloor);
        ReorderGroupOp reorderOp = new ReorderGroupOp(md.floors, new ArrayList<Floor>(md.floors.getMembers(Floor.class)), NewFloor.sortFloors(md));
        Undo.insertEntry(md, reorderOp.perform(md.selection));
        if (resortComponents) {
            NewFloor.resortEgressComponents(md, newFloor);
        }
        if (setActive) {
            SetActiveFloor.setActiveFloor2(md, newFloor);
        }
        return newFloor;
    }

    private static List<Floor> sortFloors(MerlinData md) {
        ArrayList<Floor> sorted = new ArrayList<Floor>(md.floors.getMembers(Floor.class));
        Collections.sort(sorted, new Comparator<Floor>(){

            @Override
            public int compare(Floor o1, Floor o2) {
                return o1.getWorkingZ().compareTo(o2.getWorkingZ());
            }
        });
        return sorted;
    }

    private static void resortEgressComponents(MerlinData md, Floor newFloor) {
        Floor[] surrFloors = md.floors.getSurroundingFloors(newFloor.getWorkingZ(), 0.0);
        assert (surrFloors[0] == newFloor);
        Floor nextFloor = surrFloors[1];
        Plane3d plane1 = NewFloor.getWorkingPlane(newFloor, -1.0);
        Plane3d plane2 = nextFloor != null ? NewFloor.getWorkingPlane(nextFloor, 1.0) : null;
        ConvexHull ch = nextFloor != null ? new ConvexHull(plane1, plane2) : new ConvexHull(plane1);
        List<Object> components = new ArrayList();
        md.geomLocation.getLocator().find((ITest<AABox>)ch, new CollResult(components, IEgressComp.class), 3);
        components = components.stream().filter(comp -> md.hierarchy.isDescendent(md.floors, comp)).collect(Collectors.toList());
        FloorSortActions.resortComponents(md, components, Arrays.asList(newFloor));
    }

    private static Plane3d getWorkingPlane(Floor floor, double zHint) {
        double offset = zHint * 1.0E-6;
        return new Plane3d(0.0, 0.0, zHint, -zHint * floor.getWorkingZ().getValue(Geometry.LENGTH_UNIT) + offset);
    }
}

