/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.IntPredicate;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.objs.node.GeomNodesMerger;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class MergeImportedGeomAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new MergeImportedGeomAction(), Intl.intl("Merge selected objects,-,Merge the selected objects into a single object."));

    public MergeImportedGeomAction() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(MergeImportedGeomAction.testSelection(md));
    }

    public static boolean testSelection(MerlinData md) {
        IFilteredCollection<IMerlinObj> igeom = MergeImportedGeomAction.getObjs(md);
        return !md.selection.flatten(ImportedGeom.class).isEmpty() && MergeImportedGeomAction.testFilteredSize(MerlinUtil.flatten(igeom), size -> size >= 2) && igeom.isExclusive();
    }

    public static IFilteredCollection<IMerlinObj> getObjs(MerlinData md) {
        return md.selection.get(IMerlinObj.class, obj -> obj instanceof ImportedGeom || obj instanceof GeomComposite && md.hierarchy.isDescendent(md.sceneGeom, obj));
    }

    private static boolean testFilteredSize(Collection<?> coll, IntPredicate testSize) {
        int size = 0;
        if (testSize.test(size)) {
            return true;
        }
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            if (testSize.test(++size)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Optional<Runnable> task = MergeImportedGeomAction.startUiMerge(app, md, MergeImportedGeomAction.getObjs(md));
        if (!task.isPresent()) {
            return;
        }
        task.get().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Runnable> startUiMerge(MerlinApp app, MerlinData md, Collection<IMerlinObj> objs) {
        GeomComposite parent;
        ImportedGeom toAdd;
        Runnable delTask = () -> {};
        md.beginRead();
        try {
            ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>(objs);
            Collection<ImportedGeom> igeoms = MerlinUtil.flatten(objs, ImportedGeom.class);
            ImportType importType = igeoms.iterator().next().getImportedType();
            Collection<ImportType> importTypes = theUtil.map(igeoms, ig -> ig.get(ImportedGeom.PROP_IMPORTED_TYPE));
            if (!theUtil.isUniform(importTypes)) {
                Pair<ImportType, Integer> maxType = theUtil.getMaxOccurrence(importTypes, ImportType.class);
                assert (maxType != null);
                importType = (ImportType)((Object)maxType.v1);
                int option = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), String.format("<html>" + Intl.intl("The selected objects have different <b>Import Types</b>. The resulting object be assigned<br>\"%s\", which can be changed in the property panel."), ((ImportType)((Object)((Object)maxType.v1))).name), Intl.intl("Different BIM Types"), 2, 2));
                if (option != 0) {
                    Optional<Runnable> optional = Optional.empty();
                    return optional;
                }
            }
            Pair<Delete.DelStatus, Runnable> status = Delete.startUiDelete(app, md, toRemove, false);
            if (status.v1 != Delete.DelStatus.SUCCESS) {
                Optional<Runnable> option = Optional.empty();
                return option;
            }
            delTask = (Runnable)status.v2;
            toAdd = MergeImportedGeomAction.merge(igeoms, MerlinUtil.getName((IMerlinObj)toRemove.iterator().next()), importType);
            Object commonParent = md.hierarchy.getCommonParent(toRemove);
            parent = commonParent instanceof GeomComposite && md.hierarchy.isDescendent(md.sceneGeom, commonParent) ? (GeomComposite)commonParent : md.sceneGeom;
        }
        finally {
            md.endRead();
        }
        Runnable deleteTask = delTask;
        return Optional.of(() -> {
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Merge objects"));
                deleteTask.run();
                AddObject.add(md, parent, Collections.singleton(toAdd));
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        });
    }

    public static ImportedGeom merge(Collection<ImportedGeom> igeoms, String name, ImportType itype) {
        assert (!igeoms.isEmpty());
        ImportedGeom first = igeoms.iterator().next();
        if (igeoms.size() == 1) {
            return first;
        }
        GeomNodesMerger builder = new GeomNodesMerger();
        PropsBuilder props = new PropsBuilder();
        for (ImportedGeom obj : igeoms) {
            IGeomNode geom = obj.getGeom();
            int numPrims = geom.getNumPrims(7);
            props.add(obj.getDisplayProps(), numPrims);
            builder.add(geom, numPrims);
        }
        IGeomNode node = builder.finish();
        ImportedGeom merged = first.clone();
        merged.setName(name);
        merged.setGeom(node);
        merged.setDisplayProps(props.finalizeProps());
        merged.setImportedType(itype);
        return merged;
    }
}

