/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.scripting.ScriptObj;
import merlin.gui.ManagerDlg;
import merlin.gui.scripting.ScriptDlg;

public class EditCustomScripts
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditCustomScripts(), Intl.intl("Edit Custom Scripts..."));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        EditCustomScripts.edit(app, md, null);
    }

    public static void edit(final MerlinApp app, final MerlinData md, final ScriptObj init) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                CompositeManager mgr = new CompositeManager(md, md.customScripts);
                ScriptDlg dlg = new ScriptDlg(app.getMainFrame(), app.getUnitSystem());
                dlg.init(md, mgr, init);
                dlg.doModal();
            }
        };
        md.uiLater(runner);
    }

    public static class CompositeManager
    implements ManagerDlg.IManager<ScriptObj> {
        private final MerlinData d_md;
        private Composite<? super ScriptObj> d_objs;

        public CompositeManager(MerlinData md, Composite<? super ScriptObj> objs) {
            this.d_md = md;
            this.d_objs = objs;
        }

        @Override
        public String describe(ScriptObj oProf) {
            this.d_md.beginRead();
            String name = oProf.getName();
            this.d_md.endRead();
            return name;
        }

        @Override
        public Collection<ScriptObj> getSorted() {
            this.d_md.beginRead();
            ArrayList<ICompElement> sorted = new ArrayList<ICompElement>(this.d_objs.getMembers());
            this.d_md.endRead();
            return sorted;
        }

        @Override
        public int size() {
            this.d_md.beginRead();
            int size = this.d_objs.getMembers().size();
            this.d_md.endRead();
            return size;
        }
    }
}

