/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.SetWorkingGroup;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.NewCompUtil;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinHierarchy;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Proxy;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.material.Material;
import merlin.gui.MerlinComboBox;
import merlin.gui.ProfilesPanel;
import merlin.gui.VehicleShapesPanel;
import merlin.gui.guiUtil;
import merlin.util.Dependencies;
import merlin.util.EgressDoorListCellRenderer;
import merlin.util.EgressDoorNameComparator;
import merlin.util.MerlinUtil;
import merlin.util.OccProfileListCellRenderer;
import merlin.util.OccProfileNameComparator;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class Delete
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Delete16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Delete(), Intl.intl("&Delete...,D,Delete selected objects"), ICON);

    public Delete() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private boolean canDelete(MerlinData md) {
        return !md.selection.isEmpty();
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(this.canDelete(md));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set explicitSelObjs;
        md.beginRead();
        try {
            explicitSelObjs = md.selection.getSelected(IMerlinObj.class);
        }
        finally {
            md.endRead();
        }
        Delete.uiDelete(app, md, explicitSelObjs, true);
    }

    public static DelStatus uiDelete(MerlinApp app, MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        Pair<DelStatus, Runnable> result = Delete.startUiDelete(app, md, explicitSelObjs, confirmDel);
        if (result.v1 != DelStatus.SUCCESS) {
            return (DelStatus)((Object)result.v1);
        }
        ((Runnable)result.v2).run();
        return (DelStatus)((Object)result.v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Pair<DelStatus, Runnable> startUiDelete(MerlinApp app, MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        List<PropReplacement> replacements;
        boolean undoable;
        LinkedIdentityHashSet<IMerlinObj> selObjs;
        ArrayList<IEgressComp> addObjs = new ArrayList<IEgressComp>();
        md.beginRead();
        try {
            selObjs = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)explicitSelObjs);
            Delete.getOtherDeletes(md, explicitSelObjs, selObjs);
            Delete.flattenRoots(md, selObjs);
            try {
                Delete.removeNonDelObjs(md, selObjs);
            }
            catch (Exception e) {
                guiDialog.showInvalidEntryMessage(app.getActiveFrame(), e.getLocalizedMessage());
                Pair<DelStatus, Object> pair2 = new Pair<DelStatus, Object>(DelStatus.DEL_FAILED, null);
                md.endRead();
                return pair2;
            }
            Delete.calcAutoDeleteProxies(md, selObjs);
            Delete.calcAutoDeletes(md, selObjs);
            int selCount = selObjs.size();
            if (selCount == 0) {
                Pair<DelStatus, Runnable> pair3 = new Pair<DelStatus, Runnable>(DelStatus.SUCCESS, () -> {});
                return pair3;
            }
            for (Object e : selObjs) {
                selCount += md.hierarchy.getNumChildren(e);
            }
            int selGroupCount = 0;
            for (Object e : selObjs) {
                if (!(e instanceof Composite)) continue;
                --selCount;
                ++selGroupCount;
            }
            undoable = Delete.isDelUndoable(md, selObjs);
            if (confirmDel || !undoable) {
                void var11_23;
                String string;
                String string2 = selGroupCount == 1 ? Intl.intl("1 group") : String.format(Intl.intl("%d groups"), selGroupCount);
                String string3 = string = selCount == 1 ? String.format(Intl.intl("Are you sure you want to remove 1 object (%s)?"), string2) : String.format(Intl.intl("Are you sure you want to remove %1$d objects (%2$s)?"), selCount, string2);
                if (!undoable) {
                    String string4 = string + "<br>" + Intl.intl("<b>NOTE:</b> This operation cannot be undone.");
                }
                String string5 = "<html>" + (String)var11_23 + "</html>";
                int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), string5, Intl.intl("Remove?"), 0, 3);
                if (option != 0) {
                    Pair<DelStatus, Object> pair = new Pair<DelStatus, Object>(DelStatus.NOT_DELETED, null);
                    return pair;
                }
            }
            try {
                replacements = Delete.getReplacements(selObjs, app, md);
            }
            catch (CancelledException cancelledException) {
                Pair<DelStatus, Object> pair = new Pair<DelStatus, Object>(DelStatus.CANCELLED, null);
                md.endRead();
                return pair;
            }
            if (!MerlinUtil.filter(selObjs, Elevator.class).isEmpty()) {
                int n = JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Would you like to restore the rooms used to create the elevators?"), Intl.intl("Restore Original Rooms?"), 1);
                if (n == 0) {
                    for (Elevator elevator : MerlinUtil.filter(selObjs, Elevator.class)) {
                        Delete.convertElevatorDischargeComps(elevator, addObjs);
                    }
                } else if (n != 1) {
                    Pair<DelStatus, Object> pair = new Pair<DelStatus, Object>(DelStatus.CANCELLED, null);
                    return pair;
                }
            }
        }
        finally {
            md.endRead();
        }
        ArrayList<? extends IMerlinObj> restoreSel = new ArrayList<IMerlinObj>(explicitSelObjs);
        Runnable deleteFunc = () -> {
            md.beginWrite();
            try {
                IFilteredCollection<OccGroupTypeObj> groupTemplatesToDel;
                IFilteredCollection<Proxy> proxiesToDel;
                IFilteredCollection<IMerlinObj> compsToDel;
                IFilteredCollection<EgressAgent> agentsToDel;
                Undo.begin(Intl.intl("Delete"));
                if (!undoable) {
                    Undo.insertEntry_breakChain(md);
                }
                if (!(agentsToDel = MerlinUtil.filter(selObjs, EgressAgent.class)).isEmpty()) {
                    AssistedEvacTeam.removeAgentsFromAssistedEvacTeams(agentsToDel, true);
                }
                if (!(compsToDel = MerlinUtil.filter(selObjs, IMerlinObj.class)).isEmpty()) {
                    OccProfile.removeCompsFromProfReferences(md, compsToDel);
                }
                if (!(proxiesToDel = MerlinUtil.filter(selObjs, Proxy.class)).isEmpty()) {
                    OccGroupObj.removeAgentsFromGroupLeaderReferences(md, proxiesToDel);
                }
                if (!(groupTemplatesToDel = MerlinUtil.filter(selObjs, OccGroupTypeObj.class)).isEmpty()) {
                    OccSourceObj.removeOccGroupTemplatesReferences(md, groupTemplatesToDel);
                }
                Delete.restoreSelection(md, restoreSel);
                for (PropReplacement repl : replacements) {
                    repl.perform(md);
                }
                Delete.deleteAll(md, selObjs);
                NewCompUtil.addEgressComps(md, true, addObjs);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
            if (md.agents.getDeepMembers().isEmpty()) {
                md.occNameGen.reset();
            }
        };
        return new Pair<DelStatus, Runnable>(DelStatus.SUCCESS, deleteFunc);
    }

    private static void calcAutoDeleteProxies(MerlinData md, Set<IMerlinObj> selObjs) {
        Collection<ICompElement> flattenedObjs = MerlinUtil.flatten(selObjs, ICompElement.class);
        LinkedHashSet<Proxy<? extends ICompElement>> proxies = new LinkedHashSet<Proxy<? extends ICompElement>>();
        for (ICompElement obj : flattenedObjs) {
            Set<Proxy<? extends ICompElement>> objProxies = md.proxies.getProxies(obj);
            proxies.addAll(objProxies);
        }
        selObjs.addAll(proxies);
    }

    private static void convertElevatorDischargeComps(Elevator elevator, List<IEgressComp> comps) {
        ElevatorRoom er = elevator.getDischargeRoom();
        comps.add(new EgressRoom(er.getName(), er.getModel(), 0));
        for (ElevatorDoor ed : er.getElevatorDoors()) {
            comps.add(new EgressDoor(ed.getName(), false, ed.getRoom1(), ed.getRoom2(), ed.getDoorGeom()));
        }
    }

    private static void getOtherDeletes(MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, Set<IMerlinObj> selObjs) {
        for (IMerlinObj iMerlinObj : explicitSelObjs) {
            EntryPointFactory.get(iMerlinObj).getOtherDeleteObjs(md, selObjs, iMerlinObj);
        }
    }

    private static void flattenRoots(MerlinData md, Set<IMerlinObj> selObjs) {
        for (IMerlinObj iMerlinObj : md.getChildren()) {
            if (!selObjs.contains(iMerlinObj)) continue;
            selObjs.remove(iMerlinObj);
            selObjs.addAll(iMerlinObj.getChildren());
        }
    }

    private static void removeNonDelObjs(MerlinData md, Set<IMerlinObj> objs) throws Exception {
        Exception firstExp = null;
        ArrayList<IMerlinObj> nonDels = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            try {
                EntryPointFactory.get(obj).checkDelete(md, obj, objs);
            }
            catch (Exception e) {
                if (firstExp == null) {
                    firstExp = e;
                }
                nonDels.add(obj);
            }
        }
        objs.removeAll(nonDels);
        if (firstExp != null && objs.isEmpty()) {
            throw firstExp;
        }
    }

    private static void calcAutoDeletes(MerlinData md, Set<IMerlinObj> objs) {
        Set<IMerlinObj> autoDeleteGroups = Delete.getAutoDeleteGroups(md, objs);
        while (!autoDeleteGroups.isEmpty()) {
            for (IMerlinObj group : autoDeleteGroups) {
                if (!objs.contains(group) && !objs.containsAll(group.getChildren())) continue;
                objs.removeAll(group.getChildren());
                objs.add(group);
            }
            autoDeleteGroups = Delete.getAutoDeleteGroups(md, autoDeleteGroups);
        }
    }

    private static Set<IMerlinObj> getAutoDeleteGroups(MerlinData md, Set<IMerlinObj> objs) {
        LinkedIdentityHashSet<IMerlinObj> autoDeleteParents = new LinkedIdentityHashSet<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            IMerlinObj parent = (IMerlinObj)md.hierarchy.getParent(obj);
            if (!EntryPointFactory.get(parent).isAutoDeleteGroup(md, parent)) continue;
            autoDeleteParents.add(parent);
        }
        return autoDeleteParents;
    }

    public static Set<IMerlinObj> collectObjs(MerlinData md, Set<? extends IMerlinObj> explicit) {
        LinkedIdentityHashSet<IMerlinObj> allRelated = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)explicit);
        for (IMerlinObj iMerlinObj : explicit) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            if (ep == null) continue;
            ep.getOtherDeleteObjs(md, allRelated, iMerlinObj);
        }
        return allRelated;
    }

    private static boolean isDelUndoable(MerlinData md, Collection<? extends IMerlinObj> objs) {
        return !MerlinUtil.flatten(objs, Material.class).stream().anyMatch(mat -> md.materials.isPermanent((Material)mat));
    }

    private static DepSnapshot finalizeDelSet(MerlinData md, Set<? extends IMerlinObj> explicitDel, Set<IMerlinObj> finalDelSet) {
        DepSnapshot deps = new DepSnapshot();
        deps.start(md, md.getChildren());
        ArrayDeque<? extends IMerlinObj> open = new ArrayDeque<IMerlinObj>(explicitDel);
        IdentityHashSet<? extends IMerlinObj> closed = new IdentityHashSet<IMerlinObj>(explicitDel);
        while (!open.isEmpty()) {
            IMerlinObj obj = (IMerlinObj)open.removeFirst();
            Set<Dependency> objDeps = deps.getDependents(obj);
            if (objDeps.stream().anyMatch(dep -> dep.link == DLink.REQUIRED)) continue;
            finalDelSet.add(obj);
            for (Dependency dep2 : objDeps) {
                if (dep2.link != DLink.STRONG) continue;
                Consumer<IMerlinObj> addObj = mobj -> {
                    if (closed.add(mobj)) {
                        open.addLast((IMerlinObj)mobj);
                    }
                };
                if (dep2.source instanceof IMerlinObj) {
                    addObj.accept((IMerlinObj)((Object)dep2.source));
                    continue;
                }
                for (IMerlinObj ancestor : deps.getAncestors(IMerlinObj.class, dep2.source)) {
                    addObj.accept(ancestor);
                }
            }
        }
        return deps;
    }

    public static void deleteAll(MerlinData md, Set<? extends IMerlinObj> objs) {
        if (objs.isEmpty()) {
            return;
        }
        Delete.restoreSelection(md, objs);
        LinkedIdentityHashSet doors = new LinkedIdentityHashSet();
        for (IMerlinObj iMerlinObj : objs) {
            if (!(iMerlinObj instanceof EgressRoom)) continue;
            Set<IEgressConnector> connections = ((EgressRoom)iMerlinObj).getDoors();
            for (IEgressConnector iEgressConnector : connections) {
                doors.add(iEgressConnector);
            }
        }
        if (!doors.isEmpty()) {
            Undo.insertUndoEntry_restore(md, doors);
        }
        List<Floor> delWorkingGroups = Delete.getDeletingWorkingGroups(md, objs);
        for (Floor floor : delWorkingGroups) {
            SetWorkingGroup.setWorkingGroup(md, floor, floor);
        }
        LinkedIdentityHashSet<IMerlinObj> linkedIdentityHashSet = new LinkedIdentityHashSet<IMerlinObj>();
        DepSnapshot deps = Delete.finalizeDelSet(md, objs, linkedIdentityHashSet);
        objs = linkedIdentityHashSet;
        for (IMerlinObj iMerlinObj : objs) {
            Set<Dependency> objDeps = deps.getDependents(iMerlinObj);
            for (Dependency dep : objDeps) {
                if (dep.link != DLink.WEAK) continue;
                if (dep.source instanceof IRestorable) {
                    Undo.insertUndoEntry_restore(md, (IRestorable)((Object)dep.source));
                } else {
                    for (IRestorable restorable : deps.getAncestors(IRestorable.class, dep.source)) {
                        Undo.insertUndoEntry_restore(md, restorable);
                    }
                }
                dep.source.replaceDependency(md, iMerlinObj, null);
            }
        }
        for (IMerlinObj iMerlinObj : objs) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            if (ep == null) continue;
            if (ep.isIndexed(md, iMerlinObj)) {
                Undo.insertUndoEntry_insert(md, iMerlinObj);
            } else {
                Undo.insertUndoEntry_add(md, iMerlinObj);
            }
            ep.delete(md, iMerlinObj);
        }
    }

    private static void restoreSelection(MerlinData md, Collection<? extends IMerlinObj> objs) {
        IFilteredCollection<IMerlinObj> selectedObjs = theUtil.filter(objs, o -> md.selection.isSelected(o));
        for (IMerlinObj obj : selectedObjs) {
            if (obj instanceof IRestorable) {
                Undo.insertUndoEntry_restore(md, (IRestorable)((Object)obj));
            }
            md.selection.deselect(obj);
        }
    }

    private static List<Floor> getDeletingWorkingGroups(MerlinData md, Set<? extends IMerlinObj> objs) {
        ArrayList<Floor> delActiveGroups = new ArrayList<Floor>();
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            if (Delete.selSetContains(md, objs, floor) || !Delete.selSetContains(md, objs, floor.getWorkingGeomGroup())) continue;
            delActiveGroups.add(floor);
        }
        return delActiveGroups;
    }

    private static boolean selSetContains(MerlinData md, Set<? extends IMerlinObj> selSet, Object o) {
        while (o != null) {
            if (selSet.contains(o)) {
                return true;
            }
            o = md.hierarchy.getParent(o);
        }
        return false;
    }

    private static int countTypes(Collection<?> objs, Class<?> type) {
        int count = 0;
        for (Object obj : objs) {
            if (!type.isInstance(obj)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isSelected(MerlinData md, Set<IMerlinObj> selObjs, Object o) {
        if (o == null) {
            return false;
        }
        return selObjs.contains(o) || Delete.isSelected(md, selObjs, md.hierarchy.getParent(o));
    }

    public static List<PropReplacement> getReplacements(Set<IMerlinObj> selObjs, MerlinApp app, MerlinData md) throws CancelledException {
        ArrayList<PropReplacement> replacements = new ArrayList<PropReplacement>();
        Predicate<Object> isSelected = o -> Delete.isSelected(md, selObjs, o);
        Delete.getProfileRepl(isSelected, app, md, replacements);
        Delete.getVehicleShapeRepl(isSelected, app, md, replacements);
        Delete.getBehaviorRepl(isSelected, app, md, replacements);
        Delete.getExitRepl(isSelected, app, md, replacements);
        Delete.getElevatorRepl(isSelected, app, md, replacements);
        Delete.getRoomRepl(isSelected, app, md, replacements);
        Delete.getDoorRepl(isSelected, app, md, replacements);
        Delete.getAgentRepl(isSelected, app, md, replacements);
        Delete.getAETeamRepl(isSelected, app, md, replacements);
        Delete.getOccGroupRepl(isSelected, app, md, replacements);
        Delete.getQueueRepl(isSelected, app, md, replacements);
        Delete.getQueueCompRepl(isSelected, app, md, replacements);
        Delete.getAttractorRepl(isSelected, app, md, replacements);
        Delete.getMaterialRepl(isSelected, app, md, replacements);
        Delete.getOccTargetRepl(isSelected, app, md, replacements);
        return replacements;
    }

    /*
     * WARNING - void declaration
     */
    private static void getProfileRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        void var13_25;
        LinkedIdentityHashSet conflictingProfAgents = new LinkedIdentityHashSet();
        IdentityHashSet conflictingProfiles = new IdentityHashSet();
        LinkedIdentityHashSet conflictingProfOccSources = new LinkedIdentityHashSet();
        LinkedIdentityHashSet<OccProfile> conflictingProfOccGroupTypes = new LinkedIdentityHashSet<OccProfile>();
        LinkedIdentityHashSet conflictingProfChangeProfileActions = new LinkedIdentityHashSet();
        ArrayList<EgressAgent> agentsToUpdate = new ArrayList<EgressAgent>();
        for (EgressAgent egressAgent : md.agents.getDeepMembers(EgressAgent.class)) {
            OccProfile occProfile;
            if (isSelected.test(egressAgent) || !isSelected.test((occProfile = egressAgent.getProfile()).getProfParent())) continue;
            conflictingProfiles.add(occProfile.getProfParent());
            conflictingProfAgents.add(occProfile);
            agentsToUpdate.add(egressAgent);
        }
        LinkedHashSet<OccSourceObj> occSourcesToUpdate = new LinkedHashSet<OccSourceObj>();
        for (OccSourceObj occSourceObj : md.occSources.getDeepMembers(OccSourceObj.class)) {
            if (isSelected.test(occSourceObj)) continue;
            Set<OccProfile> set = occSourceObj.get(OccSourceObj.PROP_PROFILE_DIST).getWeights().keySet();
            for (OccProfile occProfile : set) {
                OccProfile occProfile2 = occProfile;
                if (!isSelected.test(occProfile2)) continue;
                conflictingProfiles.add(occProfile2);
                conflictingProfOccSources.add(occProfile2);
                occSourcesToUpdate.add(occSourceObj);
            }
        }
        LinkedHashSet<OccGroupTypeObj> linkedHashSet = new LinkedHashSet<OccGroupTypeObj>();
        for (OccGroupTypeObj occGroupTypeObj : md.occGroupTypes.getDeepMembers(OccGroupTypeObj.class)) {
            if (isSelected.test(occGroupTypeObj)) continue;
            Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profData = occGroupTypeObj.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA);
            for (OccProfile occProfile : profData.keySet()) {
                if (!isSelected.test(occProfile)) continue;
                conflictingProfOccGroupTypes.add(occProfile);
                linkedHashSet.add(occGroupTypeObj);
            }
        }
        LinkedHashSet<ChangeProfile> linkedHashSet2 = new LinkedHashSet<ChangeProfile>();
        for (Behavior behavior : md.behaviors.flatten(Behavior.class)) {
            if (isSelected.test(behavior)) continue;
            for (ChangeProfile changeProfile : behavior.flatten(ChangeProfile.class)) {
                for (OccProfile o : changeProfile.getAllTargetProfiles()) {
                    OccProfile prof = o;
                    if (!isSelected.test(prof)) continue;
                    conflictingProfiles.add(prof);
                    conflictingProfChangeProfileActions.add(prof);
                    linkedHashSet2.add(changeProfile);
                }
            }
        }
        Object var13_23 = null;
        if (!(conflictingProfAgents.isEmpty() && conflictingProfOccSources.isEmpty() && conflictingProfChangeProfileActions.isEmpty())) {
            LinkedIdentityHashSet<OccProfile> availProfs = new LinkedIdentityHashSet<OccProfile>(md.profiles.getDeepMembers(OccProfile.class));
            availProfs.removeIf(isSelected);
            ArrayList<OccProfile> arrayList = new ArrayList<OccProfile>(availProfs);
            Collections.sort(arrayList, new OccProfileNameComparator());
            if (arrayList.size() != 0) {
                guiDialog guiDialog2 = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Profile in Use"), 9);
                guiDialog2.getDialogPane().setLayout(new GridBagLayout());
                guiLabel probDesc = new guiLabel(conflictingProfiles.size() == 1 ? String.format(Intl.intl("Selected profile, %s, is in use."), ((OccProfile)conflictingProfiles.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected behaviors are in use."), conflictingProfiles.size()));
                guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
                guiComboBox<OccProfile> profiles = new guiComboBox<OccProfile>((Collection<OccProfile>)arrayList);
                profiles.setRenderer(new OccProfileListCellRenderer());
                GridBagUtil.add(guiDialog2.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(guiDialog2.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(guiDialog2.getDialogPane(), profiles, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
                if (guiDialog2.doModal() != 1) {
                    throw CancelledException.INSTANCE;
                }
                OccProfile occProfile = profiles.getSelectedItem();
            } else {
                JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("Some occupants are using the selected profiles and are unable to select new ones.\nEither change their profiles manually or create a new profile and try again."), Intl.intl("Profile in Use"), 0);
                throw CancelledException.INSTANCE;
            }
        }
        if (var13_25 != null) {
            if (!conflictingProfAgents.isEmpty()) {
                replacements.add(new AgentsUpdatePropReplacement(OccProfile.PROP_PROF_PARENT, conflictingProfAgents, var13_25, agentsToUpdate, new ProfilesPanel.Op((OccProfile)var13_25, var13_25.getRestoreObj(), md.selection.isSelected(var13_25), agentsToUpdate)));
            }
            if (!conflictingProfOccSources.isEmpty()) {
                List<IUrn<?>> replacementOccSourceProfiles = DistributionUpdatePropReplacement.getReplacements(conflictingProfOccSources, var13_25, occSourcesToUpdate, OccSourceObj.PROP_PROFILE_DIST);
                DistributionUpdatePropReplacement distributionUpdatePropReplacement = new DistributionUpdatePropReplacement(occSourcesToUpdate, replacementOccSourceProfiles, OccSourceObj.PROP_PROFILE_DIST);
                replacements.add(distributionUpdatePropReplacement);
            }
            if (!conflictingProfChangeProfileActions.isEmpty()) {
                List<IUrn<?>> replacementChangeProfileActionsProfiles = DistributionUpdatePropReplacement.getReplacements(conflictingProfChangeProfileActions, var13_25, linkedHashSet2, ChangeProfile.PROP_PROFILE_DIST);
                DistributionUpdatePropReplacement distributionUpdatePropReplacement = new DistributionUpdatePropReplacement(linkedHashSet2, replacementChangeProfileActionsProfiles, ChangeProfile.PROP_PROFILE_DIST);
                replacements.add(distributionUpdatePropReplacement);
            }
        }
        if (!conflictingProfOccGroupTypes.isEmpty()) {
            List<Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj>> replacementOccGroupTypesProfiles = OccGroupTypesUpdatePropReplacement.getReplacements(conflictingProfOccGroupTypes, linkedHashSet);
            OccGroupTypesUpdatePropReplacement occGroupTypesUpdatePropReplacement = new OccGroupTypesUpdatePropReplacement(linkedHashSet, replacementOccGroupTypesProfiles);
            replacements.add(occGroupTypesUpdatePropReplacement);
        }
    }

    private static void getVehicleShapeRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        VehicleShape vs;
        LinkedIdentityHashSet conflictingProfAgents = new LinkedIdentityHashSet();
        IdentityHashSet conflictingVehicleShapes = new IdentityHashSet();
        ArrayList<EgressAgent> agentsToUpdate = new ArrayList<EgressAgent>();
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            if (isSelected.test(agent) || !isSelected.test(vs = agent.getProfile().getProperty(OccProfile.PROP_VEHICLE_SHAPE))) continue;
            if (agent.getProfile().getProfParent() != null && agent.getProfile().isDefinedLocally(OccProfile.PROP_VEHICLE_SHAPE)) {
                conflictingVehicleShapes.add(vs);
                conflictingProfAgents.add(agent.getProfile());
            }
            agentsToUpdate.add(agent);
        }
        for (OccProfile profile : md.profiles.getDeepMembers(OccProfile.class)) {
            if (isSelected.test(profile) || profile.getProfParent() != null || !isSelected.test(vs = profile.getProperty(OccProfile.PROP_VEHICLE_SHAPE))) continue;
            conflictingVehicleShapes.add(vs);
            conflictingProfAgents.add(profile);
        }
        VehicleShape replacementVS = null;
        OccProfile.OccShape replacementShape = null;
        if (!conflictingProfAgents.isEmpty()) {
            MerlinComboBox.MerlinComboBoxWithEmptyOption<VehicleShape> vehicleShapesComboBox = new MerlinComboBox.MerlinComboBoxWithEmptyOption<VehicleShape>(md, VehicleShape.class, Intl.intl("Default cylinder"));
            List<VehicleShape> toRemove = vehicleShapesComboBox.getAllItems().stream().filter(isSelected).collect(Collectors.toList());
            toRemove.forEach(o -> vehicleShapesComboBox.removeItem(o));
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Vehicle Shape in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            guiLabel probDesc = new guiLabel(String.format(Intl.intl("%1$d selected vehicle shapes are being referenced by some occupants or profiles."), conflictingVehicleShapes.size()));
            guiLabel exitLbl = new guiLabel(Intl.intl("Reassign conflicted occupants and profiles to:"));
            GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), vehicleShapesComboBox, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacementVS = (VehicleShape)vehicleShapesComboBox.getSelectedItem();
            replacementShape = new OccProfile.OccShape(replacementVS, (ICurve)OccProfile.PROP_DIAMETER.defVal, (UnitDouble)OccProfile.PROP_GEOM_DIAMETER.defVal, (ICurve)OccProfile.PROP_HEIGHT.defVal, (Double)OccProfile.PROP_MIN_SQUEEZE_FACTOR_CONST.defVal);
        }
        if (replacementShape != null) {
            Object replacementObj = replacementShape.getRestoreObj();
            replacements.add(new AgentsUpdatePropReplacement(OccProfile.PROP_SHAPE, conflictingProfAgents, replacementShape, agentsToUpdate, new VehicleShapesPanel.Op(replacementShape, replacementObj, md.selection.isSelected(replacementShape), agentsToUpdate)));
        }
    }

    private static void getOccTargetRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        ArrayList<GotoOccTarget> gotoOccTargets;
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, OccTarget.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        OccTarget replacement = null;
        if (!referenced.isEmpty()) {
            Predicate<? super IMerlinObj> exclude = isSelected.negate();
            MerlinComboBox replCombo = new MerlinComboBox(md, OccTarget.class, exclude, (IMerlinObj[])new OccTarget[]{null});
            replCombo.setNullName(Intl.intl("<any>"));
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Occupant Target in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            guiLabel probDesc = new guiLabel(referenced.size() == 1 ? String.format(Intl.intl("Selected occupant target, %s, is in use."), ((OccTarget)referenced.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected occupant targets are in use."), referenced.size()));
            guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
            GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), replCombo, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacement = (OccTarget)replCombo.getSelectedItem();
        }
        if (!(gotoOccTargets = new ArrayList<GotoOccTarget>(theUtil.filter(referencing, GotoOccTarget.class))).isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoOccTarget.PROP_TARGETS, gotoOccTargets, referenced, replacement));
        }
    }

    private static void getBehaviorRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, Behavior.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        Behavior replacementBehavior = null;
        if (!referenced.isEmpty()) {
            MerlinComboBox behaviorCB;
            Predicate<? super IMerlinObj> exclude = isSelected.negate();
            ArrayList<Behavior> specialVals = new ArrayList<Behavior>();
            if (referencing.stream().allMatch(r -> r instanceof Attractor)) {
                specialVals.add(Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR);
            }
            if ((behaviorCB = new MerlinComboBox(md, Behavior.class, exclude, (IMerlinObj[])theUtil.toArray(specialVals, Behavior.class))).getModel().getSize() > 0) {
                guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Behavior in Use"), 9);
                dlg.getDialogPane().setLayout(new GridBagLayout());
                guiLabel probDesc = new guiLabel(referenced.size() == 1 ? String.format(Intl.intl("Selected behavior, %s, is in use."), ((Behavior)referenced.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected behaviors are in use."), referenced.size()));
                guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
                GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(dlg.getDialogPane(), behaviorCB, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
                if (dlg.doModal() != 1) {
                    throw CancelledException.INSTANCE;
                }
                replacementBehavior = (Behavior)behaviorCB.getSelectedItem();
            } else {
                assert (false) : "Deleting all behaviors should not be allowed";
                throw CancelledException.INSTANCE;
            }
        }
        if (replacementBehavior != null) {
            ArrayList<Attractor> attractorsToUpdate;
            ArrayList<ChangeBehavior> changeBehaviorActionsToUpdate;
            ArrayList<OccSourceObj> occSourcesToUpdate;
            ArrayList<EgressAgent> conflictingBehaviorAgents = new ArrayList<EgressAgent>(theUtil.filter(referencing, EgressAgent.class));
            if (!conflictingBehaviorAgents.isEmpty()) {
                replacements.add(new PropReplacement(EgressAgent.BEHAVIOR, conflictingBehaviorAgents, replacementBehavior));
            }
            if (!(occSourcesToUpdate = new ArrayList<OccSourceObj>(theUtil.filter(referencing, OccSourceObj.class))).isEmpty()) {
                List<IUrn<?>> replacementOccSourceBehaviors = DistributionUpdatePropReplacement.getReplacements(referenced, replacementBehavior, occSourcesToUpdate, OccSourceObj.PROP_BEHAVIOR_DIST);
                DistributionUpdatePropReplacement occSourceReplacement = new DistributionUpdatePropReplacement(occSourcesToUpdate, replacementOccSourceBehaviors, OccSourceObj.PROP_BEHAVIOR_DIST);
                replacements.add(occSourceReplacement);
            }
            if (!(changeBehaviorActionsToUpdate = new ArrayList<ChangeBehavior>(theUtil.filter(referencing, ChangeBehavior.class))).isEmpty()) {
                List<IUrn<?>> replacementChangeBehaviorActionsBehaviors = DistributionUpdatePropReplacement.getReplacements(referenced, replacementBehavior, changeBehaviorActionsToUpdate, ChangeBehavior.PROP_BEHAVIOR_DIST);
                DistributionUpdatePropReplacement changeBehaviorActionReplacement = new DistributionUpdatePropReplacement(changeBehaviorActionsToUpdate, replacementChangeBehaviorActionsBehaviors, ChangeBehavior.PROP_BEHAVIOR_DIST);
                replacements.add(changeBehaviorActionReplacement);
            }
            if (!(attractorsToUpdate = new ArrayList<Attractor>(theUtil.filter(referencing, Attractor.class))).isEmpty()) {
                replacements.add(new PropReplacement(Attractor.BEHAVIOR, attractorsToUpdate, replacementBehavior));
            }
        }
    }

    private static void getAttractorRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, Attractor.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        Predicate<? super IMerlinObj> exclude = isSelected.negate();
        MerlinComboBox replacementCB = new MerlinComboBox(md, Attractor.class, exclude, (IMerlinObj[])new Attractor[]{null});
        replacementCB.setNullName(Intl.intl("[None]"));
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Attractor in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        guiLabel probDesc = new guiLabel(referenced.size() == 1 ? String.format(Intl.intl("Selected attractor, %s, is in use."), ((Attractor)referenced.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected attractors are in use."), referenced.size()));
        guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
        GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), replacementCB, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
        if (dlg.doModal() != 1) {
            throw CancelledException.INSTANCE;
        }
        Attractor replacement = (Attractor)replacementCB.getSelectedItem();
        BiFunction<ICompElement, OccProfile.Prop, PropReplacement> replAttrRestr = (srcObj, prop) -> {
            OccProfile.AttractorRestrictions restr = (OccProfile.AttractorRestrictions)srcObj.getProperty(prop);
            restr = restr.clone();
            restr.attractors = new LinkedIdentityHashSet<Attractor>((Collection<Attractor>)restr.attractors);
            restr.attractors.removeAll(referenced);
            if (replacement != null) {
                restr.attractors.add(replacement);
            }
            if (restr.attractors.isEmpty()) {
                restr.mode = restr.rejected ? OccProfile.AttractorRestrictions.Mode.ALL : OccProfile.AttractorRestrictions.Mode.NONE;
            }
            return new PropReplacement(prop, Collections.singleton(srcObj), restr);
        };
        ArrayList<EgressAgent> conflictingAgents = new ArrayList<EgressAgent>(theUtil.filter(referencing, EgressAgent.class));
        for (EgressAgent agent : conflictingAgents) {
            replacements.add(replAttrRestr.apply(agent, OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
        }
        IFilteredCollection<OccProfile> profiles = theUtil.filter(referencing, OccProfile.class);
        for (OccProfile profile : profiles) {
            replacements.add(replAttrRestr.apply(profile, OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
        }
    }

    private static void getMaterialRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, Material.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        Predicate<? super IMerlinObj> exclude = isSelected.negate();
        MerlinComboBox replacementCB = new MerlinComboBox(md, Material.class, exclude, (IMerlinObj[])new Material[]{null});
        replacementCB.setNullName(Intl.intl("[None]"));
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Material in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        guiLabel probDesc = new guiLabel(referenced.size() == 1 ? String.format(Intl.intl("Selected material, %s, is in use."), ((Material)referenced.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected materials are in use."), referenced.size()));
        guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
        GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), replacementCB, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
        if (dlg.doModal() != 1) {
            throw CancelledException.INSTANCE;
        }
        Material replacement = (Material)replacementCB.getSelectedItem();
        ArrayList<ICompElement> conflictingObjs = new ArrayList<ICompElement>(theUtil.filter(referencing, ICompElement.class, obj -> obj.isSupportedLocally(MerlinData.MATERIAL)));
        replacements.add(Delete.getCompressibleArrayReplacement(MerlinData.MATERIAL, conflictingObjs, referenced, replacement));
    }

    private static void getExitRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet conflictingExitBehaviors = new LinkedIdentityHashSet();
        IdentityHashSet conflictingExits = new IdentityHashSet();
        for (GotoExits behavior : md.behaviors.flatten(GotoExits.class)) {
            if (isSelected.test(behavior)) continue;
            for (EgressDoor exit : behavior.get(GotoExits.PROP_EXITS)) {
                if (!isSelected.test(exit)) continue;
                conflictingExits.add(exit);
                conflictingExitBehaviors.add(behavior);
            }
        }
        EgressDoor replacementExit = null;
        if (!conflictingExitBehaviors.isEmpty()) {
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Door in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            guiLabel probDesc = new guiLabel(String.format(Intl.intl("%1$d selected doors are being referenced by a total of %2$d behaviors."), conflictingExits.size(), conflictingExitBehaviors.size()));
            guiLabel exitLbl = new guiLabel(Intl.intl("Re-route conflicted behaviors to:"));
            LinkedIdentityHashSet<? super IMerlinObj> availDoors = new LinkedIdentityHashSet<IMerlinObj>(md.floors.flatten(EgressDoor.class, isSelected.negate()));
            ArrayList<? super IMerlinObj> doors = new ArrayList<IMerlinObj>(availDoors.size() + 1);
            doors.add(null);
            doors.addAll(availDoors);
            Collections.sort(doors, new EgressDoorNameComparator());
            guiComboBox<Object> exits = new guiComboBox<Object>((Collection<Object>)doors);
            exits.setRenderer(new EgressDoorListCellRenderer());
            GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(dlg.getDialogPane(), exits, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacementExit = (EgressDoor)exits.getSelectedItem();
        }
        if (!conflictingExitBehaviors.isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoExits.PROP_EXITS, conflictingExitBehaviors, conflictingExits, replacementExit));
        }
    }

    private static void getElevatorRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet conflictingElevatorGotos = new LinkedIdentityHashSet();
        IdentityHashSet conflictingElevators = new IdentityHashSet();
        for (GotoElevators ge : md.behaviors.getDeepMembers(GotoElevators.class)) {
            if (isSelected.test(ge)) continue;
            for (Elevator elevator : ge.getElevators()) {
                if (!isSelected.test(elevator)) continue;
                conflictingElevators.add(elevator);
                conflictingElevatorGotos.add(ge);
            }
        }
        Elevator replacementElevator = null;
        if (!conflictingElevatorGotos.isEmpty()) {
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Elevator in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            Predicate<? super IMerlinObj> exclude = isSelected.negate();
            MerlinComboBox behaviorCB = new MerlinComboBox(md, Elevator.class, exclude, (IMerlinObj[])new Elevator[]{null});
            behaviorCB.setNullName(Intl.intl("[None]"));
            String msg = String.format(Intl.intl("%1$d selected elevators are being referenced by a total of %2$d behaviors."), conflictingElevators.size(), conflictingElevatorGotos.size());
            GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
            gb.addRow(msg, 0);
            gb.addRow(Intl.intl("Re-route conflicted behaviors to:"), behaviorCB);
            gb.finalizeRows();
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacementElevator = (Elevator)behaviorCB.getSelectedItem();
        }
        if (!conflictingElevatorGotos.isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoElevators.PROP_ELEVATORS, conflictingElevatorGotos, conflictingElevators, replacementElevator));
        }
    }

    private static <T> boolean validateDeleteReferencing(guiComboBox<T> cb, IntSupplier getDeleteCount) {
        if (cb.getSelectedItem() != null) {
            return true;
        }
        int deleteCount = getDeleteCount.getAsInt();
        if (deleteCount == 0) {
            return true;
        }
        int reply = JOptionPane.showConfirmDialog(guiUtil.getWindow(cb), String.format(Intl.intl("This action will delete %d referencing objects."), deleteCount), Intl.intl("Delete Referencing Objects?"), 2, 2);
        return reply == 0;
    }

    private static void getQueueRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet<IMerlinObj> referencing = new LinkedIdentityHashSet<IMerlinObj>();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, QueueObject.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        LinkedIdentityHashSet<GotoQueue> conflictingBehaviorActions = new LinkedIdentityHashSet<GotoQueue>((Collection<GotoQueue>)theUtil.filter(referencing, GotoQueue.class));
        IMerlinObj replacementQ = Delete.getQueuesReplacement(app, md, isSelected, referencing, referenced, Intl.intl("Queues"), QueueObject.class);
        if (!conflictingBehaviorActions.isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoQueue.PROP_QUEUE_DESTINATIONS, conflictingBehaviorActions, referenced, (IGotoQueueDestination)replacementQ));
        }
    }

    private static void getQueueCompRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet<IMerlinObj> referencing = new LinkedIdentityHashSet<IMerlinObj>();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, QueueObjectComp.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        LinkedIdentityHashSet<GotoQueue> conflictingBehaviorActions = new LinkedIdentityHashSet<GotoQueue>((Collection<GotoQueue>)theUtil.filter(referencing, GotoQueue.class));
        IMerlinObj replacementQ = Delete.getQueuesReplacement(app, md, isSelected, referencing, referenced, Intl.intl("Queues Group"), QueueObjectComp.class);
        if (!conflictingBehaviorActions.isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoQueue.PROP_QUEUE_DESTINATIONS, conflictingBehaviorActions, referenced, (IGotoQueueDestination)replacementQ));
        }
    }

    private static <T extends IMerlinObj> IMerlinObj getQueuesReplacement(MerlinApp app, MerlinData md, Predicate<? super IMerlinObj> isSelected, Set<IMerlinObj> referencing, Set<T> referenced, String referencedTypeName, Class<T> type) throws CancelledException {
        MerlinComboBox replacementCB;
        if (referencing.isEmpty() || referenced.isEmpty()) {
            return null;
        }
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Queues in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        Predicate<? super IMerlinObj> replacementFilter = Predicates.alwaysTrue();
        replacementFilter = replacementFilter.and(isSelected.negate());
        IFilteredCollection<GotoQueue> refQueues = theUtil.filter(referencing, GotoQueue.class);
        if (refQueues.isExclusive()) {
            replacementCB = new MerlinComboBox(md, IGotoQueueDestination.class, replacementFilter, (IMerlinObj[])new IGotoQueueDestination[]{null});
            replacementCB.setSorter(new MerlinHierarchy.FlattenedComparator(md.hierarchy));
        } else {
            replacementCB = new MerlinComboBox(md, type, replacementFilter, new IMerlinObj[]{null});
        }
        replacementCB.setNullName(Intl.intl("[None]"));
        String msg = String.format(Intl.intl("%1$d selected %2$s are being referenced by %3$d objects."), referenced.size(), referencedTypeName, referencing.size());
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 0);
        gb.addRow(Intl.intl("Re-route conflicted behaviors to:"), replacementCB);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            throw new CancelledException();
        }
        return (IMerlinObj)replacementCB.getSelectedItem();
    }

    private static void getRoomRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet<Attractor> conflictingAttrs;
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, IEgressOccupiable.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        LinkedIdentityHashSet<GotoRooms> conflictingRoomGotos = new LinkedIdentityHashSet<GotoRooms>((Collection<GotoRooms>)theUtil.filter(referencing, GotoRooms.class));
        final LinkedIdentityHashSet<OccSourceObj> conflictingOccSources = new LinkedIdentityHashSet<OccSourceObj>((Collection<OccSourceObj>)theUtil.filter(referencing, OccSourceObj.class));
        IEgressOccupiable replacementRoom = null;
        if (!referencing.isEmpty()) {
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Room in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            Predicate<IMerlinObj> replacementFilter = Predicates.alwaysTrue();
            replacementFilter = replacementFilter.and(isSelected.negate());
            for (GotoRooms gr : conflictingRoomGotos) {
                replacementFilter = Predicates.and(replacementFilter, gr.getFilter());
            }
            if (!conflictingOccSources.isEmpty()) {
                replacementFilter = Predicates.and(replacementFilter, OccSourceObj.occsAllowedFilter());
            }
            MerlinComboBox<IEgressOccupiable> replacementCB = new MerlinComboBox<IEgressOccupiable>(md, IEgressOccupiable.class, replacementFilter, new IEgressOccupiable[]{null}){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validateData(boolean showWarn, boolean allowModify) {
                    if (!super.validateData(showWarn, allowModify)) {
                        return false;
                    }
                    return Delete.validateDeleteReferencing(this, () -> conflictingOccSources.size());
                }
            };
            replacementCB.setNullName(Intl.intl("[None]"));
            String msg = String.format(Intl.intl("%1$d selected rooms are being referenced by %2$d objects."), referenced.size(), referencing.size());
            GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
            gb.addRow(msg, 0);
            gb.addRow(Intl.intl("Re-route conflicted behaviors and reattach conflicted occupant sources to:"), replacementCB);
            gb.finalizeRows();
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacementRoom = (IEgressOccupiable)replacementCB.getSelectedItem();
        }
        if (!conflictingRoomGotos.isEmpty()) {
            replacements.add(Delete.getSetReplacement(GotoRooms.PROP_ROOMS, conflictingRoomGotos, referenced, replacementRoom));
        }
        if (!conflictingOccSources.isEmpty()) {
            replacements.add(Delete.getOccSourceCompReplacement(conflictingOccSources, replacementRoom));
        }
        if (!(conflictingAttrs = new LinkedIdentityHashSet<Attractor>((Collection<Attractor>)theUtil.filter(referencing, Attractor.class))).isEmpty()) {
            replacements.add(Delete.getSetReplacement(Attractor.ROOMS, conflictingAttrs, referenced, replacementRoom));
        }
    }

    private static void getDoorRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        final LinkedIdentityHashSet<OccSourceObj> conflictingOccSources = new LinkedIdentityHashSet<OccSourceObj>();
        IdentityHashSet conflictingDoors = new IdentityHashSet();
        for (OccSourceObj occSource : md.occSources.getDeepMembers(OccSourceObj.class)) {
            IEgressComp c;
            if (isSelected.test(occSource) || (c = occSource.get(OccSourceObj.PROP_COMPONENT)) == null || !(c instanceof EgressDoor) || !isSelected.test(c)) continue;
            conflictingDoors.add((EgressDoor)c);
            conflictingOccSources.add(occSource);
        }
        EgressDoor replacementDoor = null;
        if (!conflictingOccSources.isEmpty()) {
            guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Door in Use"), 9);
            dlg.getDialogPane().setLayout(new GridBagLayout());
            MerlinComboBox<EgressDoor> replacementCB = new MerlinComboBox<EgressDoor>(md, EgressDoor.class, isSelected.negate(), new EgressDoor[]{null}){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validateData(boolean showWarn, boolean allowModify) {
                    if (!super.validateData(showWarn, allowModify)) {
                        return false;
                    }
                    return Delete.validateDeleteReferencing(this, conflictingOccSources::size);
                }
            };
            replacementCB.setNullName(Intl.intl("[None]"));
            String msg = String.format(Intl.intl("%1$d selected doors are being referenced by a total of %2$d occupant sources."), conflictingDoors.size(), conflictingOccSources.size());
            GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
            gb.addRow(msg, 0);
            gb.addRow(Intl.intl("Attach conflicted occupant sources to:"), replacementCB);
            gb.finalizeRows();
            if (dlg.doModal() != 1) {
                throw CancelledException.INSTANCE;
            }
            replacementDoor = (EgressDoor)replacementCB.getSelectedItem();
        }
        if (!conflictingOccSources.isEmpty()) {
            replacements.add(Delete.getOccSourceCompReplacement(conflictingOccSources, replacementDoor));
        }
    }

    private static void getAgentRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, EgressAgent.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Occupants in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        MerlinComboBox replacementCB = new MerlinComboBox(md, EgressAgent.class, isSelected.negate(), (IMerlinObj[])new EgressAgent[]{null});
        replacementCB.setNullName(Intl.intl("[None]"));
        String msg = String.format(Intl.intl("%1$d selected occupants are being referenced by a total of %2$d objects."), referenced.size(), referencing.size());
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 0);
        gb.addRow(Intl.intl("Replace conflicted occupants with:"), replacementCB);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            throw CancelledException.INSTANCE;
        }
        EgressAgent replacement = (EgressAgent)replacementCB.getSelectedItem();
        IFilteredCollection<AssistedEvacTeam> teams = theUtil.filter(referencing, AssistedEvacTeam.class);
        if (!teams.isEmpty()) {
            ArrayList oreplacements = new ArrayList(referencing.size());
            for (AssistedEvacTeam referencingObj : teams) {
                ArrayList<EgressAgent> newVals = new ArrayList<EgressAgent>((Collection)referencingObj.getProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER));
                if (replacement != null && !newVals.contains(replacement)) {
                    for (int m = 0; m < newVals.size(); ++m) {
                        EgressAgent agent = (EgressAgent)newVals.get(m);
                        if (!referenced.contains(agent)) continue;
                        newVals.set(m, replacement);
                        break;
                    }
                }
                newVals.removeIf(referenced::contains);
                oreplacements.add(newVals);
            }
            replacements.add(new PropReplacement(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER, teams, oreplacements));
        }
    }

    private static void getAETeamRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        IFilteredCollection<WaitForAssistance> getAssists;
        final LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, AssistedEvacTeam.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Assisted Evac Teams in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        MerlinComboBox<AssistedEvacTeam> replacementCB = new MerlinComboBox<AssistedEvacTeam>(md, AssistedEvacTeam.class, isSelected.negate(), new AssistedEvacTeam[]{null}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return Delete.validateDeleteReferencing(this, () -> theUtil.filter(referencing, AssistOccupants.class).size());
            }
        };
        replacementCB.setNullName(Intl.intl("[None]"));
        String msg = String.format(Intl.intl("%1$d selected teams are being referenced by a total of %2$d objects."), referenced.size(), referencing.size());
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 0);
        gb.addRow(Intl.intl("Replace conflicted teams with:"), replacementCB);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            throw CancelledException.INSTANCE;
        }
        AssistedEvacTeam replacement = (AssistedEvacTeam)replacementCB.getSelectedItem();
        IFilteredCollection<AssistOccupants> assist = theUtil.filter(referencing, AssistOccupants.class);
        if (!assist.isEmpty()) {
            replacements.add(Delete.getReplacement(AssistOccupants.TEAM, assist, replacement));
        }
        if (!(getAssists = theUtil.filter(referencing, WaitForAssistance.class)).isEmpty()) {
            replacements.add(Delete.getSetReplacement(WaitForAssistance.TEAMS, getAssists, referenced, replacement));
        }
    }

    private static void getOccGroupRepl(Predicate<? super IMerlinObj> isSelected, MerlinApp app, MerlinData md, List<PropReplacement> replacements) throws CancelledException {
        final LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, OccGroupObj.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Groups in Use"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        MerlinComboBox<OccGroupObj> replacementCB = new MerlinComboBox<OccGroupObj>(md, OccGroupObj.class, isSelected.negate(), new OccGroupObj[]{null}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return Delete.validateDeleteReferencing(this, () -> theUtil.filter(referencing, OccGroupObj.class).size());
            }
        };
        replacementCB.setNullName(Intl.intl("[None]"));
        String msg = String.format(Intl.intl("%1$d selected groups are being referenced by a total of %2$d objects."), referenced.size(), referencing.size());
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 0);
        gb.addRow(Intl.intl("Replace conflicted teams with:"), replacementCB);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            throw CancelledException.INSTANCE;
        }
        OccGroupObj replacement = (OccGroupObj)replacementCB.getSelectedItem();
        IFilteredCollection<JoinOccGroup> joinOccGroups = theUtil.filter(referencing, JoinOccGroup.class);
        if (!joinOccGroups.isEmpty()) {
            replacements.add(new PropReplacement(JoinOccGroup.PROP_GROUP, joinOccGroups, replacement));
        }
    }

    private static <ObjT extends ICompElement, InnerT> PropReplacement getCompressibleArrayReplacement(Object prop, Collection<ObjT> referencing, Set<? extends InnerT> referenced, InnerT replacement) {
        ArrayList<Object[]> replacements = new ArrayList<Object[]>(referencing.size());
        for (ICompElement referencingObj : referencing) {
            Object[] oldVals = (Object[])referencingObj.getProperty(prop);
            Object[] newVals = Arrays.copyOf(oldVals, oldVals.length);
            Arrays.asList(newVals).replaceAll(mat -> referenced.contains(mat) ? replacement : mat);
            if (newVals.length > 1 && MerlinUtil.isUniform(newVals)) {
                newVals = Arrays.copyOf(newVals, 1);
            }
            replacements.add(newVals);
        }
        return new PropReplacement(prop, referencing, replacements);
    }

    private static <ObjT extends ICompElement, InnerT> PropReplacement getSetReplacement(Object prop, Collection<ObjT> referencing, Collection<? extends InnerT> referenced, InnerT replacement) {
        ArrayList replacements = new ArrayList(referencing.size());
        HashMap cache = new HashMap();
        for (ICompElement referencingObj : referencing) {
            LinkedIdentityHashSet existing;
            LinkedIdentityHashSet newVals = new LinkedIdentityHashSet((Collection)referencingObj.getProperty(prop));
            newVals.removeAll(referenced);
            if (replacement != null) {
                newVals.add(replacement);
            }
            if ((existing = (LinkedIdentityHashSet)cache.putIfAbsent(newVals, newVals)) == null) {
                existing = newVals;
            }
            replacements.add(existing);
        }
        return new PropReplacement(prop, referencing, replacements);
    }

    private static <ObjT extends ICompElement, InnerT> PropReplacement getSetReplacement(IPropertySet.Prop<Set<InnerT>> prop, Collection<ObjT> referencing, Collection<? extends InnerT> referenced, InnerT replacement) {
        return Delete.getSetReplacement(prop, referencing, referenced, replacement);
    }

    private static PropReplacement getOccSourceCompReplacement(Set<OccSourceObj> conflictingOccSources, IEgressComp replacement) {
        return Delete.getReplacement(OccSourceObj.PROP_COMPONENT, conflictingOccSources, replacement);
    }

    private static <SrcT extends ICompElement, PropT> PropReplacement getReplacement(IPropertySet.Prop<PropT> prop, Collection<SrcT> referencing, PropT replacement) {
        Set<Object> refSet = referencing instanceof Set ? (Set<Object>)referencing : new LinkedIdentityHashSet<SrcT>(referencing);
        return replacement == null ? new PropRemove(prop, refSet) : new PropReplacement(prop, (Collection<? extends ICompElement>)refSet, replacement);
    }

    static {
        UI_HOOK.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        UI_HOOK.putValue("AcceleratorKey1", KeyStroke.getKeyStroke(8, 0));
    }

    public static class OccGroupTypesUpdatePropReplacement
    extends PropReplacement {
        public OccGroupTypesUpdatePropReplacement(Set<OccGroupTypeObj> occGroupTypesToUpdate, List<Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj>> replacements) {
            super(OccGroupTypeObj.PROP_PROFILE_DATA, occGroupTypesToUpdate, replacements);
        }

        public static List<Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj>> getReplacements(Set<OccProfile> conflictingProfiles, Set<OccGroupTypeObj> occGroupTypesToUpdate) {
            ArrayList<Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj>> replacements = new ArrayList<Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj>>();
            for (OccGroupTypeObj occGroupType : occGroupTypesToUpdate) {
                Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> originalMap = occGroupType.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA);
                LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj> newMap = new LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj>();
                for (OccProfile prof : originalMap.keySet()) {
                    if (conflictingProfiles.contains(prof)) continue;
                    newMap.put(prof, originalMap.get(prof));
                }
                replacements.add(newMap);
            }
            return replacements;
        }
    }

    public static class DistributionUpdatePropReplacement
    extends PropReplacement {
        public DistributionUpdatePropReplacement(Collection<? extends ICompElement> objsToUpdate, List<IUrn<?>> replacements, Object property) {
            super(property, objsToUpdate, replacements);
        }

        public static <T> List<IUrn<?>> getReplacements(Set<T> conflicts, T replacementObj, Collection<? extends ICompElement> objsToUpdate, Object property) {
            ArrayList replacements = new ArrayList();
            for (ICompElement iCompElement : objsToUpdate) {
                Map originalWeights = ((IUrn)iCompElement.getProperty(property)).getWeights();
                HashMap newWeights = new HashMap();
                Set originalObjs = originalWeights.keySet();
                for (Object obj : originalObjs) {
                    DistributionUpdatePropReplacement.addObj(obj, replacementObj, newWeights, conflicts.contains(obj), originalWeights.get(obj));
                }
                replacements.add(UrnUtil.newUrn(newWeights));
            }
            return replacements;
        }

        private static <T> void addObj(T obj, T replacementObj, Map<T, Double> newWeights, boolean replace, Double weight) {
            T newObj;
            T t = newObj = replace ? replacementObj : obj;
            if (!newWeights.containsKey(newObj)) {
                newWeights.put(newObj, weight);
            } else {
                double oldWeight = newWeights.get(newObj);
                newWeights.put(newObj, oldWeight + weight);
            }
        }
    }

    public static class PropRemove<ObjT extends ICompElement, PropT>
    extends PropReplacement {
        private final Set<ObjT> objs;

        public PropRemove(IPropertySet.Prop<PropT> prop, Set<ObjT> objs) {
            super((Object)prop, (Collection<? extends ICompElement>)objs, (Object)null);
            this.objs = objs;
        }

        @Override
        public void perform(MerlinData md) {
            super.perform(md);
            Delete.deleteAll(md, this.objs);
        }
    }

    public static class AgentsUpdatePropReplacement
    extends PropReplacement {
        private List<EgressAgent> agentsToUpdate;
        private Undo.RestoreOp op;

        public AgentsUpdatePropReplacement(Object propKey, Collection<? extends ICompElement> objs, Object replacement, List<EgressAgent> agentsToUpdate, Undo.RestoreOp op) {
            super(propKey, objs, replacement);
            this.agentsToUpdate = agentsToUpdate;
            this.op = op;
        }

        @Override
        public void perform(MerlinData md) {
            super.perform(md);
            Undo.insertEntry(md, this.op);
            for (EgressAgent agent : this.agentsToUpdate) {
                agent.updateProps();
            }
        }
    }

    public static class PropReplacement {
        public final Object propKey;
        public final Collection<? extends ICompElement> objs;
        public final List<?> replacements;

        public PropReplacement(Object propKey, Collection<? extends ICompElement> objs, Object replacement) {
            this(propKey, objs, PropReplacement.fill(replacement, objs.size()));
        }

        public PropReplacement(Object propKey, Collection<? extends ICompElement> objs, List<?> replacements) {
            this.propKey = propKey;
            this.objs = objs;
            this.replacements = replacements;
        }

        private static List<?> fill(Object obj, int count) {
            ArrayList<Object> list = new ArrayList<Object>(count);
            for (int m = 0; m < count; ++m) {
                list.add(obj);
            }
            return list;
        }

        public void perform(MerlinData md) {
            Undo.insertUndoEntry_propRestore(md, this.objs, this.propKey);
            int ix = 0;
            for (ICompElement iCompElement : this.objs) {
                iCompElement.setProperty(this.propKey, this.replacements.get(ix++));
            }
        }
    }

    public static enum DelStatus {
        SUCCESS,
        NOT_DELETED,
        DEL_FAILED,
        CANCELLED;

    }
}

