/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import thunderheadeng.util.theUtil;

public class CompElementActions {
    public static void setProperty(Object prop, Collection<? extends ICompElement> objs, Object newVal) {
        MerlinData md = Composite.getDomain(objs);
        new DefProp<ICompElement, Object>(prop).set(md, objs, newVal);
    }

    public static List<ICompElement> flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs) {
        ArrayList<ICompElement> modObjs = new ArrayList<ICompElement>();
        CompElementActions.flattenToLocallyDefined(prop, objs, modObjs);
        return modObjs;
    }

    private static void flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs, List<ICompElement> result) {
        for (ICompElement iCompElement : objs) {
            if (iCompElement.getPropTypes(1).contains(prop)) {
                result.add(iCompElement);
                continue;
            }
            CompElementActions.flattenToLocallyDefined(prop, theUtil.filter(iCompElement.getChildren(), ICompElement.class), result);
        }
    }

    public static class DefProp<ObjT extends ICompElement, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final Object d_prop;

        public DefProp(Object prop) {
            this.d_prop = prop;
        }

        public Object getProp() {
            return this.d_prop;
        }

        protected void saveState(MerlinData md, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(this.d_prop, objs);
            Undo.insertUndoEntry_propRestore(md, modObjs, this.d_prop);
        }

        protected void set(MerlinData md, Object prop, ObjT obj, PropT newVal) {
            obj.setProperty(this.d_prop, newVal);
        }

        protected Object get(MerlinData md, Object prop, ObjT obj) {
            return obj.getProperty(this.d_prop);
        }

        protected boolean equal(MerlinData md, PropT obj1, PropT obj2) {
            return Objects.equals(obj1, obj2);
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, PropT newVal) {
            this.saveState(md, this.d_prop, objs, newVal);
            for (ICompElement obj : objs) {
                this.set(md, this.d_prop, obj, newVal);
            }
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ObjT> objs) {
            if (objs.isEmpty()) {
                return ICompElement.NOT_SUPPORTED;
            }
            Object val = ICompElement.NOT_SUPPORTED;
            for (ICompElement obj : objs) {
                Object val2 = this.get(md, this.d_prop, obj);
                if (val2 == ICompElement.NON_UNIFORM) {
                    return ICompElement.NON_UNIFORM;
                }
                if (val2 == ICompElement.NOT_SUPPORTED) continue;
                if (val == ICompElement.NOT_SUPPORTED) {
                    val = val2;
                    continue;
                }
                if (this.equal(md, val, val2)) continue;
                return ICompElement.NON_UNIFORM;
            }
            return val;
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public void set(MerlinData var1, Collection<? extends ObjT> var2, PropT var3);

        public Object get(MerlinData var1, Collection<? extends ObjT> var2);
    }
}

