/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.vis.AbstractPropertiesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectionTablePanel {
    private JPanel panel;
    private JComboBox<String> comboBox;
    private HashMap<String, Object> map;

    public SelectionTablePanel(final AbstractPropertiesTable table, String[] names, final HashMap<String, Object> map) {
        this.map = map;
        Arrays.sort(names);
        this.comboBox = new JComboBox<String>(names);
        this.comboBox.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        table.update(map.get(this.comboBox.getSelectedItem()));
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.update(map.get(SelectionTablePanel.this.comboBox.getSelectedItem()));
            }
        });
        this.comboBox.setMaximumRowCount(30);
        ComboboxToolTipRenderer renderer = new ComboboxToolTipRenderer();
        this.comboBox.setRenderer(renderer);
        renderer.setTooltips(Arrays.asList(names));
        JPanel paneSelection = new JPanel(new BorderLayout());
        paneSelection.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select a node"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        paneSelection.add(this.comboBox, "Center");
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)paneSelection, "North");
        this.panel.add((Component)new JScrollPane(table.getTable()), "Center");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Object getSelection() {
        return this.map.get(this.comboBox.getSelectedItem());
    }

    public class ComboboxToolTipRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8165839533302420048L;
        List<String> tooltips;

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (-1 < index && null != value && null != this.tooltips) {
                list.setToolTipText(this.tooltips.get(index));
            }
            return comp;
        }

        public void setTooltips(List<String> tooltips) {
            this.tooltips = tooltips;
        }
    }
}

