/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.ANode;
import inferno.data2.Occupant;
import inferno.data2.QBaseQueue;
import inferno.elevator.Elevator;
import inferno.geom.VorDensityField;
import inferno.sim.AgentVehicle;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.steering.inverse.LaneBehavior;
import inferno.vis.DisplayFilter;
import inferno.vis.GLView;
import inferno.vis.LocallyQuickestDoorsTable;
import inferno.vis.LocallyQuickestTable;
import inferno.vis.NavigateMeshTable;
import inferno.vis.PropertiesTableAllFields;
import inferno.vis.PropertiesTableGlobal;
import inferno.vis.SelectionTablePanel;
import inferno.vis.rend.RendAgentVehicle;
import inferno.vis.rend.RendMeshTri;
import inferno.vis.rend.RendNode;
import inferno.vis.rend.RendOccAgent;
import inferno.vis.rend.RendOccSource;
import inferno.vis.rend.RendOccTarget;
import inferno.vis.rend.RendVertex;
import inferno.vis.rend.RendVorDensityField;
import inferno.vis.rend.RendWingedEdge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.PixelFormat;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.tool.ToolToggleButton;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class GLWindow
extends guiFrame {
    private static final long serialVersionUID = 1L;
    private final GLView d_glView;
    private final Object[] d_filters;
    private final Engine d_engine;
    private PropertiesTableAllFields d_propertiesTableOccupants;
    private OccAgent d_selectedAgent;
    private JLabel d_simTimeLabel;
    private PropertiesTableGlobal d_propertiesTableGlobal;
    private JButton d_pausePlayButton;
    private PropertiesTableAllFields d_propertiesTableNode;
    private PropertiesTableAllFields d_propertiesTableElevator;
    private PropertiesTableAllFields d_propertiesTableSubUnits;
    private NavigateMeshTable d_navigateMeshTable;
    private NavigateMeshTable d_navigateMeshTableMaxSpeeds;
    private LocallyQuickestTable d_locallyQuickestTable;
    private LocallyQuickestDoorsTable d_locallyQuickestDoorsTable;
    private PropertiesTableAllFields d_laneBehaviorTable;
    private guiLabel d_nameLbl;
    private JLabel cursorXLabel;
    private JLabel cursorYLabel;
    private PropertiesTableAllFields d_vehicleAgentTable;
    private PropertiesTableAllFields d_assistedEvacClientTable;
    SelectionTablePanel d_elevatorPane;
    SelectionTablePanel d_nodePane;

    public GLWindow(String frmTitle, Engine engine) {
        super(frmTitle);
        this.d_engine = engine;
        try {
            this.d_glView = new GLView(GLWindow.getGD(), GLWindow.getPF(), engine);
            this.d_glView.getFilters().registerFilter(RendVorDensityField.DENSITY_SUBSAMPLE.class, Predicates.alwaysFalse());
            this.d_glView.getFilters().registerFilter(RendVorDensityField.DENSITY_TRIANGLES.class, Predicates.alwaysFalse());
            this.d_glView.getFilters().registerFilter(RendVorDensityField.DENSITY_VOR.class, Predicates.alwaysFalse());
            this.d_glView.getFilters().registerFilter(RendVorDensityField.TRI_OUTLINE_FILTER.class, Predicates.alwaysFalse());
            this.d_glView.getFilters().registerFilter(RendVorDensityField.VOR_OUTLINE_FILTER.class, Predicates.alwaysFalse());
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<Serializable> filtersBuilder = new ArrayList<Serializable>();
        filtersBuilder.addAll(Arrays.asList("Mesh:", new FilterAction("Verts", RendVertex.VISIBLE.class, true), new FilterAction("Tris", RendWingedEdge.TRI_OUTLINE_FILTER.class, false), new FilterAction("Animate", GLView.ANIMATION_FILTER.class, false), new FilterAction("Traversable Edges", RendWingedEdge.TRAVERSABLE_EDGE_FILTER.class, false), new FilterAction("Trimmed Edges", RendWingedEdge.TRIMMED_EDGE_FILTER.class, false), new FilterAction("Color by Flags", RendMeshTri.COLOR_BY_FLAGS.class, false), null, "Occ Colors:", new FilterAction("Occupants", RendOccAgent.OCC_FILTER.class, true), new FilterAction("Priority", RendOccAgent.COLOR_PRIORITY_FILTER.class, false), new FilterAction("Full Path", RendOccAgent.FULL_PATH_FILTER.class, false), new FilterAction("Groups", RendOccAgent.OCC_GROUPS_FILTER.class, false), new FilterAction("Counterflow", RendOccAgent.COUNTERFLOW_FILTER.class, false), new FilterAction("Display Orient", RendAgentVehicle.DISPLAY_ORIENT.class, false), new FilterAction("Social Dist", RendOccAgent.SOCIAL_DIST_FILTER.class, false), new FilterAction("Sel. Social Dist", RendOccAgent.SEL_SOCIAL_DIST_FILTER.class, false), null, null, "Nodes:", new FilterAction("Sub-mesh", RendNode.FILTER_SUBMESH.class, true), new FilterAction("Door Dists", RendNode.FILTER_DOOR_DISTS.class, false), new FilterAction("All Door Dists", RendNode.FILTER_ALL_DOOR_DISTS.class, false), null, "Occ Source:", new FilterAction("Segments", RendOccSource.SEGMENTS.class, false), "Occ Targets:", new FilterAction("Visible", RendOccTarget.FILTER.class, true), new FilterAction("Priority", RendOccTarget.PRIORITY.class, false), "Occ Paths:", new FilterAction("Debug", RendOccAgent.PATH_GEN_INFO.class, false)));
        if (engine.hasDensityFields()) {
            filtersBuilder.addAll(Arrays.asList(null, new FilterAction("Occ Voronoi", RendVorDensityField.VOR_OUTLINE_FILTER.class, false)));
        }
        this.d_filters = filtersBuilder.toArray();
        JPanel toolbars = new JPanel();
        GridBagHelper gb = new GridBagHelper(toolbars);
        gb.addFilledRow(this.createToolsToolBar());
        for (JToolBar tb : this.createActionToolBar()) {
            gb.addFilledRow(tb);
        }
        gb.addFilledRow(this.createPathToolbar());
        this.getContentPane().add((Component)toolbars, "North");
        this.getContentPane().add((Component)this.createControlPanel(engine), "South");
        JPanel glPanel = new JPanel();
        glPanel.setLayout(new BorderLayout());
        this.d_glView.setMinimumSize(new Dimension(0, 0));
        glPanel.add((Component)this.d_glView, "Center");
        JSplitPane splitPane = new JSplitPane(1, glPanel, this.createTablesPanel());
        splitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)splitPane, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private Component createTablesPanel() {
        BiFunction<String, Boolean, guiLabel> newLabel = (txt, bold) -> {
            guiLabel lbl = new guiLabel((String)txt);
            if (bold.booleanValue()) {
                lbl.setFont(lbl.getFont().deriveFont(1));
            }
            lbl.setPreferredSize(new Dimension(lbl.getPreferredSize().width, 20));
            return lbl;
        };
        this.d_propertiesTableOccupants = new PropertiesTableAllFields(Occupant.class.getDeclaredFields());
        this.d_propertiesTableGlobal = new PropertiesTableGlobal();
        PropertiesTableAllFields propertiesTableParam = new PropertiesTableAllFields(Param.class.getDeclaredFields());
        propertiesTableParam.update(this.d_engine.getParam());
        this.d_propertiesTableNode = new PropertiesTableAllFields(ANode.class.getDeclaredFields());
        this.d_propertiesTableSubUnits = new PropertiesTableAllFields(QBaseQueue.class.getDeclaredFields());
        this.d_navigateMeshTable = new NavigateMeshTable(this.d_engine.getKB(), this, dd -> dd.costs, dd -> dd.totalCost, "COSTS", false);
        this.d_navigateMeshTableMaxSpeeds = new NavigateMeshTable(this.d_engine.getKB(), this, dd -> dd.maxSpeeds, dd -> dd.totalMaxSpeed, "MAX SPEEDS", true);
        this.d_locallyQuickestTable = new LocallyQuickestTable(this.d_engine.getKB());
        this.d_locallyQuickestDoorsTable = new LocallyQuickestDoorsTable(this.d_engine.getKB());
        this.d_laneBehaviorTable = new PropertiesTableAllFields(LaneBehavior.class.getDeclaredFields());
        this.d_vehicleAgentTable = new PropertiesTableAllFields(AgentVehicle.class.getDeclaredFields());
        this.d_assistedEvacClientTable = new PropertiesTableAllFields(AssistedEvacClientAgent.class.getDeclaredFields());
        this.d_nameLbl = newLabel.apply("", false);
        List<ANode> nodes = this.d_engine.getKB().getNodes();
        String[] nodeNames = new String[nodes.size()];
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodeNames[i] = nodes.get((int)i).annotatedName;
            nodeMap.put(nodes.get((int)i).annotatedName, nodes.get(i));
        }
        this.d_nodePane = new SelectionTablePanel(this.d_propertiesTableNode, nodeNames, nodeMap);
        List<Elevator> elevators = this.d_engine.getKB().getElevatorModel().getElevators();
        HashSet elevatorFields = new HashSet();
        String[] elevatorNames = new String[elevators.size()];
        HashMap<String, Object> elevatorMap = new HashMap<String, Object>();
        for (int i = 0; i < elevators.size(); ++i) {
            Collections.addAll(elevatorFields, elevators.get(i).getClass().getDeclaredFields());
            elevatorNames[i] = elevators.get((int)i).getTravelingNode().annotatedName;
            elevatorMap.put(elevators.get((int)i).getTravelingNode().annotatedName, elevators.get(i));
        }
        this.d_propertiesTableElevator = new PropertiesTableAllFields(theUtil.toArray(elevatorFields, Field.class));
        this.d_elevatorPane = new SelectionTablePanel(this.d_propertiesTableElevator, elevatorNames, elevatorMap);
        JPanel locallyQuickestPanel = new JPanel(new BorderLayout());
        locallyQuickestPanel.add(this.d_locallyQuickestTable.getPanel(), "Center");
        JPanel doorsTablePanel = new JPanel(new BorderLayout());
        doorsTablePanel.add(this.d_locallyQuickestDoorsTable.getTable(), "Center");
        JLabel doorsTabLabel = new JLabel("Doors comparison");
        doorsTabLabel.setFont(doorsTabLabel.getFont().deriveFont(1));
        doorsTabLabel.setToolTipText("(X[i][j] == 1) -> cost(i) > cost(j)");
        doorsTablePanel.add((Component)doorsTabLabel, "North");
        doorsTablePanel.setPreferredSize(new Dimension(300, 300));
        locallyQuickestPanel.add((Component)doorsTablePanel, "South");
        JPanel navMeshPanel = new JPanel();
        GridBagHelper gbnm = new GridBagHelper(navMeshPanel);
        gbnm.addRow(this.d_navigateMeshTable.getPanel(), 1.0);
        gbnm.addRow(this.d_navigateMeshTableMaxSpeeds.getPanel(), 1.0);
        JScrollPane navMashScrollPane = new JScrollPane(navMeshPanel);
        guiPanel headingPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(headingPnl);
        gb.rowSpace = 1;
        gb.addRow(newLabel.apply("Name:", true), this.d_nameLbl, 0, 1.0);
        gb.finalizeRows();
        JPanel tabbedPaneContainer = new JPanel(new BorderLayout());
        tabbedPaneContainer.add((Component)headingPnl, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Occupant", new JScrollPane(this.d_propertiesTableOccupants.getTable()));
        tabbedPane.add("Global", new JScrollPane(this.d_propertiesTableGlobal.getTable()));
        tabbedPane.add("Param", new JScrollPane(propertiesTableParam.getTable()));
        tabbedPane.add("Nodes", this.d_nodePane.getPanel());
        tabbedPane.add("Elevators", this.d_elevatorPane.getPanel());
        tabbedPane.add("Navigate mesh", navMashScrollPane);
        tabbedPane.add("Locally quickest", locallyQuickestPanel);
        tabbedPane.addTab("Lane behavior", new JScrollPane(this.d_laneBehaviorTable.getTable()));
        tabbedPane.add("Vehicle agent", new JScrollPane(this.d_vehicleAgentTable.getTable()));
        tabbedPane.add("Assisted Evac Client", new JScrollPane(this.d_assistedEvacClientTable.getTable()));
        tabbedPaneContainer.add((Component)tabbedPane, "Center");
        return tabbedPaneContainer;
    }

    public void updateTables(OccAgent selectedAgent) {
        this.d_selectedAgent = selectedAgent;
        if (this.d_selectedAgent != null) {
            this.d_nameLbl.setText(selectedAgent.getOcc().name);
            this.d_propertiesTableOccupants.update(this.d_selectedAgent.getOcc());
            this.d_navigateMeshTable.update(this.d_selectedAgent.getOcc());
            this.d_navigateMeshTableMaxSpeeds.update(this.d_selectedAgent.getOcc());
            this.d_locallyQuickestTable.update(this.d_selectedAgent.getOcc());
            this.d_locallyQuickestDoorsTable.update(this.d_selectedAgent);
            if (this.d_selectedAgent.hasVehicle()) {
                this.d_vehicleAgentTable.update(this.d_selectedAgent.getVehicle());
            } else {
                this.d_vehicleAgentTable.update(null);
            }
            if (this.d_selectedAgent.getAssistedEvacClientModule().isPresent()) {
                this.d_assistedEvacClientTable.update(this.d_selectedAgent.getAssistedEvacClientModule().get());
            } else {
                this.d_assistedEvacClientTable.update(null);
            }
            Serializable ser = this.d_engine.getKB().getProps().getDbgObj(this.d_selectedAgent.getOcc(), "LANE_BEHAVIOR");
            LaneBehavior lb = null;
            if (ser != null) {
                lb = (LaneBehavior)ser;
            }
            this.d_laneBehaviorTable.update(lb);
        } else {
            this.d_nameLbl.setText("");
            this.d_propertiesTableOccupants.update(null);
            this.d_navigateMeshTable.update(null);
            this.d_navigateMeshTableMaxSpeeds.update(null);
            this.d_locallyQuickestTable.update(null);
            this.d_locallyQuickestDoorsTable.update(null);
            this.d_laneBehaviorTable.update(null);
            this.d_vehicleAgentTable.update(null);
            this.d_assistedEvacClientTable.update(null);
        }
        this.d_propertiesTableGlobal.update(this.d_engine);
        this.d_propertiesTableElevator.update(this.d_elevatorPane.getSelection());
        if (!this.d_engine.getKB().getBaseQueues().isEmpty()) {
            this.d_propertiesTableSubUnits.update(this.d_engine.getKB().getBaseQueues().get(0));
        }
        this.d_propertiesTableNode.update(this.d_nodePane.getSelection());
    }

    private JToolBar createToolsToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.setRollover(false);
        Utils.noToolBarFocus(tb);
        for (CursorTool tool : this.d_glView.getTools()) {
            ToolToggleButton btn = this.d_glView.getToolMgr().getToolbarButton(tool);
            tb.add(btn);
        }
        return tb;
    }

    private List<JToolBar> createActionToolBar() {
        ArrayList<JToolBar> toolbars = new ArrayList<JToolBar>();
        Supplier<JToolBar> newToolbar = () -> {
            JToolBar tb = GLWindow.newToolBar();
            toolbars.add(tb);
            return tb;
        };
        JToolBar tb = newToolbar.get();
        HashMap<Integer, ButtonGroup> buttonGroups = new HashMap<Integer, ButtonGroup>();
        for (int m = 0; m < this.d_filters.length; ++m) {
            Object action = this.d_filters[m];
            if (action instanceof String) {
                tb.add(new guiLabel((String)action));
                continue;
            }
            if (action == null) {
                if (m < this.d_filters.length - 1 && this.d_filters[m + 1] == null) {
                    tb = newToolbar.get();
                    ++m;
                    continue;
                }
                tb.addSeparator();
                continue;
            }
            if (!(action instanceof BoolAction)) continue;
            BoolAction fa = (BoolAction)action;
            JToggleButton btn = new JToggleButton(fa);
            int group = fa.getGroupID();
            if (group >= 0) {
                ButtonGroup bg = (ButtonGroup)buttonGroups.get(group);
                if (bg == null) {
                    bg = new ButtonGroup();
                    buttonGroups.put(group, bg);
                }
                bg.add(btn);
            }
            tb.add(btn);
        }
        return toolbars;
    }

    private JToolBar createPathToolbar() {
        JToolBar tb = GLWindow.newToolBar();
        tb.add(new guiLabel("Path Debug:"));
        ValueField<Integer> ixFld = ValueFields.intFld(IntVR.above(0, true));
        ixFld.setMaximumSize(new Dimension(100, 100));
        ValueField<UnitDouble> delayFld = ValueFields.udFld(new UnitDouble(1.0, SI.MILLI(SI.SECOND)));
        delayFld.setMaximumSize(new Dimension(100, 100));
        IntSupplier getDelayMS = () -> Math.max(1, (int)((UnitDouble)delayFld.getValue()).get(SI.MILLI(SI.SECOND)));
        BiConsumer<String, Consumer> addBtn = (name, action) -> tb.add(new FuncAction((String)name, e -> {
            action.accept(e);
            ixFld.setValue(this.d_glView.getPathDebug().nodeIx);
            this.d_glView.render();
        }));
        addBtn.accept("Reset", e -> {
            this.d_glView.getPathDebug().nodeIx = 0;
        });
        addBtn.accept("<<", e -> {
            this.d_glView.getPathDebug().nodeIx = Math.max(this.d_glView.getPathDebug().nodeIx - 1, 0);
        });
        addBtn.accept(">>", e -> ++this.d_glView.getPathDebug().nodeIx);
        ixFld.setValue(this.d_glView.getPathDebug().nodeIx);
        ixFld.addValueChangeListener(e -> {
            if (this.d_glView.getPathDebug().nodeIx != (Integer)ixFld.getValue()) {
                this.d_glView.getPathDebug().nodeIx = (Integer)ixFld.getValue();
                this.d_glView.render();
            }
        });
        tb.add(ixFld);
        ValueField<Integer> skipField = ValueFields.intFld(IntVR.above(0, false));
        skipField.setValue(1);
        skipField.setMaximumSize(new Dimension(100, 100));
        Timer[] timer = new Timer[]{null};
        tb.add(new JToggleButton(new FuncBoolAction("Animate", false, (baction, e) -> {
            if (baction.isSelected() && timer[0] == null) {
                timer[0] = new Timer(getDelayMS.getAsInt(), te -> {
                    this.d_glView.getPathDebug().nodeIx += ((Integer)skipField.getValue()).intValue();
                    ixFld.setValue(this.d_glView.getPathDebug().nodeIx);
                    this.d_glView.render();
                });
                timer[0].start();
            } else if (!baction.isSelected() && timer[0] != null) {
                timer[0].stop();
                timer[0] = null;
            }
        })));
        delayFld.addValueChangeListener(e -> {
            if (timer[0] != null) {
                timer[0].setDelay(getDelayMS.getAsInt());
            }
        });
        tb.add(new guiLabel("Delay:"));
        tb.add(delayFld);
        tb.add(new guiLabel("Skip:"));
        tb.add(skipField);
        return tb;
    }

    private static JToolBar newToolBar() {
        JToolBar tb = new JToolBar();
        tb.setRollover(false);
        tb.setFloatable(false);
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private guiPanel createControlPanel(final Engine engine) {
        guiPanel panel = new guiPanel(new FlowLayout(1, 6, 6));
        final guiIntField slowerFld = new guiIntField(engine.getParam().slower);
        slowerFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && slowerFld.validateData(false, false)) {
                    engine.getParam().slower = (Integer)slowerFld.getValue();
                    slowerFld.selectAll();
                }
            }
        });
        slowerFld.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (slowerFld.validateData(false, false)) {
                    engine.getParam().slower = (Integer)slowerFld.getValue();
                    slowerFld.selectAll();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                slowerFld.selectAll();
            }
        });
        this.d_pausePlayButton = new JButton();
        this.updatePausePlayButton();
        this.d_pausePlayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (engine.isPaused()) {
                    GLWindow.this.d_pausePlayButton.setText("||");
                    engine.resume();
                } else {
                    GLWindow.this.d_pausePlayButton.setText(">");
                    engine.pause();
                }
            }
        });
        this.d_simTimeLabel = new JLabel("Sim Time (s): " + Global.format(this.d_engine.t()));
        this.d_simTimeLabel.setPreferredSize(new Dimension(150, 10));
        JButton stepEngineButton = new JButton("Step");
        stepEngineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLWindow.this.d_engine.isPaused()) {
                    GLWindow.this.d_engine.resume();
                }
                GLWindow.this.d_engine.getKB().addEvent(GLWindow.this.d_engine.t(), new EngineOp.PauseEngine());
            }
        });
        final guiDoubleField pauseTimeTextBox = new guiDoubleField(0.0);
        final JButton pauseTimeButton = new JButton("Pause at this time");
        pauseTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double pauseTime = Double.parseDouble(pauseTimeTextBox.getText()) - GLWindow.this.d_engine.getCurrentDt();
                    if (pauseTime >= GLWindow.this.d_engine.t()) {
                        pauseTimeTextBox.setForeground(Color.black);
                        GLWindow.this.d_engine.getKB().addEvent(pauseTime, new EngineOp.PauseEngine());
                    } else {
                        pauseTimeTextBox.setForeground(Color.red);
                    }
                }
                catch (NumberFormatException ex) {
                    pauseTimeTextBox.setForeground(Color.red);
                }
            }
        });
        pauseTimeTextBox.addFocusListener(new FocusAdapter(){
            private String pauseTimeOrigValue;

            @Override
            public void focusGained(FocusEvent evt) {
                pauseTimeTextBox.selectAll();
                this.pauseTimeOrigValue = pauseTimeTextBox.getText();
            }

            @Override
            public void focusLost(FocusEvent evt) {
                if (!pauseTimeTextBox.getText().equals(this.pauseTimeOrigValue)) {
                    pauseTimeButton.doClick();
                }
            }
        });
        pauseTimeTextBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    pauseTimeButton.doClick();
                }
            }
        });
        final JTextField selectAgentFld = new JTextField("occupant's name or id", 15);
        selectAgentFld.setSize(40, selectAgentFld.getHeight());
        selectAgentFld.setToolTipText("Enter the occupant's name or ID. Enclose in [] to only search for ID.");
        selectAgentFld.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                selectAgentFld.selectAll();
                selectAgentFld.setForeground(Color.BLACK);
            }
        });
        final JButton selectAgentButton = new JButton("Select");
        selectAgentFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    selectAgentButton.doClick();
                }
            }
        });
        selectAgentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedName = selectAgentFld.getText();
                String tname = selectedName.trim();
                Integer searchId = null;
                if (tname.startsWith("[") && tname.endsWith("]") && tname.length() > 2) {
                    try {
                        searchId = Integer.parseInt(tname.substring(1, tname.length() - 1));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                boolean foundByName = false;
                OccAgent selectedByIDAgent = null;
                if (searchId != null) {
                    for (OccAgent agent : engine.getKB().getActiveAgents()) {
                        if (agent.getId() != searchId.intValue()) continue;
                        selectedByIDAgent = agent;
                        break;
                    }
                } else {
                    for (OccAgent agent : engine.getKB().getActiveAgents()) {
                        if (agent.getOcc().name.equals(selectedName)) {
                            agent.setSelected(true);
                            GLWindow.this.updateTables(agent);
                            foundByName = true;
                            selectAgentFld.setForeground(Color.BLACK);
                        } else {
                            agent.setSelected(false);
                        }
                        if (!("" + agent.getId()).equals(selectedName)) continue;
                        selectedByIDAgent = agent;
                    }
                }
                if (!foundByName && selectedByIDAgent != null) {
                    selectedByIDAgent.setSelected(true);
                    GLWindow.this.updateTables(selectedByIDAgent);
                    selectAgentFld.setForeground(Color.BLACK);
                }
                if (!foundByName && selectedByIDAgent == null) {
                    selectAgentFld.setForeground(Color.RED);
                }
                GLWindow.this.d_glView.render();
            }
        });
        JPanel selectAgentPane = new JPanel();
        selectAgentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select occupant"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        selectAgentPane.add(selectAgentButton);
        selectAgentPane.add(selectAgentFld);
        JPanel controlSimulationPane = new JPanel();
        controlSimulationPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control simulation"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        controlSimulationPane.add(this.d_pausePlayButton);
        controlSimulationPane.add(stepEngineButton);
        controlSimulationPane.add(new guiLabel("Delay (ms):"));
        controlSimulationPane.add(slowerFld);
        controlSimulationPane.add(this.d_simTimeLabel);
        controlSimulationPane.add(pauseTimeButton);
        controlSimulationPane.add(pauseTimeTextBox);
        JPanel cursorPane = new JPanel();
        cursorPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Cursor position"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.cursorXLabel = new JLabel("x: ");
        this.cursorYLabel = new JLabel("y: ");
        cursorPane.add(this.cursorXLabel);
        cursorPane.add(this.cursorYLabel);
        cursorPane.setPreferredSize(new Dimension(100, 65));
        JButton resetViewButton = new JButton("Reset View");
        resetViewButton.addActionListener(e -> this.d_glView.resetView());
        JPanel viewPane = new JPanel();
        viewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        viewPane.add(resetViewButton);
        panel.add(cursorPane);
        panel.add(viewPane);
        panel.add(controlSimulationPane);
        panel.add(selectAgentPane);
        return panel;
    }

    public void render(List<?> objs) {
        this.d_glView.show(objs);
        this.updateTables(this.d_selectedAgent);
        this.d_simTimeLabel.setText("Sim Time (s): " + Global.format(this.d_engine.t()));
        this.updatePausePlayButton();
    }

    private void updatePausePlayButton() {
        String buttonText = this.d_engine.isPaused() ? ">" : "||";
        this.d_pausePlayButton.setText(buttonText);
    }

    private static GraphicsDevice getGD() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        return gds[0];
    }

    private static PixelFormat getPF() {
        return new PixelFormat();
    }

    public GLView getD_glView() {
        return this.d_glView;
    }

    public void updateCoordinates(Point3d p) {
        this.cursorXLabel.setText("x: " + Global.format(p.x));
        this.cursorYLabel.setText("y: " + Global.format(p.y));
    }

    private class VDFFastSearchAction
    extends BoolAction {
        private static final long serialVersionUID = 1L;

        public VDFFastSearchAction() {
            super("FS", true, -1);
        }

        @Override
        protected void stateChanged() {
            ((RendVorDensityField)GLWindow.this.d_glView.REND_MAP.get(VorDensityField.class)).setFastSearch(this.isSelected());
            GLWindow.this.d_glView.render();
        }
    }

    private class VDFFilterAction
    extends BoolAction {
        private static final long serialVersionUID = 1L;
        private final VorDensityField.Interpolation d_interp;

        public VDFFilterAction(String desc, VorDensityField.Interpolation interp) {
            super(desc, interp == VorDensityField.DEF_INTERP, 1);
            this.d_interp = interp;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                ((RendVorDensityField)GLWindow.this.d_glView.REND_MAP.get(VorDensityField.class)).setInterp(this.d_interp);
            }
            GLWindow.this.d_glView.render();
        }
    }

    private class FilterAction
    extends BoolAction {
        private static final long serialVersionUID = 1L;
        private final Class<?> d_filterType;
        private final Predicate d_filter;

        public FilterAction(String desc, Class<?> filterType, boolean initShow) {
            this(desc, filterType, DisplayFilter.FILTER_ALL, initShow);
        }

        public FilterAction(String desc, Class<?> filterType, boolean initShow, int groupId) {
            this(desc, filterType, DisplayFilter.FILTER_ALL, initShow, groupId);
        }

        public FilterAction(String desc, Class<?> filterType, Predicate<?> filter, boolean initShow) {
            this(desc, filterType, filter, initShow, -1);
        }

        public FilterAction(String desc, Class<?> filterType, Predicate<?> filter, boolean initShow, int groupId) {
            super(desc, initShow, groupId);
            this.d_filterType = filterType;
            this.d_filter = filter;
            if (!initShow) {
                GLWindow.this.d_glView.getFilters().registerFilter(filterType, this.d_filter);
            }
        }

        @Override
        protected void stateChanged() {
            if (!this.isSelected()) {
                GLWindow.this.d_glView.getFilters().registerFilter(this.d_filterType, this.d_filter);
            } else {
                GLWindow.this.d_glView.getFilters().removeFilter(this.d_filterType);
            }
            GLWindow.this.d_glView.render();
        }
    }

    private class BoolAction
    extends BooleanAction {
        private static final long serialVersionUID = 1L;
        private int d_groupId;

        public BoolAction(String desc, boolean initShow, int groupId) {
            super(desc, initShow);
            this.d_groupId = groupId;
        }

        protected int getGroupID() {
            return this.d_groupId;
        }
    }

    private static class FuncBoolAction
    extends BooleanAction {
        private static final long serialVersionUID = 1L;
        public final BiConsumer<BooleanAction, ActionEvent> func;

        public FuncBoolAction(String name, boolean initVal, BiConsumer<BooleanAction, ActionEvent> func) {
            super(name, initVal);
            this.func = func;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.func.accept(this, e);
        }
    }

    private static class FuncAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        public final Consumer<ActionEvent> func;

        public FuncAction(String name, Consumer<ActionEvent> func) {
            super(name);
            this.func = func;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.func.accept(e);
        }
    }
}

