/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.sim.KB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Global;

public abstract class AbstractTable {
    protected Object[][] d_values;
    protected String[] d_columnNames;
    protected JTable d_table;
    protected KB d_kb;
    protected TableModel d_tableModel;

    public AbstractTable() {
        this.createTable(null);
    }

    public AbstractTable(String className) {
        this.createTable(className);
    }

    public AbstractTable(KB kb) {
        this.d_kb = kb;
        this.createTable(null);
    }

    private void createTable(String className) {
        try {
            this.initModel(className);
        }
        catch (ClassNotFoundException | SecurityException e1) {
            e1.printStackTrace();
        }
        this.d_tableModel = new TableModel();
        JTable table = new JTable(this.d_tableModel){
            private static final long serialVersionUID = 680681707501706172L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int colIndex;
                int realColumnIndex;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                Object value = this.getValueAt(rowIndex, realColumnIndex = this.convertColumnIndexToModel(colIndex = this.columnAtPoint(p)));
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
        };
        table.putClientProperty("HIGHLIGHTED_ROW", -1);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 4147873430167420174L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setBackground(row % 2 == 0 ? Color.white : new Color(135, 206, 250));
                c.setForeground(Color.black);
                c.setFont(row == (Integer)table.getClientProperty("HIGHLIGHTED_ROW") ? c.getFont().deriveFont(1) : c.getFont().deriveFont(0));
                return c;
            }
        });
        table.getTableHeader().setFont(table.getTableHeader().getFont().deriveFont(1));
        table.setRowSelectionAllowed(true);
        table.setSelectionForeground(new Color(30, 144, 255));
        table.setRowHeight(20);
        this.d_table = table;
    }

    public abstract void initModel(String var1) throws SecurityException, ClassNotFoundException;

    public abstract void update(List<Object> var1);

    public void update(Object data) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(data);
        this.update(l);
    }

    protected static Vector3d format(Tuple3d in) throws ParseException {
        if (in == null) {
            return null;
        }
        NumberFormat fmt = NumberFormat.getInstance(Locale.getDefault());
        Number x = fmt.parse(Global.format(in.x));
        Number y = fmt.parse(Global.format(in.y));
        Number z = fmt.parse(Global.format(in.z));
        return new Vector3d(x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public Component getTable() {
        return this.d_table;
    }

    public class ColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 6998306007582175707L;
    }

    public class TableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -1617280053445478855L;

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= 0 && col >= 0 && row < this.getRowCount() && col < this.getColumnCount()) {
                return AbstractTable.this.d_values[row][col];
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return AbstractTable.this.d_values.length;
        }

        @Override
        public int getColumnCount() {
            return AbstractTable.this.d_values[0].length;
        }

        @Override
        public String getColumnName(int col) {
            return AbstractTable.this.d_columnNames[col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= 0 && col >= 0 && row < this.getRowCount() && col < this.getColumnCount()) {
                AbstractTable.this.d_values[row][col] = value;
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public void addRow(Object[] row) {
            Object[][] newValues = new Object[AbstractTable.this.d_values.length + 1][AbstractTable.this.d_values[0].length];
            for (int i = 0; i < AbstractTable.this.d_values.length; ++i) {
                for (int j = 0; j < AbstractTable.this.d_values[0].length; ++j) {
                    newValues[i][j] = AbstractTable.this.d_values[i][j];
                }
            }
            for (int j = 0; j < AbstractTable.this.d_values[0].length; ++j) {
                newValues[AbstractTable.this.d_values.length][j] = row[j];
            }
            AbstractTable.this.d_values = newValues;
            this.fireTableDataChanged();
        }

        @Override
        public void addColumn(Object columnName, Object[] columnData) {
            Object[][] newValues = new Object[AbstractTable.this.d_values.length][AbstractTable.this.d_values[0].length + 1];
            String[] newColumnNames = new String[AbstractTable.this.d_columnNames.length + 1];
            for (int i = 0; i < AbstractTable.this.d_values.length; ++i) {
                for (int j = 0; j < AbstractTable.this.d_values[0].length; ++j) {
                    newValues[i][j] = AbstractTable.this.d_values[i][j];
                }
            }
            for (int col = 0; col < AbstractTable.this.d_columnNames.length; ++col) {
                newColumnNames[col] = AbstractTable.this.d_columnNames[col];
            }
            newColumnNames[newColumnNames.length - 1] = "" + (newColumnNames.length - 1);
            AbstractTable.this.d_columnNames = newColumnNames;
            for (int j = 0; j < AbstractTable.this.d_values[0].length; ++j) {
                newValues[j][AbstractTable.this.d_values[0].length] = columnData[j];
            }
            AbstractTable.this.d_values = newValues;
            super.addColumn(columnName, columnData);
            this.fireTableDataChanged();
        }
    }
}

