/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.AvoidOccs;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public class PassBehavior
implements Serializable {
    static final long serialVersionUID = 1L;

    public static boolean isNeeded(KB kb, OccInfo oi, SeekInfo seek, Senses senses, boolean inCounterflow, boolean isSocialDistancing) {
        if (inCounterflow || !seek.seeking || oi.oa.hasVehicle() || isSocialDistancing) {
            return false;
        }
        double desiredSpeed = OccAgent.getMaxVel(kb, oi.oa.getOcc(), 0.0, seek.seekDir);
        double speedTol = desiredSpeed * 0.95;
        return !(oi.cache.maxVel >= speedTol);
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, Consumer<OccAgent> highCostHits) {
        if (dir == null) {
            return new double[]{1.0, 0.0};
        }
        ArrayList<Pair<OccAgent, Double>> occHits = new ArrayList<Pair<OccAgent, Double>>(2);
        senses.senseNearestOccHits(kb, -1348979970, oi, dir, null, occHits);
        if (occHits.isEmpty()) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        double maxVel = OccAgent.getMaxVel(kb, oi.oa.getOcc(), 0.0, dir);
        Pair firstHit = (Pair)occHits.get(0);
        double[] firstCost = PassBehavior.getCost(kb, oi, seekInfo, (OccAgent)firstHit.v1, maxVel);
        if (seekInfo.seekDir.dot(dir) < 0.0) {
            return new double[]{1.0, firstCost[1]};
        }
        if (firstCost[0] == 0.0) {
            return firstCost;
        }
        if (highCostHits != null) {
            highCostHits.accept((OccAgent)firstHit.v1);
            if (firstCost[0] >= 1.0) {
                for (int m = 1; m < occHits.size(); ++m) {
                    Pair hit = (Pair)occHits.get(m);
                    if (!AvoidOccs.getSeparateEnabled(kb, oi, (OccAgent)hit.v1)) continue;
                    double[] cost = PassBehavior.getCost(kb, oi, seekInfo, (OccAgent)hit.v1, maxVel);
                    if (!(cost[0] >= 1.0)) break;
                    highCostHits.accept((OccAgent)hit.v1);
                }
            }
        }
        return firstCost;
    }

    private static double[] getCost(KB kb, OccInfo oi, SeekInfo seekInfo, OccAgent otherOcc, double maxVel) {
        double cost = InvSteerUtil.clampCost(1.0 - otherOcc.getOcc().vel.length() / maxVel);
        return new double[]{cost, oi.cache.maxVel};
    }
}

