/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Predicates;

public class LaneBehavior
implements Serializable {
    private static final long serialVersionUID = 4877112542823862383L;
    public static final int FILTERID_SHORTRANGE = -1348979970;
    public static final int FILTERID_LONGRANGE = 306155503;
    private Collection<OccAgent> laneOccupants;
    private Vector3d center;
    private boolean isInCounterFlow;
    private static final double EPS_INFRONT = LaneBehavior.toDotTol(60.0);
    private static final double EPS_SEARCH = LaneBehavior.toDotTol(90.0);
    private static final double EPS_COUNTERFLOW = LaneBehavior.toDotTol(36.0);
    private static final double AVGSPEED_MULT = 1.0;
    private boolean isLeader = false;
    private double desiredSpeed;
    private ArrayList<OccAgent> counterFlowAgents = new ArrayList();
    private boolean reportCost;

    public LaneBehavior(KB world, OccInfo oi, Senses senses, SeekInfo seekInfo, boolean reportCost) {
        this.reportCost = reportCost;
        this.determineCounterFlow(world, oi, senses, seekInfo);
        if (reportCost) {
            this.findOccupantsInFront(oi, senses, seekInfo.seekDir);
            if (this.isInCounterFlow) {
                this.calculateCenter(oi);
            }
        }
    }

    public static Senses.AgentFilter getAgentFilter(OccInfo oi, SeekInfo seekInfo, Predicate<OccAgent> agentFilter) {
        if (seekInfo.seekDir == null || Predicates.alwaysFalse(agentFilter)) {
            return null;
        }
        return new Senses.AgentFilter(306155503, new InFrontOfAgentFilter(oi.oa.getPos(), seekInfo.seekDir, EPS_SEARCH), Math.sqrt(5.0), Math.PI);
    }

    private void determineCounterFlow(KB world, OccInfo oi, Senses senses, SeekInfo seek) {
        Collection<OccAgent> nearOccs = senses.getNearOccs(306155503, oi);
        this.counterFlowAgents.clear();
        for (OccAgent oa : nearOccs) {
            if (!LaneBehavior.isInCounterflow(world, oi.oa, senses, seek, oa)) continue;
            this.counterFlowAgents.add(oa);
        }
        this.isInCounterFlow = !this.counterFlowAgents.isEmpty();
    }

    private static boolean isInCounterflow(KB kb, OccAgent agent, Senses senses, SeekInfo seek, OccAgent oa) {
        if (oa.isWaiting(kb) && InvSteerUtil.getYieldToIdler(kb, agent, oa)) {
            return false;
        }
        Vector3d agentDir = Senses.getSeekDir(oa);
        Senses.Flow flow = senses.getFlow(kb, agent, seek, oa, agentDir);
        return flow != Senses.Flow.MERGE;
    }

    private void findOccupantsInFront(OccInfo oi, Senses senses, Vector3d dir) {
        this.isLeader = false;
        if (this.isInCounterFlow) {
            Collection<OccAgent> nearOccs = senses.getNearOccs(-1348979970, oi);
            Point3d pos = oi.oa.getPos();
            double slowSpeed = oi.cache.maxVel * (double)oi.oa.getOcc().slowFactor;
            double slowSpeedSq = slowSpeed * slowSpeed;
            boolean hasOccsInFront = false;
            this.laneOccupants = new ArrayList<OccAgent>();
            for (OccAgent agent : nearOccs) {
                if (this.counterFlowAgents.contains(agent)) continue;
                boolean inFront = LaneBehavior.isInFront(pos, dir, agent.getPos(), EPS_INFRONT);
                hasOccsInFront |= inFront;
                if (!inFront || !(agent.getVel().lengthSquared() > slowSpeedSq)) continue;
                this.laneOccupants.add(agent);
            }
            this.isLeader = !hasOccsInFront;
        }
    }

    private static double toDotTol(double angleDeg) {
        return Math.cos(Math.toRadians(angleDeg));
    }

    private void calculateCenter(OccInfo oi) {
        Vector3d center = new Vector3d(0.0, 0.0, 0.0);
        if (!this.laneOccupants.isEmpty()) {
            for (OccAgent oa : this.laneOccupants) {
                center.add(oa.getPos());
            }
            center.scale(1.0 / (double)this.laneOccupants.size());
            center.sub(oi.oa.getPos());
        }
        this.center = center;
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir) {
        if (!this.reportCost) {
            return null;
        }
        double d = this.desiredSpeed = this.isLeader ? oi.cache.maxVel * 1.0 : oi.cache.maxVel;
        if (this.isInCounterFlow) {
            if (dir == null) {
                return new double[]{0.0, this.desiredSpeed};
            }
            if (this.isLeader || this.laneOccupants.isEmpty()) {
                return new double[]{0.0, this.desiredSpeed};
            }
            if (this.leadsTowardsCounterFlow(oi, dir)) {
                return new double[]{dir.angle(this.center), this.desiredSpeed};
            }
        }
        return new double[]{0.0, this.desiredSpeed};
    }

    private boolean leadsTowardsCounterFlow(OccInfo oi, Vector3d dir) {
        Point3d position = oi.oa.getPos();
        for (OccAgent cagent : this.counterFlowAgents) {
            if (!LaneBehavior.isInFront(position, dir, cagent.getPos(), EPS_COUNTERFLOW)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInFront(Point3d pos1, Vector3d dir1, Point3d pos2, double dotTol) {
        Vector3d adir = Util3D.vector(pos1, pos2);
        if (Util3D.safeNormalize(adir, 1.0E-6) == 0.0) {
            return false;
        }
        return Util.dot2d(dir1, adir) >= dotTol;
    }

    public boolean isLaneLeader() {
        return this.isLeader;
    }

    public boolean isInCounterFlow() {
        return this.isInCounterFlow;
    }

    public boolean isReportCost() {
        return this.reportCost;
    }

    private static class InFrontOfAgentFilter
    implements Predicate<OccAgent> {
        private final Point3d position;
        private final Vector3d direction;
        private final double dotTol;

        public InFrontOfAgentFilter(Point3d pos, Vector3d dir, double dotTol) {
            this.position = pos;
            this.direction = dir;
            this.dotTol = dotTol;
        }

        @Override
        public boolean test(OccAgent t) {
            return LaneBehavior.isInFront(this.position, this.direction, t.getPos(), this.dotTol);
        }
    }
}

