/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ScriptingUtil {
    public static Serializable find(String name, Function<Serializable, String> namer, Collection<? extends Serializable> ... haystacks) {
        return ScriptingUtil.find((Serializable obj) -> name.equals(namer.apply((Serializable)obj)), haystacks);
    }

    public static Serializable findMultiName(String name, Function<Serializable, Stream<String>> namer, Collection<? extends Serializable> ... haystacks) {
        return ScriptingUtil.find((Serializable obj) -> ((Stream)namer.apply((Serializable)obj)).anyMatch(name::equals), haystacks);
    }

    public static Serializable find(Predicate<Serializable> test, Collection<? extends Serializable> ... haystacks) {
        for (Collection<? extends Serializable> coll : haystacks) {
            for (Serializable serializable : coll) {
                if (!test.test(serializable)) continue;
                return serializable;
            }
        }
        return null;
    }

    public static List<? extends Serializable> findAll(String regexName, Function<Serializable, String> namer, Collection<? extends Serializable> ... haystacks) {
        return ScriptingUtil.findAllMultiName(regexName, obj -> {
            String name = (String)namer.apply((Serializable)obj);
            return name != null ? Stream.of(name) : Stream.empty();
        }, haystacks);
    }

    public static List<Serializable> findAllMultiName(String regexName, Function<Serializable, Stream<String>> namer, Collection<? extends Serializable> ... haystacks) {
        Pattern p = Pattern.compile(regexName);
        return ScriptingUtil.findAll((Serializable obj) -> ((Stream)namer.apply((Serializable)obj)).anyMatch(name -> name != null && p.matcher((CharSequence)name).matches()), haystacks);
    }

    public static List<Serializable> findAll(Predicate<Serializable> test, Collection<? extends Serializable> ... haystacks) {
        ArrayList<Serializable> objs = new ArrayList<Serializable>();
        for (Collection<? extends Serializable> coll : haystacks) {
            for (Serializable serializable : coll) {
                if (!test.test(serializable)) continue;
                objs.add(serializable);
            }
        }
        return objs;
    }
}

