/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Tri;
import java.io.ObjectStreamException;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Predicates;

public class TriFilters {
    public static Predicate<Tri> rejectStairs() {
        return RejectStairs.INSTANCE;
    }

    public static Predicate<Tri> rejectClosed() {
        return RejectClosed.INSTANCE;
    }

    public static Predicate<Tri> rejectClosed(Predicate<ANode> roomFilter) {
        if (Predicates.alwaysTrue(roomFilter)) {
            return TriFilters.rejectClosed();
        }
        if (Predicates.alwaysFalse(roomFilter)) {
            return Predicates.alwaysFalse();
        }
        return Predicates.and(TriFilters.filterNodes(roomFilter), TriFilters.rejectClosed());
    }

    public static Predicate<Tri> filterNodes(Predicate<ANode> nodeFilter) {
        if (Predicates.alwaysTrue(nodeFilter)) {
            return Predicates.alwaysTrue();
        }
        if (Predicates.alwaysFalse(nodeFilter)) {
            return Predicates.alwaysFalse();
        }
        return new NodeToTriFilter(nodeFilter);
    }

    private static class NodeToTriFilter
    extends APredicate<Tri> {
        static final long serialVersionUID = 1L;
        private final Predicate<ANode> nodeFilter;

        public NodeToTriFilter(Predicate<ANode> nodeFilter) {
            this.nodeFilter = nodeFilter;
        }

        @Override
        public boolean test(Tri t) {
            return this.nodeFilter.test(t.node);
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeToTriFilter && ((NodeToTriFilter)obj).nodeFilter.equals(this.nodeFilter);
        }

        public int hashCode() {
            return 0x62FFE34 ^ this.nodeFilter.hashCode();
        }
    }

    private static class RejectClosed
    extends APredicate<Tri> {
        static final long serialVersionUID = 1L;
        public static RejectClosed INSTANCE = new RejectClosed();

        private RejectClosed() {
        }

        @Override
        public boolean test(Tri t) {
            return t.terrain == null || t.getSpeedModifier().allowsMovement(false);
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectStairs
    extends APredicate<Tri> {
        static final long serialVersionUID = 1L;
        public static RejectStairs INSTANCE = new RejectStairs();

        private RejectStairs() {
        }

        @Override
        public boolean test(Tri t) {
            return t.node.stairData == null;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

