/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.DoorGeom;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.SplitDoor;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.elevator.ElevatorLevel;
import inferno.geom.IValueField;
import inferno.geom.NaiveDistanceField;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.occsource.OccSource;
import inferno.sim.path.DoorQueueEstimate;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.PathFollow;
import inferno.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.CompletedFuture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.mtproc.MTListProcessor;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.theUtil;

public class Estimate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DOOR_SEG_TOL = theUtil.getSystemDouble("Estimate.DOOR_SEG_TOL", 1.0);
    private final KB d_kb;
    private double d_radiusMin;
    private final Map<ANode, DoorQueueEstimate> d_doorQueues;
    private transient List<DoorQueueEstimate> d_doorQueueList;
    private transient MTListProcessor<DoorQueueEstimate> d_doorQueueProcessor;
    protected Map<DoorToGoalKey, DoorToGoalPair> memo_doorToDoorDistance;
    private Map<Pair<ANode, ANode>, IValueField<Vector3d>> d_distanceFieldMap;
    private transient ExecutorService d_workerExecutor = null;

    public Estimate(KB kb) {
        this.d_kb = kb;
        this.d_doorQueues = new LinkedIdentityHashMap<ANode, DoorQueueEstimate>();
        this.memo_doorToDoorDistance = new HashMap<DoorToGoalKey, DoorToGoalPair>();
        this.d_distanceFieldMap = new HashMap<Pair<ANode, ANode>, IValueField<Vector3d>>();
        this.d_workerExecutor = Estimate.createWorkerExecutor();
    }

    protected void finalize() throws Throwable {
        this.d_workerExecutor.shutdown();
        super.finalize();
    }

    private static ExecutorService createWorkerExecutor() {
        int minThreads = 2;
        int numThreads = Math.max(minThreads, Engine.getNumProcThreads());
        return Executors.newFixedThreadPool(numThreads);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_workerExecutor = Estimate.createWorkerExecutor();
    }

    public KB getKB() {
        return this.d_kb;
    }

    public void resetDoors(KB.KbExclusive kbOnly) {
        Objects.requireNonNull(kbOnly);
        this.memo_doorToDoorDistance.clear();
    }

    public void init() {
        this.d_radiusMin = Double.MAX_VALUE;
        for (Occupant occ : this.d_kb.getOccs()) {
            this.d_radiusMin = Math.min(this.d_radiusMin, occ.bodyShape.getGeomRadius());
        }
        for (OccSource occSource : this.d_kb.getOccSources()) {
            this.d_radiusMin = Math.min(this.d_radiusMin, occSource.getMinGeomRadius());
        }
        Consumer<ANode> addTransportDistField = room -> {
            if (room != null && room.isTransportNode()) {
                for (ElevatorLevel level : this.d_kb.getElevatorModel().findElevator(room.getElevatorLevel()).getLevels()) {
                    for (ANode door : level.pickupNode.getDoorsOutOfRoom()) {
                        this.d_distanceFieldMap.put(new Pair<ANode, ANode>((ANode)room, door), new NaiveDistanceField(door.getDoorEdges()));
                    }
                }
            }
        };
        for (ANode door : this.d_kb.getDoorNodes()) {
            this.d_doorQueues.put(door, new DoorQueueEstimate(this.d_kb, door));
            ANode room1 = door.doorQueue.getR1();
            ANode room2 = door.doorQueue.getR2();
            if (!door.getDoorEdges().isEmpty()) {
                NaiveDistanceField distField = new NaiveDistanceField(door.getDoorEdges());
                if (room1 != null) {
                    this.d_distanceFieldMap.put(new Pair<ANode, ANode>(room1, door), distField);
                }
                if (room2 != null) {
                    this.d_distanceFieldMap.put(new Pair<ANode, ANode>(room2, door), distField);
                }
            }
            addTransportDistField.accept(room1);
            addTransportDistField.accept(room2);
        }
    }

    public void pauseWorkers() {
    }

    public void resumeWorkers() {
    }

    public void updateDoorQueues() throws ExecutionException {
        for (DoorQueueEstimate dq : this.d_doorQueues.values()) {
            dq.reset(this.d_kb);
        }
        for (OccAgent oa : this.d_kb.getActiveAgents()) {
            Pair<ANode, DoorDir> door;
            PathFollow pf = oa.getPathFollow();
            if (pf == null || pf.getPath() == null || (door = pf.getPath().getTargetDoor()) == null) continue;
            DoorQueueEstimate dq = this.getQueue((ANode)door.v1);
            DoorQueueEstimate.OccQueue queue = dq.getQueue((DoorDir)((Object)door.v2));
            double dist = pf.getRemainingKnownDistance(oa);
            if (!Double.isFinite(dist)) continue;
            queue.add(oa, dist);
        }
        if (this.d_doorQueueList == null) {
            this.d_doorQueueList = new ArrayList<DoorQueueEstimate>(this.d_doorQueues.values());
        }
        if (this.d_doorQueueProcessor == null) {
            this.d_doorQueueProcessor = new MTListProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.d_kb.getThreadPool());
            this.d_doorQueueProcessor.setList(this.d_doorQueueList);
        }
        this.d_doorQueueProcessor.process(new MTProcessor.IProc<DoorQueueEstimate>(){

            @Override
            public void process(DoorQueueEstimate val, int threadNum, int ix) {
                val.finish(Estimate.this.d_kb);
            }
        });
    }

    public DoorQueueEstimate getQueue(ANode queueDoor) {
        assert (queueDoor != null && queueDoor.isDoor());
        return this.d_doorQueues.get(queueDoor);
    }

    public IValueField<Vector3d> getDistanceField(KB kb, ANode n, ANode localDoor) {
        Pair<ANode, ANode> key = new Pair<ANode, ANode>(n, localDoor);
        IValueField<Vector3d> fld = this.d_distanceFieldMap.get(key);
        assert (fld != null);
        return fld;
    }

    private static boolean canCrossDoor(ANode roomOrigin, WingedEdge roomDoor, Predicate<PathChange> pathFilter) {
        Tri enterTri = roomDoor.getNode1() == roomOrigin ? roomDoor.t2 : roomDoor.t1;
        return pathFilter.test(new PathChange(enterTri, roomDoor));
    }

    public Future<DoorToGoalValue> doorToPointDistance(Mesh m, ANode doorStart, ITpSource target, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        assert (roomOrigin == null || doorStart.isAdjacent(roomOrigin));
        PathGen.PointGoal goal = new PathGen.PointGoal(target);
        if (doorStart.getDoorEdges().stream().anyMatch(doorEdge -> Estimate.canCrossDoor(roomOrigin, doorEdge, pathFilter))) {
            return this.doorToGoalDistance(doorStart, goal, roomOrigin, pathFilter);
        }
        return new CompletedFuture<DoorToGoalValue>(DoorToGoalValue.noPath(doorStart, goal));
    }

    private PointToGoalDist pointToGoalDistanceImpl(WingedEdge door0, double t0, PathGen.IPathGoal goal, Predicate<PathChange> pathFilter) {
        TriPoint[] ptsArr;
        Point3d pt0 = door0.base.get(t0);
        Tri startTri = door0.t1 != null ? door0.t1 : door0.t2;
        PathGen.IPathResult result = PathGen.getPath(this.d_kb.getMesh(), startTri, door0, null, pt0, goal, this.d_radiusMin, Double.MAX_VALUE, pathFilter, null);
        if (!result.isSuccessful()) {
            return null;
        }
        Collection<TriEdge> forwardEdges = result.getEdges();
        List<TriPoint> pts = result.getPoints();
        assert (pts != null && forwardEdges != null);
        assert (forwardEdges.iterator().next().edge == door0);
        IPath tempPath = new FakePath(pts);
        if ((tempPath = PathGen.getPrunedPath(this.d_kb, tempPath, false)) != null) {
            ptsArr = new TriPoint[tempPath.getNumPoints(false)];
            for (int m = 0; m < ptsArr.length; ++m) {
                ptsArr[m] = tempPath.pointAt(m).getSeekPt();
            }
        } else {
            ptsArr = new TriPoint[]{};
        }
        double pathLen = PathGen.getPathLength(Arrays.asList(ptsArr));
        LinkedHashSet<Pair<ANode, DoorDir>> usedDoors = new LinkedHashSet<Pair<ANode, DoorDir>>();
        TriEdge lastEdge = null;
        Iterator<TriEdge> iterator = forwardEdges.iterator();
        while (iterator.hasNext()) {
            TriEdge te;
            lastEdge = te = iterator.next();
            if (!te.edge.isDoor()) continue;
            DoorDir dir = te.edge.isExit() ? te.edge.getExitDir() : te.edge.getDir(te.tri);
            usedDoors.add(new Pair<ANode, DoorDir>(te.edge.getDoorNode(), dir));
        }
        TriEdge firstEdge = forwardEdges.iterator().next();
        DoorDir fwdDir = firstEdge.edge.getDir(firstEdge.tri);
        DoorDir revDir = forwardEdges.size() == 1 ? fwdDir : (lastEdge.edge.isExit() ? lastEdge.edge.getExitDir().opposite() : lastEdge.edge.getDir(lastEdge.tri).opposite());
        PointToGoalDist forVal = new PointToGoalDist(door0, t0, pathLen, pathLen, fwdDir, revDir, ptsArr, usedDoors);
        return forVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DoorToGoalPair getDoorToGoalPair(ANode doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        DoorToGoalKey key = new DoorToGoalKey(doorStart, goal, roomOrigin, pathFilter);
        Map<DoorToGoalKey, DoorToGoalPair> map = this.memo_doorToDoorDistance;
        synchronized (map) {
            DoorToGoalPair result = this.memo_doorToDoorDistance.get(key);
            if (result == null) {
                result = new DoorToGoalPair(doorStart, goal);
                this.memo_doorToDoorDistance.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<DoorToGoalValue> doorToGoalDistance(ANode doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        DoorToGoalPair pair;
        assert (roomOrigin == null || doorStart.isAdjacent(roomOrigin));
        Function<Consumer, Future> calc = cacheResult -> {
            double[] dArray;
            Supplier<DoorToGoalValue> getEarlyResult = () -> {
                SplitEdge[] sedges = this.d_kb.getMesh().getShortenedEdges(this.d_radiusMin);
                ArrayList<WingedEdge> doorEdges = new ArrayList<WingedEdge>(doorStart.getDoorEdges());
                doorEdges.removeIf(doorEdge -> {
                    SplitEdge sedge = sedges[doorEdge.id];
                    if (sedge != null && !sedge.isTravellable()) {
                        return true;
                    }
                    return !Estimate.canCrossDoor(roomOrigin, doorEdge, pathFilter);
                });
                if (doorEdges.isEmpty()) {
                    return DoorToGoalValue.noPath(doorStart, goal);
                }
                if (doorEdges.stream().anyMatch(doorEdge -> goal.testReached(new PathChange(null, (WingedEdge)doorEdge), null) != null)) {
                    PathGen.IPathGoal vgoal = doorStart.isExitDoor() ? PathGen.newDoorGoal(doorStart) : goal;
                    return DoorToGoalValue.zeroPath(doorStart, vgoal, roomOrigin);
                }
                return null;
            };
            DoorToGoalValue earlyResultPair = getEarlyResult.get();
            if (earlyResultPair != null) {
                cacheResult.accept(earlyResultPair);
                return new CompletedFuture<DoorToGoalValue>(earlyResultPair);
            }
            ArrayList<Future<PointToGoalDist>> pointFutures = new ArrayList<Future<PointToGoalDist>>();
            DoorGeom dg = doorStart.getDoorGeom();
            SplitDoor sdoor = this.d_kb.getMesh().getShortenedDoor(this.d_radiusMin, doorStart);
            assert (sdoor == null || sdoor.isTravellable());
            double doorLen = dg.length;
            if (sdoor == null) {
                double[] dArray2 = new double[2];
                dArray2[0] = 0.0;
                dArray = dArray2;
                dArray2[1] = 1.0;
            } else {
                dArray = sdoor.splits;
            }
            double[] ssplits = dArray;
            int n = 0;
            while (n < ssplits.length) {
                double t1 = ssplits[n++];
                double t2 = ssplits[n++];
                double segLen = (t2 - t1) * doorLen;
                int nPoints = (int)Math.max(1.0, (double)Math.round(segLen / DOOR_SEG_TOL));
                int nSegs = nPoints + 1;
                double iNSegs = 1.0 / (double)nSegs;
                for (int m = 1; m < nSegs; ++m) {
                    double t = theUtil.lerp(t1, t2, (double)m * iNSegs);
                    Callable<PointToGoalDist> ptask = () -> {
                        Engine.TIME_ACCUM.begin("DTD");
                        Pair<Integer, Double> et = dg.getEdgeT(t);
                        WingedEdge doorEdge = dg.edges.get((Integer)et.v1);
                        double edget = (Double)et.v2;
                        PointToGoalDist value = this.pointToGoalDistanceImpl(doorEdge, edget, goal, roomOrigin, pathFilter);
                        Engine.TIME_ACCUM.end("DTD");
                        return value;
                    };
                    pointFutures.add(this.d_workerExecutor.submit(ptask));
                }
            }
            Callable<DoorToGoalValue> task = () -> {
                ArrayList<PointToGoalDist> dists = new ArrayList<PointToGoalDist>(pointFutures.size());
                for (Future fdist : pointFutures) {
                    PointToGoalDist pdist = (PointToGoalDist)fdist.get();
                    if (pdist == null || !pdist.areDoorsConnected()) continue;
                    dists.add(pdist);
                }
                DoorToGoalValue result = dists.isEmpty() ? DoorToGoalValue.noPath(doorStart, goal) : new DoorToGoalValue(doorStart, goal, true, dists);
                cacheResult.accept(result);
                return result;
            };
            return this.d_workerExecutor.submit(task);
        };
        if (!goal.isStatic(this.d_kb)) {
            return calc.apply(r -> {});
        }
        DoorToGoalPair doorToGoalPair = pair = this.getDoorToGoalPair(doorStart, goal, roomOrigin, pathFilter);
        synchronized (doorToGoalPair) {
            Future value = pair.getValue();
            if (value == null) {
                value = calc.apply(r -> {
                    DoorToGoalPair doorToGoalPair = pair;
                    synchronized (doorToGoalPair) {
                        pair.setValue(new CompletedFuture<DoorToGoalValue>((DoorToGoalValue)r));
                    }
                });
                pair.setValue(value);
            }
            return value;
        }
    }

    protected PointToGoalDist pointToGoalDistanceImpl(WingedEdge doorStart, double t0, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        PathChange tempPathChange = new PathChange();
        Predicate<PathChange> baseFilter = pathFilter;
        Predicate<PathChange> searchFilter = o -> {
            if (o.getType() == PathChange.Type.PATH_BEGIN) {
                assert (o.tri == doorStart.t1 || o.tri == doorStart.t2);
                tempPathChange.set(o.tri, doorStart, o.history);
                o = tempPathChange;
            }
            return baseFilter.test((PathChange)o);
        };
        PointToGoalDist result = this.pointToGoalDistanceImpl(doorStart, t0, goal, searchFilter);
        if (result == null) {
            return null;
        }
        assert (result.isValid());
        ANode destNode = result.getDestNode(doorStart.getDoorNode());
        if (destNode == null) {
            return result;
        }
        if (destNode != roomOrigin && !this.getAStarFailed(doorStart, goal, roomOrigin, pathFilter, result)) {
            return result;
        }
        PointToGoalDist resultForced = this.pointToDoorDistanceNeverRevistAnyRoom(doorStart, t0, goal, roomOrigin, pathFilter);
        if (resultForced == null) {
            return null;
        }
        double naturalDist = Math.min(result.naturalDist, resultForced.naturalDist);
        resultForced = resultForced.setNaturalDist(naturalDist);
        assert (resultForced.isValid());
        result = resultForced;
        return result;
    }

    private boolean getAStarFailed(WingedEdge doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter, PointToGoalDist naturalResult) {
        return false;
    }

    private PointToGoalDist pointToDoorDistanceNeverRevistAnyRoom(final WingedEdge doorStart, double t0, PathGen.IPathGoal goal, final ANode roomOrigin, Predicate<PathChange> pathFilter) {
        final Predicate<PathChange> baseFilter = pathFilter;
        final PathChange tempPathChange = new PathChange();
        Predicate<PathChange> searchFilter = new Predicate<PathChange>(){

            @Override
            public boolean test(PathChange o) {
                PathChange.Type type = o.getType();
                if (type == PathChange.Type.PATH_BEGIN) {
                    if (o.tri.node == roomOrigin) {
                        return false;
                    }
                    assert (o.tri == doorStart.t1 || o.tri == doorStart.t2);
                    tempPathChange.set(o.tri, doorStart, o.history);
                    o = tempPathChange;
                } else if (type == PathChange.Type.TRI_ENTER && o.edge.isDoor() && !o.edge.isInternal()) {
                    ANode newNode = o.tri.node;
                    if (newNode == roomOrigin) {
                        return false;
                    }
                    if (o.history.isVisited(newNode)) {
                        return false;
                    }
                }
                return baseFilter.test(o);
            }
        };
        return this.pointToGoalDistanceImpl(doorStart, t0, goal, searchFilter);
    }

    public static class DoorToGoalKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ANode doorStart;
        public final PathGen.IPathGoal goal;
        public final ANode roomOrigin;
        public final Predicate<PathChange> pathFilter;
        private final int d_hashCode;

        public DoorToGoalKey(ANode doorStart, PathGen.IPathGoal doorGoal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
            this.doorStart = doorStart;
            this.goal = doorGoal;
            this.roomOrigin = roomOrigin;
            this.pathFilter = pathFilter;
            this.d_hashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            return 1118783 + System.identityHashCode(this.doorStart) + this.goal.hashCode() + System.identityHashCode(this.roomOrigin) + this.pathFilter.hashCode();
        }

        public int hashCode() {
            return this.d_hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DoorToGoalKey)) {
                return false;
            }
            DoorToGoalKey dtd = (DoorToGoalKey)obj;
            return this.doorStart == dtd.doorStart && this.goal.equals(dtd.goal) && this.roomOrigin == dtd.roomOrigin && this.pathFilter.equals(dtd.pathFilter);
        }
    }

    public static class DoorToGoalValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ANode door1;
        public final PathGen.IPathGoal goal;
        public final boolean initialized;
        public final List<PointToGoalDist> dists;
        public final PointToGoalDist minDist;
        public final PointToGoalDist maxDist;
        public final DoorDir dir1;
        public final DoorDir dir2;

        public DoorToGoalValue(ANode door1, PathGen.IPathGoal goal, boolean initialized, List<PointToGoalDist> dists) {
            this.door1 = door1;
            this.goal = goal;
            this.initialized = initialized;
            this.dists = dists;
            Comparator distCompare = (d1, d2) -> Double.compare(d1.dist, d2.dist);
            if (!initialized) {
                this.minDist = this.maxDist = PointToGoalDist.invalidPath(door1);
            } else if (dists.isEmpty()) {
                this.minDist = this.maxDist = PointToGoalDist.noPath(door1);
            } else {
                this.minDist = (PointToGoalDist)dists.stream().min(distCompare).get();
                this.maxDist = (PointToGoalDist)dists.stream().max(distCompare).get();
            }
            if (door1 != null && door1.isExitDoor()) {
                this.dir1 = this.dir2 = door1.getExitDir();
            } else if (dists.isEmpty()) {
                this.dir2 = door1 != null ? DoorDir.POSITIVE : null;
                this.dir1 = this.dir2;
            } else {
                PointToGoalDist dist0 = dists.get(0);
                assert (dists.stream().allMatch(d -> d.dir1 == dist0.dir1)) : String.format("All tail paths from %s should be going in the same direction.", door1.name);
                this.dir1 = dist0.dir1;
                this.dir2 = dist0.dir2;
            }
        }

        public static DoorToGoalValue noPath(ANode doorStart, PathGen.IPathGoal goal) {
            return new DoorToGoalValue(doorStart, goal, true, Collections.emptyList());
        }

        public static DoorToGoalValue zeroPath(ANode door, PathGen.IPathGoal goal, ANode srcNode) {
            DoorDir dir = door.doorQueue.getDir(srcNode).opposite();
            List<PointToGoalDist> points = Collections.singletonList(PointToGoalDist.zeroPath(door, dir));
            return new DoorToGoalValue(door, goal, true, points);
        }

        public PointToGoalDist getDistFrom(Point3d p) {
            List<WingedEdge> doorEdges = this.door1.getDoorEdges();
            if (!this.initialized) {
                return PointToGoalDist.invalidPath(this.door1);
            }
            if (this.dists.isEmpty()) {
                return PointToGoalDist.noPath(this.door1);
            }
            if (this.dists.size() == 1) {
                return this.dists.get(0);
            }
            if (doorEdges.size() == 1) {
                WingedEdge edge = this.door1.getDoorEdges().get(0);
                return DoorToGoalValue.getDistFrom(this.dists, edge, edge.base.get(p));
            }
            double minDistSq = Double.MAX_VALUE;
            PointToGoalDist result = null;
            for (PointToGoalDist dist : this.dists) {
                double distSq = dist.getStartPoint().distanceSquared(p);
                if (!(distSq < minDistSq)) continue;
                minDistSq = distSq;
                result = dist;
            }
            return result;
        }

        private static PointToGoalDist getDistFrom(List<PointToGoalDist> edgeDists, WingedEdge edge, double t) {
            int ix = Collections.binarySearch(edgeDists, t);
            if (ix < 0) {
                if ((ix = -ix - 1) == 0) {
                    return edgeDists.get(0);
                }
                if (ix == edgeDists.size()) {
                    return edgeDists.get(edgeDists.size() - 1);
                }
                PointToGoalDist dist1 = edgeDists.get(ix - 1);
                PointToGoalDist dist2 = edgeDists.get(ix);
                return t - dist1.dist <= dist2.dist - t ? dist1 : dist2;
            }
            return edgeDists.get(ix);
        }

        public DoorDir getDir(ANode door) {
            return door == this.door1 ? this.dir1 : this.dir2;
        }

        public DoorDir getNaturalDir(PointToGoalDist pgdist) {
            DoorDir outDir = this.dir1;
            return pgdist.naturalDist == pgdist.dist ? outDir : outDir.opposite();
        }

        public ANode getDestNode(ANode door) {
            DoorDir dir = this.getDir(door);
            assert (dir != null);
            return door.getDestNode(dir);
        }
    }

    public static class PointToGoalDist
    implements Serializable,
    Comparable<Double> {
        private static final long serialVersionUID = 1L;
        public final WingedEdge edge;
        public final double t;
        public final double dist;
        public final double naturalDist;
        public final DoorDir dir1;
        public final DoorDir dir2;
        public final TriPoint[] path;
        public final Set<Pair<ANode, DoorDir>> usedDoors;

        public PointToGoalDist(WingedEdge doorEdge, double t, double dist, double naturalDist, DoorDir dir1, DoorDir dir2, TriPoint[] path, Collection<Pair<ANode, DoorDir>> usedDoors) {
            assert (usedDoors != null && Util.isOrdered(usedDoors));
            this.edge = doorEdge;
            this.t = t;
            this.dist = dist;
            this.naturalDist = naturalDist;
            this.dir1 = dir1;
            this.dir2 = dir2;
            this.path = path == null ? new TriPoint[]{} : path;
            this.usedDoors = usedDoors == null || usedDoors instanceof Set ? (Set<Object>)usedDoors : new LinkedHashSet<Pair<ANode, DoorDir>>(usedDoors);
        }

        public Point3d getStartPoint() {
            return this.edge.get(this.t);
        }

        public static PointToGoalDist invalidPath(WingedEdge edge, double t) {
            return new PointToGoalDist(edge, t, Double.NaN, Double.NaN, null, null, new TriPoint[0], Collections.emptyList());
        }

        public static PointToGoalDist invalidPath(ANode door) {
            return PointToGoalDist.invalidPath(door.getDoorEdges().get(door.getDoorEdges().size() / 2), 0.5);
        }

        private static PointToGoalDist noPath(WingedEdge edge, double t) {
            assert (edge != null);
            DoorDir dir = edge.isExit() ? edge.getExitDir() : DoorDir.POSITIVE;
            return new PointToGoalDist(edge, t, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, dir, dir, new TriPoint[0], Collections.emptyList());
        }

        public static PointToGoalDist noPath(ANode door) {
            return PointToGoalDist.noPath(door.getDoorEdges().get(door.getDoorEdges().size() / 2), 0.5);
        }

        public static PointToGoalDist zeroPath(WingedEdge door, double t, DoorDir exitDir) {
            return new PointToGoalDist(door, t, 0.0, 0.0, exitDir, exitDir, new TriPoint[0], Collections.singleton(new Pair<ANode, DoorDir>(door.getDoorNode(), exitDir)));
        }

        public static PointToGoalDist zeroPath(ANode door, DoorDir exitDir) {
            return PointToGoalDist.zeroPath(door.getDoorEdges().get(door.getDoorEdges().size() / 2), 0.5, exitDir);
        }

        public PointToGoalDist setNaturalDist(double ndist) {
            return new PointToGoalDist(this.edge, this.t, this.dist, ndist, this.dir1, this.dir2, this.path, this.usedDoors);
        }

        @Override
        public int compareTo(Double o) {
            return Double.compare(this.t, o);
        }

        public ANode getDestNode(ANode door) {
            DoorDir dir;
            DoorDir doorDir = dir = door == this.edge.getDoorNode() ? this.dir1 : this.dir2;
            assert (dir != null);
            return door.getDestNode(dir);
        }

        public boolean isValid() {
            return this.isInitialized() && (!this.areDoorsConnected() || this.dist == 0.0 || this.dir1 != null);
        }

        private boolean isInitialized() {
            return !Double.isNaN(this.dist);
        }

        public boolean areDoorsConnected() {
            return !Double.isInfinite(this.dist);
        }
    }

    public static class DoorToGoalPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ANode door1;
        public final PathGen.IPathGoal goal;
        public Future<DoorToGoalValue> val12;

        public DoorToGoalPair(ANode door1, PathGen.IPathGoal goal) {
            this.door1 = door1;
            this.goal = goal;
            this.val12 = null;
        }

        public Future<DoorToGoalValue> getValue() {
            return this.val12;
        }

        public void setValue(Future<DoorToGoalValue> val) {
            this.val12 = val;
        }
    }

    private static class FakePath
    implements IPath {
        private final List<TriPoint> points;

        public FakePath(List<TriPoint> points) {
            this.points = points;
        }

        @Override
        public int getNumPoints(boolean fuzzy) {
            return this.points.size();
        }

        @Override
        public Pair<ANode, DoorDir> getTargetDoor() {
            return null;
        }

        @Override
        public double length(boolean fuzzy) {
            return 0.0;
        }

        @Override
        public IPathSeek pointAt(int ix) {
            return new WaypointSeek(this.points.get(ix), Filters.acceptAll(WingedEdge.class));
        }
    }
}

