/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.sim.path.IPathHistory;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.StringPull;
import inferno.util.IdSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.MutableInt;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class AStar {
    private static final NextNodeType DEFAULT_NEXT_NODE = NextNodeType.STRING_PULL_FAST;
    public static final IAStar DEFAULT_ASTAR_TYPE = new AStarSingle();
    private static final double DEF_SAMPLE_DIST = 0.5;
    private static final int DEF_MAX_SAMPLE_SEGS = 3;
    private static final int DEF_MIN_SAMPLE_SEGS = 1;

    public static List<TriEdge> getPathEdgePoints(MTSearchNode goalNode) {
        return (List)AStar.getPathEdgePointsAndRootNode((MTSearchNode)goalNode).v2;
    }

    public static Pair<MTSearchNode, List<TriEdge>> getPathEdgePointsAndRootNode(MTSearchNode goalNode) {
        ArrayList<TriEdge> revPath = new ArrayList<TriEdge>();
        MTSearchNode root = null;
        WingedEdge prevEdge = null;
        while (goalNode != null) {
            root = goalNode;
            WingedEdge edge = goalNode.edge;
            if (edge != null && edge != prevEdge) {
                revPath.add(new TriEdge(goalNode.dstTri, edge));
                prevEdge = edge;
            }
            goalNode = goalNode.parent;
        }
        return new Pair<MTSearchNode, List<TriEdge>>(root, theUtil.reverse(revPath));
    }

    public static double getPathLength(MTSearchNode pathEnd) {
        return pathEnd.g;
    }

    private static <T> void printNodeData(MTSearchNode node, Function<MTSearchNode, T> mapper) {
        while (node != null) {
            System.out.println(mapper.apply(node));
            node = node.parent;
        }
    }

    private static void printPoints(MTSearchNode node) {
        AStar.printNodeData(node, n -> node.destpt);
    }

    private static void printEdges(MTSearchNode node) {
        AStar.printNodeData(node, n -> node.edge);
    }

    private static void printGs(MTSearchNode node) {
        AStar.printNodeData(node, n -> node.g);
    }

    private static void printFs(MTSearchNode node) {
        AStar.printNodeData(node, n -> node.f);
    }

    public static PathGen.IPathResult getPathAStarDetailed(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
        return DEFAULT_ASTAR_TYPE.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
    }

    private static int getStartNodes(SplitEdge[] sedges, int startid, Point3d startPt, Tri startTri, WingedEdge startEdge, Vertex startVertex, PathGen.IPathGoal goal, Predicate<PathChange> pathFilter, Collection<MTSearchNode> open, Set<WingedEdge> closed) {
        TriEdge[] edges = Mesh.getTouchingEdges(startTri, startEdge, startVertex, startPt);
        if (edges.length == 0) {
            if (pathFilter.test(new PathChange(startTri, null))) {
                open.add(AStar.getStartNode(sedges, startid++, goal, startTri, null, false, startPt));
            }
        } else {
            PathChange pc = new PathChange();
            for (TriEdge edge : edges) {
                boolean landedOnEdge = false;
                if (!pathFilter.test(pc.set(edge.tri, edge.edge))) {
                    if (!pathFilter.test(pc.set(null, edge.edge))) continue;
                    landedOnEdge = true;
                }
                if (sedges[edge.edge.id] != null && !sedges[edge.edge.id].isTravellable()) continue;
                closed.add(edge.edge);
                open.add(AStar.getStartNode(sedges, startid++, goal, edge.tri, edge.edge, landedOnEdge, startPt));
            }
        }
        return startid;
    }

    private static MTSearchNode getNextNodeClosestPoint(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, PathGen.IDistFactor getDistFactor) {
        Point3d dstPt = AStar.getClosestPointOnEdge(edge, sedges[edge.id], parent.destpt);
        return MTSearchNode.newDestNode(id, sedges, parent, dstTri, edge, landedOnEdge, dstPt, parent.corner, goal, null, getDistFactor);
    }

    private static MTSearchNode getNextNodeMidpoint(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, PathGen.IDistFactor getDistFactor) {
        Point3d dstPt = AStar.getMidpointOnEdge(edge, sedges[edge.id]);
        return MTSearchNode.newDestNode(id, sedges, parent, dstTri, edge, landedOnEdge, dstPt, parent.corner, goal, null, getDistFactor);
    }

    private static MTSearchNode getNextNodeStringPullFull(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, PathGen.IDistFactor getDistFactor) {
        double h;
        double g;
        TriPoint dstPt;
        Pair<PathGen.GoalDest, Double> testResult;
        PathGen.GoalDest goalReached;
        List<TriEdge> edges = new ArrayList<TriEdge>();
        edges.add(new TriEdge(dstTri, edge));
        MTSearchNode node = parent;
        while (node != null) {
            if (node.edge != null) {
                edges.add(new TriEdge(node.dstTri, node.edge));
            }
            node = node.parent;
        }
        List<TriPoint> points = StringPull.stringPullFixedStartPoint(mesh, edges = theUtil.reverse(edges), goalReached = (testResult = goal.testReached(new PathChange(landedOnEdge ? null : dstTri, edge, null), startPt.p)) != null ? (PathGen.GoalDest)testResult.v1 : null, startPt, goal, radius);
        if (!points.isEmpty()) {
            if (goalReached != null && goalReached.edge == edge) {
                dstPt = points.get(points.size() - 1);
                g = PathGen.getPathLength(points);
                h = 0.0;
            } else if (points.size() >= 2) {
                dstPt = points.get(points.size() - 2);
                g = PathGen.getPathLength(points.subList(0, points.size() - 1));
                h = dstPt.p.distance(points.get((int)(points.size() - 1)).p);
            } else {
                dstPt = startPt;
                g = 0.0;
                h = dstPt.p.distance(points.get((int)0).p);
            }
        } else {
            g = 0.0;
            h = goal.getMinDistance(sedges, startPt.p);
            dstPt = startPt;
        }
        return new MTSearchNode(id, parent, dstTri, edge, landedOnEdge, dstPt.p, parent.corner, g, h, parent.destpt.distance(dstPt.p), null, getDistFactor);
    }

    private static MTSearchNode getNextNodeStringPull(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, PathGen.IDistFactor getDistFactor) {
        Pair<CornerNode, Point3d> spresult = AStar.stringPullQuickAndDirty(mesh, sedges, goal, parent, edge, getDistFactor);
        CornerNode corner = (CornerNode)spresult.v1;
        Point3d dstPt = (Point3d)spresult.v2;
        double g = AStar.calcG(sedges, parent, dstPt, corner, getDistFactor);
        double h = goal.getDistance(sedges, corner.nearestGoal, dstPt);
        MTSearchNode node = new MTSearchNode(id, parent, dstTri, edge, landedOnEdge, dstPt, corner, g, h, parent.destpt.distance(dstPt), null, getDistFactor);
        AStar.applyEdgeFilter(node, dstTri, edge);
        return node;
    }

    private static Pair<CornerNode, Point3d> stringPullQuickAndDirty(Mesh mesh, SplitEdge[] sedges, PathGen.IPathGoal goal, MTSearchNode parent, WingedEdge edge, PathGen.IDistFactor getDistFactor) {
        Pair<Object, WingedEdge> testNode = new Pair<Object, WingedEdge>(null, edge);
        CornerNode corner = parent.corner;
        while (corner.edge != testNode.v2) {
            NextCorner nextCorner = AStar.findNextCorner(mesh, sedges, corner, goal, testNode, p -> (WingedEdge)p.v2, p -> p.v1 == null ? new Pair<MTSearchNode, WingedEdge>(parent, parent.edge) : new Pair<MTSearchNode, WingedEdge>(((MTSearchNode)p.v1).parent, ((MTSearchNode)p.v1).parent.edge));
            if (nextCorner == null) {
                Point3d dstPt = AStar.getClosestPointOnEdge((WingedEdge)testNode.v2, sedges[((WingedEdge)testNode.v2).id], corner.nearestGoalPt.p);
                return new Pair<CornerNode, Point3d>(corner, dstPt);
            }
            WingedEdge nextCornerEdge = nextCorner.edge;
            Point3d nextCornerPt = nextCorner.edgePt;
            if (nextCornerEdge == testNode.v2) {
                return new Pair<CornerNode, Point3d>(corner, nextCornerPt);
            }
            Pair<PathGen.GoalDest, TriPoint> projected = goal.project(sedges, nextCornerPt);
            assert (projected != null);
            MTSearchNode cornerNode = parent;
            while (cornerNode != null && cornerNode.edge != nextCornerEdge) {
                cornerNode = cornerNode.parent;
            }
            assert (cornerNode != null);
            double cornerG = cornerNode != null ? AStar.calcG(sedges, cornerNode, nextCornerPt, corner, getDistFactor) : corner.g + corner.loc.distance(nextCornerPt);
            corner = new CornerNode(nextCornerEdge, nextCornerPt, cornerG, (PathGen.GoalDest)projected.v1, (TriPoint)projected.v2);
        }
        assert (false);
        return new Pair<CornerNode, Point3d>(corner, corner.loc);
    }

    private static <T> NextCorner findNextCorner(Mesh mesh, SplitEdge[] sedges, CornerNode prevCorner, PathGen.IPathGoal goal, T nextNode, Function<T, WingedEdge> getEdge, Function<T, T> getParent) {
        Point3d endPt = prevCorner.nearestGoalPt.p;
        WingedEdge cornerEdge = prevCorner.edge;
        T node = nextNode;
        double[] st = new double[2];
        while (node != null && getEdge.apply(node) != null && getEdge.apply(node) != prevCorner.edge) {
            Pair<Boolean, Point3d> cresult = StringPull.classifySPEdge(prevCorner.loc, endPt, getEdge.apply(node), sedges, st);
            assert (cresult != null);
            if (!((Boolean)cresult.v1).booleanValue()) {
                if (cornerEdge != prevCorner.edge) break;
                WingedEdge edge = getEdge.apply(nextNode);
                Point3d testEdgePt = nextNode == node ? (Point3d)cresult.v2 : AStar.getClosestPointOnEdge(edge, sedges[edge.id], endPt);
                return new NextCorner(edge, testEdgePt);
            }
            endPt = (Point3d)cresult.v2;
            cornerEdge = getEdge.apply(node);
            node = getParent.apply(node);
        }
        if (cornerEdge != prevCorner.edge) {
            return new NextCorner(cornerEdge, endPt);
        }
        return null;
    }

    private static double calcG(SplitEdge[] sedges, MTSearchNode node, Point3d endPt, CornerNode startCorner, PathGen.IDistFactor getDistFactor) {
        double[] st = new double[2];
        double distFactor = getDistFactor.getDistFactor(node.dstTri);
        double totDist = 0.0;
        while (node.edge != null && node.edge != startCorner.edge && node.parent != null) {
            double triFactor = node.distFactor.getDistFactor(node.parent.dstTri);
            if (distFactor != triFactor) {
                Pair<Boolean, Point3d> cresult = StringPull.classifySPEdge(startCorner.loc, endPt, node.edge, sedges, st);
                Point3d isectPt = (Point3d)cresult.v2;
                double segmentDist = isectPt.distance(endPt);
                totDist += segmentDist * distFactor;
                distFactor = triFactor;
                endPt = isectPt;
            }
            node = node.parent;
        }
        double finalDist = startCorner.loc.distance(endPt);
        return startCorner.g + (totDist += finalDist * distFactor);
    }

    private static Point3d getClosestPointOnEdge(WingedEdge edge, SplitEdge sedge, Point3d p) {
        double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
        if (sedge == null) {
            return Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
        }
        double sedget = sedge.findClosest(neart);
        assert (!Double.isNaN(sedget));
        return sedge.get(sedget);
    }

    private static Point3d getMidpointOnEdge(WingedEdge edge, SplitEdge sedge) {
        if (sedge == null) {
            return edge.base.midpoint();
        }
        double sedget = sedge.findClosest(0.5);
        assert (!Double.isNaN(sedget));
        return sedge.get(sedget);
    }

    private static MTSearchNode getStartNode(SplitEdge[] sedges, int id, PathGen.IPathGoal goal, Tri startTri, WingedEdge startEdge, boolean landedOnEdge, Point3d startPt) {
        Pair<PathGen.GoalDest, TriPoint> projected = goal.project(sedges, startPt);
        assert (projected != null);
        MTSearchNode node = new MTSearchNode(id, null, startTri, startEdge, landedOnEdge, startPt, new CornerNode(startEdge, startPt, 0.0, (PathGen.GoalDest)projected.v1, (TriPoint)projected.v2), 0.0, goal.getDistance(sedges, (PathGen.GoalDest)projected.v1, startPt), 0.0, null, PathGen.DEFAULT_DIST_FACTOR);
        AStar.applyEdgeFilter(node, startTri, startEdge);
        return node;
    }

    private static void applyEdgeFilter(MTSearchNode node, Tri tri, WingedEdge edge) {
        if (tri != null && tri.node != null && tri.node.isTransportNode() && edge != null && edge.isTransportDoor()) {
            node.edgeFilter = AStar.rejectAllConnectedDoors(tri.node);
        }
    }

    public static Predicate<PathGen.SearchConnection> rejectAllConnectedDoors(final ANode node) {
        return new APredicate<PathGen.SearchConnection>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean test(PathGen.SearchConnection t) {
                return !t.eu.wedge.isDoor() || !t.eu.wedge.isAdjacent(node);
            }
        };
    }

    public static class DebugInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<MTSearchNode> openedNodes = new ArrayList<MTSearchNode>();
        public final PathGen.IPathGoal goal;

        public DebugInfo(PathGen.IPathGoal goal) {
            this.goal = goal;
        }
    }

    private static class NextCorner {
        public final WingedEdge edge;
        public final Point3d edgePt;

        public NextCorner(WingedEdge edge, Point3d edgePt) {
            this.edge = edge;
            this.edgePt = edgePt;
        }
    }

    public static interface IGetNextNode {
        public MTSearchNode get(Mesh var1, SplitEdge[] var2, TriPoint var3, PathGen.IPathGoal var4, double var5, int var7, MTSearchNode var8, Tri var9, WingedEdge var10, boolean var11, PathGen.IDistFactor var12);
    }

    public static interface IAStar
    extends PathGen.IPathGen {
        @Override
        public PathGen.IPathResult generatePath(Mesh var1, Tri var2, WingedEdge var3, Vertex var4, Point3d var5, PathGen.IPathGoal var6, double var7, double var9, Predicate<PathChange> var11, Consumer<DebugInfo> var12);
    }

    public static class AStarSampled
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final int minSamples;
        public final int maxSamples;
        public final double sampleDist;

        public AStarSampled() {
            this(1, 3, 0.5);
        }

        public AStarSampled(int minSamples, int maxSamples, double sampleDist) {
            this.minSamples = minSamples;
            this.maxSamples = maxSamples;
            this.sampleDist = sampleDist;
        }

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> {
                    DebugInfo dbg = di;
                    dbg.openedNodes.add((MTSearchNode)node);
                };
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            HashMap<WingedEdge, List> edgeNodes = new HashMap<WingedEdge, List>();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            int nodeid = 0;
            nodeid = AStar.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, new IdentityHashSet<WingedEdge>());
            double[] fullSeg = new double[]{0.0, 1.0};
            PathChange pc = new PathChange();
            while (!open.isEmpty()) {
                MTSearchNode node2 = open.pollFirst();
                debugNodes.accept(node2);
                WingedEdge crossedEdge = node2.destEdge();
                Pair<PathGen.GoalDest, Double> result = goal.testReached(pc.set(node2.landedOnEdge ? null : node2.destTri(), crossedEdge, node2), node2.destpt);
                if (result != null) {
                    assert ((Double)result.v2 == 0.0) : String.format("%s cannot be used with goal type: %s", this.getClass().getSimpleName(), goal.getClass().getSimpleName());
                    goalNode = node2;
                    reachResult = (PathGen.GoalDest)result.v1;
                    break;
                }
                if (node2.landedOnEdge || node2.dstTri == null) continue;
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    List newEdgeNodes;
                    WingedEdge edge;
                    if (!node2.edgeFilter.test(connection) || (edge = connection.eu.wedge) == crossedEdge) continue;
                    if (edge.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    Tri adjTri = connection.tri;
                    boolean landedOnEdge = false;
                    if (!pathFilter.test(pc.set(adjTri, edge, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge, node2))) {
                            failures |= 4;
                            continue;
                        }
                        landedOnEdge = true;
                    }
                    List existingEdgeNodes = (newEdgeNodes = edgeNodes.computeIfAbsent(edge, e -> new ArrayList())).isEmpty() ? null : newEdgeNodes;
                    int ix = 0;
                    double[] segs = sedge == null ? fullSeg : sedge.splits;
                    int m = 0;
                    while (m < segs.length) {
                        double t1 = segs[m++];
                        double t2 = segs[m++];
                        double elen = edge.base.length();
                        int nsegs = Math.min(Math.max(this.minSamples, (int)Math.ceil((t2 - t1) * elen / this.sampleDist)), this.maxSamples);
                        double toffset = 0.5 / (double)nsegs;
                        double insamples = 1.0 / (double)nsegs;
                        int n = 0;
                        while (n < nsegs) {
                            double h;
                            double t = theUtil.lerp(t1, t2, toffset + (double)n * insamples);
                            Point3d p = edge.base.get(t);
                            MTSearchNode existingNode = existingEdgeNodes != null ? (MTSearchNode)existingEdgeNodes.get(ix) : null;
                            double distTraveled = node2.destpt.distance(p);
                            double g = node2.g + PathGen.getCost(node2.dstTri, distTraveled);
                            double f = g + (h = existingNode != null ? existingNode.f - existingNode.g : goal.getMinDistance(sedges, p));
                            if (!(f > abortDist)) {
                                MTSearchNode tentativeNode;
                                if (existingNode == null) {
                                    tentativeNode = new MTSearchNode(nodeid++, node2, adjTri, edge, landedOnEdge, p, node2.corner, g, h, distTraveled, null, connection.distFactor);
                                    open.add(tentativeNode);
                                    newEdgeNodes.add(tentativeNode);
                                } else if (g < existingNode.g) {
                                    open.remove(existingNode);
                                    tentativeNode = new MTSearchNode(nodeid++, node2, adjTri, edge, landedOnEdge, p, node2.corner, g, h, distTraveled, null, connection.distFactor);
                                    open.add(tentativeNode);
                                    existingEdgeNodes.set(ix, tentativeNode);
                                }
                            }
                            ++n;
                            ++ix;
                        }
                    }
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult, true);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarStringPull
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> di.openedNodes.add((MTSearchNode)node);
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            int nodeid = 0;
            nodeid = AStar.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, new IdentityHashSet<WingedEdge>());
            PathChange pc = new PathChange();
            while (!open.isEmpty()) {
                MTSearchNode node2 = open.pollFirst();
                debugNodes.accept(node2);
                WingedEdge crossedEdge = node2.destEdge();
                Pair<PathGen.GoalDest, Double> result = goal.testReached(pc.set(node2.landedOnEdge ? null : node2.destTri(), crossedEdge, node2), node2.destpt);
                if (result != null) {
                    assert ((Double)result.v2 == 0.0) : String.format("%s cannot be used with goal type: %s", this.getClass().getSimpleName(), goal.getClass().getSimpleName());
                    goalNode = node2;
                    reachResult = (PathGen.GoalDest)result.v1;
                    break;
                }
                if (node2.landedOnEdge || node2.dstTri == null) continue;
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    WingedEdge edge;
                    if (!node2.edgeFilter.test(connection) || node2.contains(edge = connection.eu.wedge)) continue;
                    if (edge.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    Tri adjTri = connection.tri;
                    boolean landedOnEdge = false;
                    if (!pathFilter.test(pc.set(adjTri, edge, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge, node2))) {
                            failures |= 4;
                            continue;
                        }
                        landedOnEdge = true;
                    }
                    MTSearchNode tentativeNode = AStar.getNextNodeStringPullFull(navMesh, sedges, new TriPoint(startTri, startPt), goal, radius, nodeid, node2, adjTri, edge, landedOnEdge, connection.distFactor);
                    if (tentativeNode.f > abortDist) continue;
                    open.add(tentativeNode);
                    ++nodeid;
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult, false);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarSingle
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final IGetNextNode nextNode;

        public AStarSingle() {
            this(AStar.DEFAULT_NEXT_NODE.getNextNode);
        }

        public AStarSingle(IGetNextNode nextNode) {
            this.nextNode = nextNode;
        }

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> di.openedNodes.add((MTSearchNode)node);
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            IdSet<WingedEdge> closed = new IdSet<WingedEdge>();
            LinkedIdentityHashMap edgeNodes = new LinkedIdentityHashMap();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            MutableInt nodeid = new MutableInt();
            nodeid.set(AStar.getStartNodes(sedges, nodeid.val, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, closed));
            TriPoint startTriPt = new TriPoint(startTri, startPt);
            PathChange pc = new PathChange();
            BiConsumer<WingedEdge, MTSearchNode> addTentativeNode = (edge, tentativeNode) -> {
                if (tentativeNode == null || tentativeNode.f > abortDist) {
                    return;
                }
                MTSearchNode existingNode = (MTSearchNode)edgeNodes.get(edge);
                if (existingNode == null || tentativeNode.g < existingNode.g) {
                    if (existingNode != null) {
                        open.remove(existingNode);
                    }
                    open.add((MTSearchNode)tentativeNode);
                    edgeNodes.put(edge, tentativeNode);
                    nodeid.preInc();
                }
            };
            while (!open.isEmpty()) {
                WingedEdge crossedEdge;
                MTSearchNode node2 = open.pollFirst();
                debugNodes.accept(node2);
                if (node2.dest != null) {
                    goalNode = node2;
                    reachResult = node2.dest;
                    break;
                }
                Pair<PathGen.GoalDest, Double> result = goal.testReached(pc.set(node2.landedOnEdge ? null : node2.destTri(), crossedEdge = node2.destEdge(), node2), node2.destpt);
                if (result != null) {
                    if (theUtil.eq0((Double)result.v2, 1.0E-6)) {
                        goalNode = node2;
                        reachResult = (PathGen.GoalDest)result.v1;
                        break;
                    }
                    edgeNodes.remove(crossedEdge);
                    addTentativeNode.accept(crossedEdge, new MTSearchNode(nodeid.val, node2.parent, node2.dstTri, node2.edge, node2.landedOnEdge, node2.destpt, node2.corner, node2.g, (Double)result.v2, node2.parent != null ? node2.length - node2.parent.length : node2.length, (PathGen.GoalDest)result.v1, node2.distFactor));
                }
                if (node2.landedOnEdge || node2.dstTri == null) continue;
                if (crossedEdge != null) {
                    closed.add(crossedEdge);
                    edgeNodes.remove(crossedEdge);
                }
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    WingedEdge edge2;
                    if (!node2.edgeFilter.test(connection) || (edge2 = connection.eu.wedge) == crossedEdge || closed.contains(edge2)) continue;
                    if (edge2.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge2.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    boolean landedOnEdge = false;
                    Tri adjTri = connection.tri;
                    if (!pathFilter.test(pc.set(adjTri, edge2, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge2, node2))) {
                            failures |= 4;
                            continue;
                        }
                        landedOnEdge = true;
                    }
                    MTSearchNode tentativeNode2 = this.nextNode.get(navMesh, sedges, startTriPt, goal, radius, nodeid.val, node2, adjTri, edge2, landedOnEdge, connection.distFactor);
                    addTentativeNode.accept(edge2, tentativeNode2);
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult, true);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarSuccess
    implements PathGen.IPathResult {
        public final MTSearchNode node;
        public final PathGen.GoalDest goalReached;
        public final boolean needsCleanup;

        public AStarSuccess(MTSearchNode node, PathGen.GoalDest goalReached, boolean needsCleanup) {
            this.node = node;
            this.goalReached = goalReached;
            this.needsCleanup = needsCleanup;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public double getLength() {
            double len = this.node.length;
            if (this.goalReached.point != null) {
                len += this.node.destpt.distance(this.goalReached.point.p);
            }
            return len;
        }

        @Override
        public double getCost() {
            double cost = this.node.g;
            if (this.goalReached.point != null) {
                cost += PathGen.getCost(this.goalReached.point.tri, this.node.destpt.distance(this.goalReached.point.p));
            }
            return cost;
        }

        @Override
        public List<TriPoint> getPoints() {
            ArrayList<TriPoint> rev = new ArrayList<TriPoint>();
            MTSearchNode n = this.node;
            if (this.node.dstTri == null) {
                Tri lastTri;
                assert (this.goalReached.edge != null && this.goalReached.edge.isExit());
                Tri tri = lastTri = this.node.parent != null ? this.node.parent.dstTri : this.node.edge.getAdjTri(null);
                assert (lastTri != null);
                rev.add(new TriPoint(lastTri, this.node.destpt, this.node.edge));
                n = this.node.parent;
            } else if (this.goalReached.point != null) {
                TriPoint lastNodePt = new TriPoint(this.node.dstTri, this.node.destpt, this.node.edge);
                if (!this.goalReached.point.tolEquals(lastNodePt, 1.0E-12)) {
                    rev.add(this.goalReached.point);
                }
                rev.add(lastNodePt);
                n = this.node.parent;
            }
            while (n != null) {
                assert (n.dstTri != null);
                rev.add(new TriPoint(n.dstTri, n.destpt, n.edge));
                n = n.parent;
            }
            return theUtil.reverse(rev);
        }

        @Override
        public int getFailureCodes() {
            return 0;
        }
    }

    public static class MTSearchNode
    implements Comparable<MTSearchNode>,
    IPathHistory,
    Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final MTSearchNode parent;
        public final int pathCount;
        public final double g;
        public final double f;
        public final double length;
        public final WingedEdge edge;
        public final boolean landedOnEdge;
        public final Tri dstTri;
        public final Point3d destpt;
        public final CornerNode corner;
        public final PathGen.GoalDest dest;
        public Predicate<PathGen.SearchConnection> edgeFilter;
        public final PathGen.IDistFactor distFactor;

        public static MTSearchNode newDestNode(int id, SplitEdge[] sedges, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, Point3d dstPt, CornerNode corner, PathGen.IPathGoal goal, PathGen.GoalDest dest, PathGen.IDistFactor distFactor) {
            double distTraveled = parent.destpt.distance(dstPt);
            return new MTSearchNode(id, parent, dstTri, edge, landedOnEdge, dstPt, corner, parent.g + PathGen.getCost(parent.dstTri, distTraveled), goal.getMinDistance(sedges, dstPt), distTraveled, dest, distFactor);
        }

        public MTSearchNode(int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, Point3d dstPt, CornerNode corner, double g, double h, double parentToThisDist, PathGen.GoalDest dest, PathGen.IDistFactor distFactor) {
            assert (dstTri != null || edge != null && edge.isExit());
            this.id = id;
            this.parent = parent;
            this.dest = dest;
            this.edge = edge;
            this.landedOnEdge = landedOnEdge;
            this.dstTri = dstTri;
            this.destpt = dstPt;
            this.corner = corner;
            this.distFactor = distFactor;
            this.g = g;
            this.f = g + h;
            if (parent == null) {
                this.edgeFilter = Predicates.alwaysTrue();
                this.pathCount = 1;
                this.length = 0.0;
            } else {
                assert (parent.dstTri != null);
                this.pathCount = parent.pathCount + 1;
                this.length = parent.length + parentToThisDist;
                this.edgeFilter = parent.edgeFilter;
            }
        }

        @Override
        public boolean isVisited(ANode room) {
            MTSearchNode node = this.parent;
            while (node != null) {
                assert (!node.landedOnEdge);
                if (node.destTri() != null && node.destTri().node == room) {
                    return true;
                }
                node = node.parent;
            }
            return false;
        }

        public boolean contains(WingedEdge edge) {
            MTSearchNode p = this;
            while (p != null) {
                if (edge == p.edge) {
                    return true;
                }
                p = p.parent;
            }
            return false;
        }

        public Tri destTri() {
            return this.dstTri;
        }

        public WingedEdge destEdge() {
            return this.edge;
        }

        public Point3d destPt() {
            return this.destpt;
        }

        public double distToDest() {
            return this.parent != null ? this.parent.destpt.distance(this.destpt) : 0.0;
        }

        public int getPathCount() {
            return this.pathCount;
        }

        @Override
        public int compareTo(MTSearchNode o) {
            int result = Double.compare(this.f, o.f);
            if (result == 0) {
                if (this.equals(o)) {
                    return 0;
                }
                int count1 = this.getPathCount();
                int count2 = o.getPathCount();
                assert (this.id != o.id);
                return count1 == count2 ? Integer.signum(this.id - o.id) : Integer.signum(count1 - count2);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MTSearchNode)) {
                return false;
            }
            MTSearchNode node = (MTSearchNode)obj;
            boolean result = this.g == node.g && this.f == node.f && this.landedOnEdge == node.landedOnEdge && Objects.equals(this.dstTri, node.dstTri) && Objects.equals(this.edge, node.edge) && this.destpt.equals(node.destpt);
            return result;
        }

        public String toString() {
            if (this.parent == null) {
                return "Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
            }
            return "...Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
        }

        private double s(double d) {
            int i = (int)(d * 100.0);
            return (double)i / 100.0;
        }
    }

    public static class CornerNode
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;
        public final Point3d loc;
        public final double g;
        public final PathGen.GoalDest nearestGoal;
        public final TriPoint nearestGoalPt;

        public CornerNode(WingedEdge edge, Point3d loc, double g, PathGen.GoalDest nearestGoal, TriPoint nearestGoalPt) {
            this.edge = edge;
            this.loc = loc;
            this.g = g;
            this.nearestGoal = nearestGoal;
            this.nearestGoalPt = nearestGoalPt;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CornerNode && ((CornerNode)obj).edge == this.edge && ((CornerNode)obj).g == this.g && ((CornerNode)obj).loc.equals(this.loc);
        }
    }

    public static enum NextNodeType {
        MIDPOINT((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10) -> AStar.getNextNodeMidpoint(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10)),
        CLOSEST_POINT((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10) -> AStar.getNextNodeClosestPoint(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10)),
        STRING_PULL_FAST((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10) -> AStar.getNextNodeStringPull(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10)),
        STRING_PULL_FULL((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10) -> AStar.getNextNodeStringPullFull(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10));

        public final IGetNextNode getNextNode;

        private NextNodeType(IGetNextNode getNextNode) {
            this.getNextNode = getNextNode;
        }
    }
}

