/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.io.CSVWriter;
import inferno.sim.output.WriterIntl;
import java.util.ArrayList;

public class HeaderWriterFiveRow {
    private ArrayList<FiveRowHeader> d_headers;

    public HeaderWriterFiveRow(int capacity) {
        this.d_headers = new ArrayList(capacity);
    }

    public void addCol(String description, String quantity, String unit, Long resultsId, String objectName) {
        this.d_headers.add(new FiveRowHeader(description, quantity, unit, resultsId, objectName));
    }

    public void addCol(String description) {
        this.d_headers.add(new FiveRowHeader(description, null, null, null, null));
    }

    public void addCol(String description, String quantity) {
        this.d_headers.add(new FiveRowHeader(description, quantity, null, null, null));
    }

    public void addCol(String description, String quantity, String unit) {
        this.d_headers.add(new FiveRowHeader(description, quantity, unit, null, null));
    }

    public void addCol(WriterIntl.IColHeader header) {
        this.d_headers.add(new FiveRowHeader(header.desc().fileStr, header.quantity().fileStr, header.unit().fileStr, null, null));
    }

    public void addCol(WriterIntl.IColHeader header, Long resultsId, String objectName) {
        this.d_headers.add(new FiveRowHeader(header.desc().fileStr, header.quantity().fileStr, header.unit().fileStr, resultsId, objectName));
    }

    public void flushTo(CSVWriter writer) {
        for (FiveRowHeader header : this.d_headers) {
            writer.add(CSVWriter.escape(header.description));
        }
        writer.nextRow();
        for (FiveRowHeader header : this.d_headers) {
            writer.add(header.objectName);
        }
        writer.nextRow();
        for (FiveRowHeader header : this.d_headers) {
            writer.add(header.resultsId);
        }
        writer.nextRow();
        for (FiveRowHeader header : this.d_headers) {
            writer.add(header.quantity);
        }
        writer.nextRow();
        for (FiveRowHeader header : this.d_headers) {
            writer.add(header.unit);
        }
        writer.nextRow();
        this.d_headers.clear();
    }

    private class FiveRowHeader {
        final String description;
        final String quantity;
        final String unit;
        final Long resultsId;
        final String objectName;

        FiveRowHeader(String description, String quantity, String unit, Long resultsId, String objectName) {
            this.description = description;
            this.quantity = quantity;
            this.unit = unit;
            this.resultsId = resultsId;
            this.objectName = objectName;
        }
    }
}

