/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.occsource;

import inferno.data2.value.IFunction1d;
import inferno.data2.value.ImpulseFunction1d;
import inferno.sim.KB;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.ToIntFunction;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.util.stat.ProbabilityDistributions;

public class DistributedOccSourceFlowrate
implements IOccSourceFlowrate,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ImpulseFunction1d function;
    public final long occSourceSeed;
    public final Distribution dist;
    private int d_currPulseIx = 0;
    private double d_prevReleaseTime = Double.NaN;
    private double d_nextReleaseTime = Double.NaN;
    private final Random d_rand;

    public DistributedOccSourceFlowrate(ImpulseFunction1d f, long occSourceSeed, Distribution dist) {
        assert (f.defaultValue == 0.0);
        this.function = f;
        this.occSourceSeed = occSourceSeed;
        this.dist = dist;
        this.d_rand = new Random(occSourceSeed ^ 0xAF783234098L);
    }

    @Override
    public int releaseOccs(KB kb, double dt) {
        double simTime = kb.getCurrentSimTime() + dt;
        int toRelease = 0;
        while (this.testReleaseNext(kb, simTime)) {
            ++toRelease;
        }
        return toRelease;
    }

    private boolean testReleaseNext(KB kb, double simTime) {
        IntToDoubleFunction getDeltaTime = pulseIx -> {
            ImpulseFunction1d.Pulse pulse = this.function.entries.get(pulseIx);
            double rate = pulse.y;
            return this.dist.dist.nextInterval(rate, this.d_rand.nextDouble());
        };
        Runnable calcNextReleaseTime = () -> {
            this.d_nextReleaseTime = Double.POSITIVE_INFINITY;
            while (this.d_currPulseIx < this.function.entries.size()) {
                ImpulseFunction1d.Pulse pulse = this.function.entries.get(this.d_currPulseIx);
                double nextTime = this.d_prevReleaseTime + getDeltaTime.applyAsDouble(this.d_currPulseIx);
                if (nextTime <= pulse.getX2()) {
                    this.d_nextReleaseTime = nextTime;
                    break;
                }
                if (this.d_currPulseIx < this.function.entries.size() - 1) {
                    this.d_prevReleaseTime = this.function.entries.get((int)(this.d_currPulseIx + 1)).x;
                }
                ++this.d_currPulseIx;
            }
        };
        if (Double.isNaN(this.d_nextReleaseTime)) {
            this.d_nextReleaseTime = Double.POSITIVE_INFINITY;
            if (!this.function.entries.isEmpty()) {
                this.d_prevReleaseTime = this.function.entries.get((int)0).x;
                calcNextReleaseTime.run();
            }
        }
        if (simTime < this.d_nextReleaseTime) {
            return false;
        }
        this.d_prevReleaseTime = this.d_nextReleaseTime;
        calcNextReleaseTime.run();
        return true;
    }

    @Override
    public int getMaxCount(double maxTime) {
        return (int)Math.round(this.function.getAUC(0.0, maxTime));
    }

    @Override
    public boolean isFlowing(KB kb) {
        return this.function.get(kb.getCurrentSimTime()) > 0.0;
    }

    @Override
    public double getEndTime(KB kb) {
        return this.function.getEndX();
    }

    @Override
    public void getFunctions(Consumer<? super IFunction1d> functions) {
        functions.accept(this.function);
    }

    @Override
    public JSONObject toJson(ToIntFunction<IFunction1d> distIndex) {
        JSONObject jobj = new JSONObject();
        jobj.put("type", "distributed");
        jobj.put("distribution", this.dist.name());
        jobj.put("function", distIndex.applyAsInt(this.function));
        jobj.put("seed", this.occSourceSeed);
        return jobj;
    }

    public static DistributedOccSourceFlowrate fromJson(JSONObject jobj, IntFunction<IFunction1d> functions) throws Exception {
        Object type = jobj.get("type");
        if (!type.equals("distributed")) {
            throw new Exception();
        }
        ImpulseFunction1d func = (ImpulseFunction1d)functions.apply(JsonUtil.getInt(jobj, "function"));
        String distName = (String)jobj.get("distribution");
        Distribution dist = Distribution.valueOf(distName);
        long seed = JsonUtil.getLong(jobj, "seed");
        return new DistributedOccSourceFlowrate(func, seed, dist);
    }

    public static interface IIntervalDistribution {
        public double nextInterval(double var1, double var3);
    }

    public static enum Distribution {
        POISSON(ProbabilityDistributions::nextPoissonInterarrivalDelay);

        public final IIntervalDistribution dist;

        private Distribution(IIntervalDistribution dist) {
            this.dist = dist;
        }
    }
}

