/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.WaitForeverGoal;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.IGoalAiCore;
import inferno.sim.steering.ISteeringBehavior;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class LostAiCore
implements IGoalAiCore,
Serializable {
    private static final long serialVersionUID = 1L;
    private IGoalInstance d_goalInstance;
    private ISteeringBehavior d_steer;
    private ISeekArea d_seekArea;
    private OccTarget d_occTarget;

    @Override
    public IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return this.d_goalInstance;
    }

    @Override
    public Collection<ISeekArea> getSeekHistory() {
        return Collections.emptyList();
    }

    @Override
    public ISeekArea getCurrentSeekArea(KB kb, OccAgent agent) {
        return this.d_seekArea;
    }

    @Override
    public void init(KB kb, OccAgent agent) {
        this.d_goalInstance = WaitForeverGoal.INSTANCE.begin(kb, agent);
        if (this.d_steer != null) {
            this.d_steer.done(kb, agent, false);
        }
        this.d_steer = this.d_goalInstance.generateSteeringBehavior(kb, agent);
        this.d_seekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, this.d_goalInstance);
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        return this.d_steer;
    }

    @Override
    public boolean isSeeking(KB kb, OccAgent agent) {
        return false;
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
    }

    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        this.d_occTarget = IGoalAiCore.calcOccTargetInUse(kb, agent, this.d_goalInstance);
        agent.updateStats(kb, e.getCurrentDt());
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_goalInstance.doorCrossed(agent, door);
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return this.d_goalInstance.getProgress(kb, agent);
    }

    @Override
    public Optional<AttractorSim> getAttractorInUse(KB kb, OccAgent agent) {
        return Optional.empty();
    }

    @Override
    public Optional<OccTarget> getOccTargetInUse(KB kb, OccAgent agent) {
        return Optional.ofNullable(this.d_occTarget);
    }
}

