/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Tag;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.IGoal;
import inferno.sim.OccProfileSim;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class BehaviorSim
implements Serializable,
Iterable<IGoal> {
    static final long serialVersionUID = 1L;
    private static final long s_delaySeed = 275670542901161L;
    public final List<IGoal> goals;
    public final String name;
    public final Color color;

    public BehaviorSim(String name, Color color, List<IGoal> goals) {
        this.name = name;
        this.goals = goals;
        this.color = color;
    }

    public List<IGoal> copyGoals() {
        return new ArrayList<IGoal>(this.goals);
    }

    public IGoal get(int ix) {
        return this.goals.get(ix);
    }

    public boolean isEmpty() {
        return this.goals.isEmpty();
    }

    public int size() {
        return this.goals.size();
    }

    @Override
    public Iterator<IGoal> iterator() {
        return this.goals.iterator();
    }

    public String toString() {
        return this.goals.toString();
    }

    private static List<IGoal> removeDuplicateTags(List<IGoal> goals) {
        int i;
        HashSet<Integer> toRemove = new HashSet<Integer>();
        ArrayList<IGoal> result = new ArrayList<IGoal>();
        boolean lastGoalStartedSeen = false;
        for (i = goals.size() - 1; i >= 0; --i) {
            IGoal goal = goals.get(i);
            if (!(goal instanceof ChangeTagGoal)) continue;
            ChangeTagGoal changeTag = (ChangeTagGoal)goal;
            boolean containsLastGoal = false;
            for (Tag tag : changeTag.tags) {
                if (!tag.name.equals("last_goal_started")) continue;
                containsLastGoal = true;
                break;
            }
            if (!containsLastGoal) continue;
            if (!lastGoalStartedSeen) {
                lastGoalStartedSeen = true;
                continue;
            }
            toRemove.add(i);
        }
        for (i = 0; i < goals.size(); ++i) {
            if (toRemove.contains(i)) continue;
            result.add(goals.get(i));
        }
        return result;
    }

    public Set<BehaviorSim> getReferencedBehaviors() {
        LinkedIdentityHashSet<BehaviorSim> result = new LinkedIdentityHashSet<BehaviorSim>();
        this.getReferencedBehaviors(result);
        return result;
    }

    public void getReferencedBehaviors(Set<BehaviorSim> allUsedBehaviors) {
        for (IGoal goal : this.goals) {
            if (!(goal instanceof ChangeBehaviorGoal)) continue;
            for (BehaviorSim b : ((ChangeBehaviorGoal)goal).getAllTargetBehaviors()) {
                if (allUsedBehaviors.contains(b)) continue;
                allUsedBehaviors.add(b);
                b.getReferencedBehaviors(allUsedBehaviors);
            }
        }
    }

    public void getReferencedProfiles(Set<? super BehaviorSim> visitedBehaviors, Consumer<? super OccProfileSim> allUsedProfiles) {
        if (!visitedBehaviors.add(this)) {
            return;
        }
        for (IGoal goal : this.goals) {
            goal.getReferencedProfiles(visitedBehaviors, allUsedProfiles);
        }
    }

    public <T> void getFutureProfileValues(Set<? super BehaviorSim> visitedBehaviors, OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        if (!visitedBehaviors.add(this)) {
            return;
        }
        for (IGoal goal : this.goals) {
            goal.getFutureProfileValues(visitedBehaviors, prop, result);
        }
    }

    public <T extends IGoal> Collection<T> deepFlatten(Class<T> type) {
        return this.deepFlatten(type, this, 0, Predicates.alwaysTrue(), false);
    }

    public Collection<IGoal> deepFlatten() {
        return this.deepFlatten(IGoal.class);
    }

    public <T extends IGoal> boolean deepContainsAny(Class<T> type) {
        return !this.deepFlatten(type, this, 0, Predicates.alwaysTrue(), true).isEmpty();
    }

    public <T extends IGoal> Collection<T> deepFlatten(Class<T> type, BehaviorSim startingBehavior, int startingGoalIndex, Predicate<T> filter, boolean findAny) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        ArrayDeque<Node> open = new ArrayDeque<Node>();
        IdentityHashSet closed = new IdentityHashSet();
        open.push(new Node(this, Collections.emptySet(), null));
        boolean behaviorStarted = false;
        boolean indexStarted = false;
        while (!open.isEmpty()) {
            Node n = (Node)open.pop();
            BehaviorSim b = n.behavior;
            if (!closed.add(b)) continue;
            if (!behaviorStarted && b == startingBehavior) {
                Node curNode = n;
                while (curNode != null) {
                    closed.addAll(curNode.siblings);
                    curNode = curNode.parent;
                }
                behaviorStarted = true;
            }
            if (behaviorStarted) {
                int ix = 0;
                for (IGoal g : b) {
                    if ((indexStarted || ix >= startingGoalIndex) && type.isAssignableFrom(g.getClass()) && filter.test(g)) {
                        result.add(g);
                        if (findAny) {
                            return result;
                        }
                    }
                    ++ix;
                }
            }
            indexStarted |= behaviorStarted;
            for (IGoal g : b) {
                if (!(g instanceof ChangeBehaviorGoal)) continue;
                Set<BehaviorSim> children = ((ChangeBehaviorGoal)g).getAllTargetBehaviors();
                children.forEach(c -> open.push(new Node((BehaviorSim)c, children, n)));
            }
        }
        return result;
    }

    public static class BehaviorInProgress
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final BehaviorSim behavior;
        public final int goalIndex;

        public BehaviorInProgress(BehaviorSim behavior, int goalIndex) {
            this.behavior = behavior;
            this.goalIndex = goalIndex;
        }

        public BehaviorInProgress(BehaviorSim behavior) {
            this(behavior, 0);
        }
    }

    private static class Node {
        public final BehaviorSim behavior;
        public final Set<BehaviorSim> siblings;
        public final Node parent;

        public Node(BehaviorSim behavior, Set<BehaviorSim> siblings, Node parent) {
            this.behavior = behavior;
            this.siblings = siblings;
            this.parent = parent;
        }
    }
}

