/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.ANode;
import inferno.data2.EdgeData;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.ConnectedMesh;
import inferno.geom.Plane3d;
import inferno.geom.ValueFld;
import inferno.geom.VectorFld;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.TriInterpolator3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.DataCache;
import thunderheadeng.util.DataListCache;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NodeUtil {
    private static final int[] PLUSONEMODTHREE = new int[]{1, 2, 0};
    private static final int[] MINUSONEMODTHREE = new int[]{2, 0, 1};

    public static TriangulateResult triangulate(ANode node, double maxArea) {
        TriInfo result;
        ArrayList<Pair<Plane3d, ArrayList<Tri>>> connectedFaces = new ArrayList<Pair<Plane3d, ArrayList<Tri>>>();
        IdentityHashSet<Tri> closedFaces = new IdentityHashSet<Tri>();
        for (Tri face : node.getMesh()) {
            if (!closedFaces.add(face)) continue;
            ArrayList<Tri> faces2 = new ArrayList<Tri>();
            Plane3d plane = NodeUtil.findConnectedPlanarFaces(face, faces2, closedFaces, t -> t.node == node);
            if (faces2.isEmpty()) continue;
            connectedFaces.add(new Pair<Plane3d, ArrayList<Tri>>(plane, faces2));
        }
        ArrayList triSets = new ArrayList();
        double maxEdgeLen = Math.sqrt(2.0 * maxArea / Math.sin(Math.toRadians(60.0)));
        connectedFaces.parallelStream().forEach(faces -> {
            try {
                Mesh dmesh = new Mesh();
                dmesh.setRefinementOptions(0);
                dmesh.setMaxArea(maxArea);
                TriInfo ti = NodeUtil.triangulate((List)faces.v2, (Plane3d)faces.v1, maxEdgeLen, dmesh);
                List list = triSets;
                synchronized (list) {
                    triSets.add(ti);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        if (triSets.size() == 1) {
            result = (TriInfo)triSets.get(0);
        } else {
            DataListCache<Point3d> pointCache = new DataListCache<Point3d>();
            ArrayList<Object> vidMap = new ArrayList<Object>();
            ArrayList<Integer> tris = new ArrayList<Integer>();
            ArrayList<EdgeData> triEdges = new ArrayList<EdgeData>();
            ArrayList<Integer> triAdj = new ArrayList<Integer>();
            for (TriInfo ti : triSets) {
                vidMap.clear();
                vidMap.ensureCapacity(ti.verts.length);
                Integer[] vmap = new Integer[ti.verts.length];
                for (int m = 0; m < ti.verts.length; ++m) {
                    Point3d p = ti.verts[m];
                    Object i = pointCache.get((Object)p);
                    vidMap.add(i);
                    vmap[m] = i;
                }
                int triOffset = tris.size();
                tris.ensureCapacity(tris.size() + ti.tris.length);
                for (int vix : ti.tris) {
                    tris.add(vmap[vix]);
                }
                triEdges.addAll(Arrays.asList(ti.triEdges));
                triAdj.ensureCapacity(triAdj.size() + ti.triAdjacency.length);
                for (int adjTri : ti.triAdjacency) {
                    triAdj.add(adjTri + triOffset);
                }
            }
            result = new TriInfo(pointCache.toArray(Point3d.class), theUtil.toIntArray(tris), theUtil.toArray(triEdges, EdgeData.class), theUtil.toIntArray(triAdj));
        }
        return NodeUtil.convertTriInfo(node, result);
    }

    /*
     * WARNING - void declaration
     */
    private static TriangulateResult convertTriInfo(ANode node, TriInfo ti) {
        ArrayList<ConnectedMesh.Vertex> tempVerts = new ArrayList<ConnectedMesh.Vertex>(ti.verts.length);
        for (int m = 0; m < ti.verts.length; ++m) {
            tempVerts.add(new ConnectedMesh.Vertex(m, ti.verts[m]));
        }
        LinkedHashMap<IxEdge, ConnectedMesh.Edge> resultEdges = new LinkedHashMap<IxEdge, ConnectedMesh.Edge>();
        Function<IxEdge, ConnectedMesh.Edge> newEdge = iedge -> {
            ConnectedMesh.Vertex v1 = (ConnectedMesh.Vertex)tempVerts.get(iedge.i1);
            ConnectedMesh.Vertex v2 = (ConnectedMesh.Vertex)tempVerts.get(iedge.i2);
            return new ConnectedMesh.Edge(resultEdges.size(), v1, v2);
        };
        ConnectedMesh.Tri[] resultTris = new ConnectedMesh.Tri[ti.tris.length / 3];
        LinkedIdentityHashMap<ConnectedMesh.Edge, EdgeData> doorEdges = new LinkedIdentityHashMap<ConnectedMesh.Edge, EdgeData>();
        for (int m = 0; m < ti.tris.length; m += 3) {
            void var10_15;
            ConnectedMesh.Vertex[] triverts = new ConnectedMesh.Vertex[3];
            for (int n = 0; n < 3; ++n) {
                triverts[n] = (ConnectedMesh.Vertex)tempVerts.get(ti.tris[m + n]);
            }
            ConnectedMesh.Edge[] triedges = new ConnectedMesh.Edge[3];
            boolean bl = false;
            while (var10_15 < 3) {
                IxEdge iedge2;
                int i1 = ti.tris[m + var10_15];
                int i2 = ti.tris[m + PLUSONEMODTHREE[var10_15]];
                EdgeData ed = ti.triEdges[m + var10_15];
                if (ed.type == 4) {
                    IxEdgeDirected iedge22 = new IxEdgeDirected(i1, i2);
                } else {
                    iedge2 = new IxEdge(i1, i2);
                }
                triedges[var10_15] = resultEdges.computeIfAbsent(iedge2, newEdge);
                if (ed.isDoor()) {
                    doorEdges.put(triedges[var10_15], ed);
                }
                ++var10_15;
            }
            ConnectedMesh.Tri tri = new ConnectedMesh.Tri(m / 3, triverts, triedges);
            for (int n = 0; n < 3; ++n) {
                ConnectedMesh.Edge edge = triedges[n];
                if (edge.n1 == triverts[n]) {
                    assert (edge.t1 == null) : "encountered non-manifold sub-mesh";
                    edge.t1 = tri;
                    continue;
                }
                assert (edge.n2 == triverts[n]);
                assert (edge.t2 == null) : "encountered non-manifold sub-mesh";
                edge.t2 = tri;
            }
            resultTris[tri.id] = tri;
        }
        ArrayDeque<ConnectedMesh.Tri> open = new ArrayDeque<ConnectedMesh.Tri>();
        IdentityHashSet closed = new IdentityHashSet();
        LinkedIdentityHashSet resultVerts = new LinkedIdentityHashSet();
        for (ConnectedMesh.Tri tri : resultTris) {
            for (int m = 0; m < 3; ++m) {
                ConnectedMesh.Vertex[] vert = tri.verts[m];
                if (resultVerts.contains(vert)) continue;
                ConnectedMesh.Vertex newVert = new ConnectedMesh.Vertex(resultVerts.size(), vert.p);
                resultVerts.add(newVert);
                open.push(tri);
                closed.add(tri);
                while (!open.isEmpty()) {
                    ConnectedMesh.Edge[] edges;
                    ConnectedMesh.Tri t = (ConnectedMesh.Tri)open.pop();
                    int tn = -1;
                    for (int n = 0; n < 3; ++n) {
                        if (t.verts[n] != vert) continue;
                        tn = n;
                        break;
                    }
                    if (tn == -1) continue;
                    t.verts[tn] = newVert;
                    for (ConnectedMesh.Edge e2 : edges = new ConnectedMesh.Edge[]{t.edges[tn], t.edges[MINUSONEMODTHREE[tn]]}) {
                        if (e2.n1 == vert) {
                            e2.n1 = newVert;
                        } else if (e2.n2 == vert) {
                            e2.n2 = newVert;
                        }
                        ConnectedMesh.Tri atri = e2.getAdjTri(t);
                        if (atri == null || !closed.add(atri)) continue;
                        open.push(atri);
                    }
                }
                closed.clear();
            }
        }
        DataCache<ConnectedMesh.Vertex, List> dataCache = new DataCache<ConnectedMesh.Vertex, List>(new IdentityHashMap(), v -> new ArrayList());
        for (ConnectedMesh.Tri tri : resultTris) {
            for (ConnectedMesh.Vertex v2 : tri.verts) {
                dataCache.get(v2).add(tri);
            }
        }
        dataCache.map.entrySet().forEach(e -> {
            ((ConnectedMesh.Vertex)e.getKey()).tris = theUtil.toArray((Collection)e.getValue(), ConnectedMesh.Tri.class);
        });
        DataCache<ANode, List> resultDoorVerts = new DataCache<ANode, List>(new LinkedIdentityHashMap(), e -> new ArrayList(2));
        for (Map.Entry entry : doorEdges.entrySet()) {
            ConnectedMesh.Edge cedge = (ConnectedMesh.Edge)entry.getKey();
            EdgeData ed = (EdgeData)entry.getValue();
            ConnectedMesh.Vertex ev1 = cedge.n1;
            ConnectedMesh.Vertex ev2 = cedge.n2;
            List everts = resultDoorVerts.get(ed.node);
            if (!everts.contains(ev1)) {
                everts.add(ev1);
            }
            if (everts.contains(ev2)) continue;
            everts.add(ev2);
        }
        return new TriangulateResult(new ConnectedMesh(theUtil.toArray(resultVerts, ConnectedMesh.Vertex.class), theUtil.toArray(resultEdges.values(), ConnectedMesh.Edge.class), resultTris), resultDoorVerts.map, ti.triEdges);
    }

    private static TriInfo triangulate(List<Tri> faces, Plane3d iplane, double maxEdgeLen, Mesh dmesh) throws Exception {
        if (faces.isEmpty()) {
            throw new Exception("No triangles");
        }
        thunderheadeng.geometry.Plane3d plane = new thunderheadeng.geometry.Plane3d(iplane.x, iplane.y, iplane.z, iplane.w);
        Matrix4d wlxform = Util.getWorldToLocalXform(plane);
        LinkedHashMap p2dCache = new LinkedHashMap();
        Function<Point2d, Integer> newP2dId = p -> {
            dmesh.addPoint(p.x, p.y);
            return p2dCache.size();
        };
        HashMap rev2d3dMap = new HashMap();
        Function<Point3d, Integer> p3dIdFunc = p -> {
            Point3d pp = Util3D.xform(wlxform, p, true);
            Point2d pp2d = new Point2d(pp.x, pp.y);
            rev2d3dMap.put(pp2d, p);
            return (Integer)p2dCache.computeIfAbsent(pp2d, newP2dId);
        };
        DataListCache<EdgeData> edmapper = new DataListCache<EdgeData>();
        int edmapperOffset = 3;
        edmapper.get((Object)new EdgeData(null, 0));
        IdentityHashSet<Tri> faceSet = new IdentityHashSet<Tri>(faces);
        BiPredicate<Tri, WingedEdge> noAdjacentFaces = (face, weu) -> {
            Tri other = weu.getAdjTri((Tri)face);
            return other == null || !faceSet.contains(other);
        };
        Predicate<WingedEdge> isBoundary = e -> e.t1 == null || e.t2 == null || e.isBoundary();
        ToDoubleBiFunction<Point3d, Point3d> compareP3d = (p1, p2) -> {
            if (p1.x != p2.x) {
                return p1.x - p2.x;
            }
            if (p1.y != p2.y) {
                return p1.y - p2.y;
            }
            return p1.z - p2.z;
        };
        IdentityHashSet closedEdges = new IdentityHashSet();
        for (Tri face2 : faces) {
            for (WingedEdgeUse weu2 : face2.eu) {
                int ilast;
                Point3d p22;
                boolean setBoundary;
                WingedEdge edge = weu2.wedge;
                if (!closedEdges.add(edge)) continue;
                boolean bl = setBoundary = isBoundary.test(edge) || !edge.isInternal() || noAdjacentFaces.test(face2, edge);
                if (!setBoundary) continue;
                Point3d p12 = edge.p1();
                double comp = compareP3d.applyAsDouble(p12, p22 = edge.p2());
                if (comp > 0.0) {
                    Point3d temp = p12;
                    p12 = p22;
                    p22 = temp;
                }
                int iprev = p3dIdFunc.apply(p12);
                int edid = edmapper.indexOf(edge.data) + edmapperOffset;
                double elen = p12.distance(p22);
                if (elen > maxEdgeLen) {
                    int count = (int)Math.ceil(elen / maxEdgeLen);
                    double tinc = 1.0 / (double)count;
                    for (int m = 1; m < count; ++m) {
                        double t = (double)m * tinc;
                        Point3d p3 = Util3D.lerp(p12, p22, t);
                        int icurr = p3dIdFunc.apply(p3);
                        if (iprev == icurr) continue;
                        dmesh.addEdge(iprev, icurr, edid);
                        iprev = icurr;
                    }
                }
                if (iprev == (ilast = p3dIdFunc.apply(p22).intValue())) continue;
                dmesh.addEdge(iprev, ilast, edid);
            }
        }
        if (!dmesh.triangulateEvenOdd(1)) {
            throw new Exception("Could not triangulate connected area");
        }
        TriangulatorInfo result = dmesh.getOutput(5);
        HashMap<IxEdge, Integer> edgeDataMap = new HashMap<IxEdge, Integer>();
        for (int m = 0; m < result.edgeIds.length; ++m) {
            int eid = result.edgeIds[m];
            if (eid == -1) continue;
            int n = m * 2;
            IxEdge iedge = new IxEdge(result.edges[n], result.edges[n + 1]);
            edgeDataMap.put(iedge, eid);
        }
        Point3d[] resultVerts = new Point3d[result.points.length];
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        for (int m = 0; m < result.points.length; ++m) {
            Point2d p4 = result.points[m];
            Point3d p3d = (Point3d)rev2d3dMap.get(p4);
            if (p3d == null) {
                p3d = Util3D.xform(lwXform, new Point3d(p4.x, p4.y, 0.0), true);
            }
            resultVerts[m] = p3d;
        }
        EdgeData[] allEdges = edmapper.toArray(EdgeData.class);
        EdgeData[] triEdges = new EdgeData[result.triangles.length];
        for (int m = 0; m < result.triangles.length; m += 3) {
            for (int n = 0; n < 3; ++n) {
                IxEdge iedge = new IxEdge(result.triangles[m + n], result.triangles[m + PLUSONEMODTHREE[n]]);
                int eid = edgeDataMap.getOrDefault(iedge, edmapperOffset);
                triEdges[m + n] = allEdges[eid - edmapperOffset];
            }
        }
        return new TriInfo(resultVerts, result.triangles, triEdges, result.adjTris);
    }

    private static Plane3d findConnectedPlanarFaces(Tri seed, List<Tri> connectedFaces, Set<Tri> closedFaces, Predicate<Tri> triFilter) {
        ArrayDeque<Tri> open = new ArrayDeque<Tri>();
        open.push(seed);
        Vector3d normal = seed.normal;
        while (!open.isEmpty()) {
            Tri f = (Tri)open.pop();
            connectedFaces.add(f);
            for (WingedEdgeUse weu : f.eu) {
                Tri f2;
                if (!weu.wedge.isInternal() || (f2 = weu.wedge.getAdjTri(f)) == null) continue;
                Vector3d normal2 = f2.normal;
                if (closedFaces.contains(f2) || !normal.epsilonEquals(normal2, 1.0E-12) || !triFilter.test(f2)) continue;
                closedFaces.add(f2);
                open.push(f2);
            }
        }
        return seed.plane;
    }

    public static float[] getRange(float[] vals) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (float d : vals) {
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        return new float[]{min, max};
    }

    public static ValueFld getNodeDoorDistances(int fieldId, ConnectedMesh nodeMesh, TriInterpolator3d[] triInfo, Collection<ConnectedMesh.Vertex> doorVerts) {
        float[] vdists = NodeUtil.calcVDists(nodeMesh, doorVerts);
        float[] range = NodeUtil.getRange(vdists);
        return new ValueFld(fieldId, nodeMesh, triInfo, vdists, range);
    }

    private static float[] calcVDists(ConnectedMesh nodeMesh, Collection<ConnectedMesh.Vertex> doorVerts) {
        float[] result = new float[nodeMesh.verts.length];
        Arrays.fill(result, Float.POSITIVE_INFINITY);
        NodeUtil.pushZero(result, nodeMesh, doorVerts);
        return result;
    }

    private static void pushZero(float[] dists, ConnectedMesh mesh, Collection<ConnectedMesh.Vertex> zero) {
        PriorityQueue<PushNode> open = new PriorityQueue<PushNode>();
        for (ConnectedMesh.Vertex v : zero) {
            open.add(new PushNode(v.id, 0.0f));
        }
        IdentityHashSet closedVerts = new IdentityHashSet();
        while (!open.isEmpty()) {
            PushNode obj = (PushNode)open.remove();
            ConnectedMesh.Vertex v = mesh.verts[obj.vert];
            float dist = obj.val;
            int vix = obj.vert;
            if (!(dist < dists[vix])) continue;
            dists[vix] = dist;
            closedVerts.clear();
            for (ConnectedMesh.Tri t : v.tris) {
                for (ConnectedMesh.Vertex vAdj : t.verts) {
                    if (vAdj == v || !closedVerts.add(vAdj)) continue;
                    float distAdj = (float)v.p.distance(vAdj.p);
                    open.add(new PushNode(vAdj.id, dist + distAdj));
                }
            }
        }
    }

    public static VectorFld calcMaxDistVectorFld(ConnectedMesh mesh, TriInterpolator3d[] triInterp, ValueFld dists, double tolerance) {
        ArrayList<ConnectedMesh.Vertex> maxVerts = new ArrayList<ConnectedMesh.Vertex>();
        double maxDist = Double.NEGATIVE_INFINITY;
        for (ConnectedMesh.Vertex vert : mesh.verts) {
            double dist = dists.vertVals.applyAsDouble(vert.id);
            int comp = theUtil.compare(dist, maxDist, tolerance);
            if (comp > 0) {
                maxVerts.clear();
                maxVerts.add(vert);
                maxDist = dist;
                continue;
            }
            if (comp != 0) continue;
            maxVerts.add(vert);
        }
        return NodeUtil.calcSinkVectorFld(mesh, triInterp, maxVerts);
    }

    public static VectorFld calcSinkVectorFld(ConnectedMesh mesh, TriInterpolator3d[] triInterp, Collection<ConnectedMesh.Vertex> sinks) {
        int[] sinkVerts = NodeUtil.calcVertSinks(mesh, sinks);
        return new VectorFld(mesh, triInterp, sinkVerts);
    }

    private static int[] calcVertSinks(ConnectedMesh nodeMesh, Collection<ConnectedMesh.Vertex> sinkVerts) {
        int[] result = new int[nodeMesh.verts.length];
        NodeUtil.pushSinks(result, nodeMesh, sinkVerts);
        return result;
    }

    private static void pushSinks(int[] vertSinks, ConnectedMesh mesh, Collection<ConnectedMesh.Vertex> sinks) {
        if (sinks.isEmpty()) {
            for (int m = 0; m < vertSinks.length; ++m) {
                vertSinks[m] = m;
            }
            return;
        }
        PriorityQueue<SinkNode> open = new PriorityQueue<SinkNode>();
        for (ConnectedMesh.Vertex v : sinks) {
            open.add(new SinkNode(v.id, v.id, 0.0f));
        }
        float[] dists = new float[vertSinks.length];
        Arrays.fill(dists, Float.POSITIVE_INFINITY);
        IdentityHashSet closedVerts = new IdentityHashSet();
        while (!open.isEmpty()) {
            SinkNode obj = (SinkNode)open.remove();
            ConnectedMesh.Vertex v = mesh.verts[obj.vert];
            float dist = obj.dist;
            int vix = obj.vert;
            if (!(dist < dists[vix])) continue;
            vertSinks[vix] = obj.sink;
            dists[vix] = dist;
            closedVerts.clear();
            for (ConnectedMesh.Tri t : v.tris) {
                for (ConnectedMesh.Vertex vAdj : t.verts) {
                    if (vAdj == v || !closedVerts.add(vAdj)) continue;
                    float distAdj = (float)v.p.distance(vAdj.p);
                    open.add(new SinkNode(vAdj.id, vix, dist + distAdj));
                }
            }
        }
    }

    public static ValueFld getMinValues(int fieldId, Collection<? extends ValueFld> fields) {
        if (fields.isEmpty()) {
            return null;
        }
        if (fields.size() == 1) {
            return fields.iterator().next();
        }
        assert (theUtil.isUniform(theUtil.map(fields, field -> field.mesh)));
        assert (theUtil.isUniform(theUtil.map(fields, field -> field.triInfo), (o1, o2) -> o1 == o2));
        ValueFld first = fields.iterator().next();
        float[] minVals = new float[first.mesh.verts.length];
        Arrays.fill(minVals, Float.POSITIVE_INFINITY);
        for (ValueFld valueFld : fields) {
            theUtil.parallelSetAll(minVals, i -> Math.min(minVals[i], (float)fld.vertVals.applyAsDouble(i)));
        }
        float[] range = NodeUtil.getRange(minVals);
        return new ValueFld(fieldId, first.mesh, first.triInfo, minVals, range);
    }

    private static class SinkNode
    implements Comparable<SinkNode> {
        public final int vert;
        public final int sink;
        public final float dist;

        public SinkNode(int vert, int sink, float dist) {
            this.vert = vert;
            this.sink = sink;
            this.dist = dist;
        }

        @Override
        public int compareTo(SinkNode o) {
            return Float.compare(this.dist, o.dist);
        }
    }

    private static class PushNode
    implements Comparable<PushNode> {
        public final int vert;
        public final float val;

        public PushNode(int vert, float val) {
            this.vert = vert;
            this.val = val;
        }

        @Override
        public int compareTo(PushNode o) {
            return Float.compare(this.val, o.val);
        }
    }

    private static class TriInfo {
        public final Point3d[] verts;
        public final int[] tris;
        public final EdgeData[] triEdges;
        public final int[] triAdjacency;

        public TriInfo(Point3d[] verts, int[] tris, EdgeData[] triEdges, int[] triAdjacency) {
            this.verts = verts;
            this.tris = tris;
            this.triEdges = triEdges;
            this.triAdjacency = triAdjacency;
        }
    }

    private static class IxEdgeDirected
    extends IxEdge {
        public IxEdgeDirected(int i1, int i2) {
            super(i1, i2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IxEdgeDirected)) {
                return false;
            }
            IxEdgeDirected ie = (IxEdgeDirected)obj;
            return this.i1 == ie.i1 && this.i2 == ie.i2;
        }
    }

    private static class IxEdge {
        public final int i1;
        public final int i2;

        public IxEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return 0xFA938 ^ this.i1 + this.i2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IxEdge)) {
                return false;
            }
            IxEdge ie = (IxEdge)obj;
            return this.i1 == ie.i1 && this.i2 == ie.i2 || this.i1 == ie.i2 && this.i2 == ie.i1;
        }
    }

    public static class TriangulateResult {
        public final ConnectedMesh mesh;
        public final Map<ANode, List<ConnectedMesh.Vertex>> doorVerts;
        public final EdgeData[] triEdgeData;

        public TriangulateResult(ConnectedMesh mesh, Map<ANode, List<ConnectedMesh.Vertex>> doorVerts, EdgeData[] triEdgeData) {
            this.mesh = mesh;
            this.doorVerts = doorVerts;
            this.triEdgeData = triEdgeData;
        }
    }
}

