/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IWaitUntilSrc;
import inferno.data2.ai.WaitGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Objects;

public class WaitUntilGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private static final long s_delaySeed = 11242279853998L;
    public final WaitMode mode;
    public final IWaitUntilSrc waitSrc;

    public WaitUntilGoal(WaitMode mode, IWaitUntilSrc waitSrc) {
        this.mode = mode;
        this.waitSrc = waitSrc;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilGoal && ((WaitUntilGoal)obj).waitSrc.equals(this.waitSrc) && ((WaitUntilGoal)obj).mode.equals((Object)this.mode);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hash(new Object[]{this.waitSrc, this.mode});
        return hash;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        double simTime = kb.getCurrentSimTime();
        double waitUntilTime = this.waitSrc.getWaitTime(simTime, WaitUntilGoal.genRandomSeed(agent, simTime));
        return new WaitGoalInstance(this, this.mode, waitUntilTime);
    }

    private static long genRandomSeed(OccAgent oa, double currTime) {
        return oa.getOcc().rseed ^ 0xA398C18DFAEL ^ (long)currTime;
    }
}

