/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.Steer;
import inferno.sim.steering.simple.MaintainVel;
import inferno.sim.steering.simple.PostOpSteeringBehavior;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class SetOccPropGoal<T>
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final transient OccProfileSim.IOccProp<T> prop;
    public final T value;

    public SetOccPropGoal(OccProfileSim.IOccProp<T> prop, T value) {
        assert (prop instanceof IPropertySet.Prop);
        this.prop = prop;
        this.value = value;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SetOccPropGoal && ((SetOccPropGoal)obj).prop.equals(this.prop) && Objects.equals(((SetOccPropGoal)obj).value, this.value);
    }

    public int hashCode() {
        return 0x98F3E ^ this.prop.hashCode() + Objects.hashCode(this.value);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(((IPropertySet.Prop)((Object)this.prop)).key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object key = in.readObject();
        IPropertySet.Prop<?> prop = OccProfileSim.PROP_TYPES_MAP.get(key);
        assert (prop != null);
        assert (prop instanceof OccProfileSim.IOccProp);
        try {
            theUtil.assignFinalField(this, SetOccPropGoal.class, "prop", (OccProfileSim.IOccProp)((Object)prop));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public <T2> void getFutureProfileValues(Set<? super BehaviorSim> visitedBehaviors, OccProfileSim.IOccProp<T2> prop, Consumer<? super T2> result) {
        if (this.prop != prop) {
            return;
        }
        result.accept(this.value);
    }

    public static class Instance<T>
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        private SetOccPropGoal<T> setOccPropGoal;

        public Instance(SetOccPropGoal<T> setOccPropGoal) {
            this.setOccPropGoal = setOccPropGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.setOccPropGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            return new PostOpSteeringBehavior(new MaintainVel(), new ChangePropOp(this.setOccPropGoal));
        }
    }

    private static class ChangePropOp
    implements Steer.IPostOp {
        private static final long serialVersionUID = 1L;
        public final SetOccPropGoal<Object> goal;

        public ChangePropOp(SetOccPropGoal<Object> goal) {
            this.goal = goal;
        }

        @Override
        public void accept(KB t, OccAgent u) {
            this.goal.prop.apply(u.getOcc(), new Random(), u.getOcc().getSeed((IPropertySet.Prop)((Object)this.goal.prop)), this.goal.value, t);
            if (this.goal.prop == OccProfileSim.PROP_SHAPE) {
                u.initVehicle(t);
            }
        }
    }
}

