/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.QMetaQueue;
import inferno.data2.TriPoint;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.data2.seekarea.PointSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.Wander;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class QueueGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final QMetaQueue qSrc;
    private final boolean useShortestPlanner = false;

    public QueueGoal(QMetaQueue qSrc) {
        this.qSrc = qSrc;
    }

    public int hashCode() {
        return 1714717917 + Objects.hashCode(this.qSrc);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueGoal qg = (QueueGoal)obj;
        return false == qg.useShortestPlanner && Objects.equals(this.qSrc, qg.qSrc);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, agent, kb);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        private final QueueGoal d_queueGoal;
        private State d_state = State.NO_PATH_CHOSEN;
        private QMetaQueue.ProcessOption d_choice;
        private double d_estEndTime;
        private double d_processTime;
        private TriPoint d_currSpot;
        private transient IProgressNote d_progress;

        public Instance(QueueGoal queueGoal, OccAgent occ, KB kb) {
            this.d_queueGoal = queueGoal;
            this.d_state = State.NO_PATH_CHOSEN;
            this.d_processTime = this.d_queueGoal.qSrc.getProcessTime(kb, occ);
        }

        private void choosePath(KB kb, OccAgent occ) {
            QMetaQueue.ProcessOption successfulOption = this.d_queueGoal.qSrc.processOccupant(kb, occ);
            if (successfulOption == null) {
                this.d_state = State.FAILED;
                this.d_choice = null;
            } else if (successfulOption.chosenQ != null) {
                this.d_choice = successfulOption;
                this.d_estEndTime = kb.getCurrentSimTime() + this.d_choice.waitTime;
                this.d_choice.parentQ.addUnprocessedOccupant(occ, successfulOption);
                if (!successfulOption.temporary) {
                    this.d_state = State.QUEUE_CHOSEN;
                }
            }
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            switch (this.d_state) {
                case FAILED: {
                    return UNKNOWN_IDLE_STATUS;
                }
                case NO_PATH_CHOSEN: {
                    return UNKNOWN_IDLE_STATUS;
                }
                case QUEUE_CHOSEN: {
                    if (this.isIdlingInQueue(kb, agent)) {
                        return new IGoalInstance.IdleInfo(this.d_estEndTime);
                    }
                    return null;
                }
                case REACHED: {
                    return null;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            if (this.d_choice == null || this.d_choice.parentQ == null) {
                return false;
            }
            return this.d_choice.parentQ.canInterruptOccupant(agent);
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            this.d_choice.parentQ.markRemoveOccupant(agent);
            return ISeekGoalInstance.super.interrupt(kb, agent);
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_queueGoal;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUE_CHOSEN: {
                    return this.d_choice.parentQ.shouldOccupantUpdateSteering(occ, this.d_choice.leader);
                }
                case NO_PATH_CHOSEN: {
                    return this.isTimeToChoose(kb);
                }
            }
            return false;
        }

        private boolean isTimeToChoose(KB kb) {
            return theUtil.ge(kb.getCurrentSimTime(), this.d_processTime, 1.0E-6);
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            Supplier<ISteeringBehavior> getIdleSteerInPlace = () -> SteerUtil.newIdleSteer(kb, occ, IdleParams.DEFAULT, () -> new Wander(), () -> new Pair<TriPoint, Object>(occ.getLoc(), null));
            if (this.d_state == State.NO_PATH_CHOSEN && this.isTimeToChoose(kb)) {
                this.choosePath(kb, occ);
            }
            if (this.d_state != State.QUEUE_CHOSEN) {
                return getIdleSteerInPlace.get();
            }
            TriPoint tp = this.d_choice.parentQ.getOccupantTriPoint(occ, this.d_choice.leader);
            if (this.isIdlingInQueue(kb, occ, tp)) {
                return getIdleSteerInPlace.get();
            }
            Objects.requireNonNull(this.d_queueGoal);
            LocallyQuickest pathPlanner = new LocallyQuickest(occ, new LocalTimeEstimate.QueueSizes(), new PointTarget(tp));
            return SteerUtil.newSeekSteer(kb, occ, pathPlanner);
        }

        private boolean isIdlingInQueue(KB kb, OccAgent occ) {
            return this.isIdlingInQueue(kb, occ, this.d_choice.parentQ.getOccupantTriPoint(occ, this.d_choice.leader));
        }

        private boolean isIdlingInQueue(KB kb, OccAgent occ, TriPoint queuePos) {
            return queuePos == null || this.d_choice.parentQ.isOccupantIdling(occ);
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            return this.getSeekArea(kb, occ);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (this.d_state == State.QUEUE_CHOSEN && this.d_choice.parentQ.getOccupantReady(occ, true)) {
                this.d_state = State.REACHED;
            }
            return this.d_state.terminal;
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUE_CHOSEN: {
                    TriPoint storedDest = this.d_choice.parentQ.getLastKnownSteeringDest(occ, this.d_choice.leader);
                    return storedDest != null ? Instance.toArea(storedDest) : IGoalInstance.getCurrentAreaAsPoint(kb, occ);
                }
            }
            return IGoalInstance.getCurrentAreaAsPoint(kb, occ);
        }

        private static ISeekArea toArea(TriPoint pointInLine) {
            return new PointSeekArea(pointInLine, 0.2, 0);
        }

        @Override
        public ISeekArea update(KB kb, OccAgent agent) {
            if (this.d_state == State.QUEUE_CHOSEN) {
                assert (this.d_choice != null);
                TriPoint tp = this.d_choice.parentQ.getOccupantTriPoint(agent, this.d_choice.leader);
                ISeekArea oldArea = null;
                if (this.d_currSpot != null && !this.d_currSpot.tolEquals(tp, 1.0E-6)) {
                    oldArea = Instance.toArea(this.d_currSpot);
                }
                this.d_currSpot = tp;
                return oldArea;
            }
            return null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUE_CHOSEN: {
                    this.d_progress = this.d_choice.parentQ.checkProgress();
                    break;
                }
                case FAILED: {
                    this.d_progress = IProgressNote.NOT_PROGRESSING;
                    break;
                }
                default: {
                    this.d_progress = IProgressNote.PROGRESSING;
                }
            }
            return this.d_progress;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        private static enum State {
            NO_PATH_CHOSEN(false),
            QUEUE_CHOSEN(false),
            FAILED(false),
            REACHED(true);

            public final boolean terminal;

            private State(boolean terminal) {
                this.terminal = terminal;
            }
        }
    }
}

