/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.IdleParams;
import inferno.sim.DoorQueue;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.simple.Arrive;
import java.io.Serializable;

public class JoinOccGroupGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = -6401457870398984940L;
    public final IOccGroup group;

    public JoinOccGroupGoal(IOccGroup occGroup) {
        this.group = occGroup;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        if (this.group instanceof OccGroup) {
            agent.getOcc().occupantGroup = (OccGroup)this.group;
        }
        this.group.joinDynamically(agent);
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        private static final long serialVersionUID = -7355655661850257235L;
        private JoinOccGroupGoal joinOccGroup;
        private ISteeringBehavior waitGoalBehavior;

        public Instance(JoinOccGroupGoal joinOccGroup) {
            this.joinOccGroup = joinOccGroup;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            if (this.waitGoalBehavior == null) {
                this.waitGoalBehavior = kb.getParams().reactive_steering ? IGoalInstance.getCurrentAreaAsRoom(kb, occ).getIdleSteer(kb, occ, IdleParams.DEFAULT) : new Arrive(occ.getLoc(), null);
            }
            return this.waitGoalBehavior;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            OccGroup group = occ.getOcc().occupantGroup;
            if (group == null) {
                return false;
            }
            if (this.joinOccGroup.group instanceof OccGroup) {
                return group == this.joinOccGroup.group;
            }
            if (this.joinOccGroup.group instanceof OccGroupType) {
                return group.type == this.joinOccGroup.group;
            }
            assert (false);
            return true;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return occ.getOcc().occupantGroup != null ? IProgressNote.PROGRESSING : IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IIdleGoal getGoal() {
            return this.joinOccGroup;
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

