/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.TriPoint;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.SeekProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.IPathSeek;
import inferno.sim.steering.PathFollow;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import thunderheadeng.util.Pair;

public class GoalUtil {
    public static boolean overlap(KB kb, OccAgent occ1, ISeekArea occ1Area, OccAgent occ2, ISeekArea occ2Area) {
        TriPoint loc1 = occ1Area.getDestinationLoc(kb, occ1);
        if (loc1 != null && occ2Area.contains(kb, loc1)) {
            return true;
        }
        TriPoint loc2 = occ2Area.getDestinationLoc(kb, occ2);
        if (loc2 != null && occ1Area.contains(kb, loc2)) {
            return true;
        }
        Collection<ANode> rooms1 = occ1Area.getDestinationRooms();
        Collection<ANode> rooms2 = occ2Area.getDestinationRooms();
        return Util.containsAny(rooms1, rooms2);
    }

    public static IdleParams toIdleParams(WaitMode mode) {
        return IdleParams.from(mode);
    }

    public static int setHashCode(Collection<?> coll) {
        if (coll == null) {
            return 0;
        }
        return coll instanceof Set ? ((Set)coll).hashCode() : new CollSet(coll).hashCode();
    }

    public static boolean setsEqual(Collection<?> coll1, Collection<?> coll2) {
        if (coll1 == null) {
            return coll2 == null;
        }
        if (coll2 == null) {
            return false;
        }
        if (coll1 instanceof Set && coll2 instanceof Set) {
            return coll1.equals(coll2);
        }
        return new CollSet(coll1).equals(new CollSet(coll2));
    }

    public static IProgressNote getSeekProgress(KB kb, OccAgent occ, IProgressNote prevProgress) {
        double remainingDist;
        ANode firstDoor = null;
        PathFollow pf = occ.getPathFollow();
        if (pf == null || pf.getPath() == null) {
            return IProgressNote.PROGRESSING;
        }
        int numPts = pf.getPath().getNumPoints(false);
        for (int m = 0; m < numPts; ++m) {
            IPathSeek seek = pf.getPath().pointAt(m);
            Pair<ANode, DoorDir> door = seek.getTargetDoor();
            if (door == null) continue;
            firstDoor = (ANode)door.v1;
            break;
        }
        if (Double.isNaN(remainingDist = occ.getRemainingDistance())) {
            remainingDist = Double.POSITIVE_INFINITY;
        }
        return new SeekProgressNote(kb, occ, firstDoor, remainingDist, prevProgress);
    }

    private static class CollSet<T>
    extends AbstractSet<T> {
        private final Collection<T> d_coll;

        public CollSet(Collection<T> coll) {
            this.d_coll = coll;
        }

        @Override
        public Iterator<T> iterator() {
            return this.d_coll.iterator();
        }

        @Override
        public int size() {
            return this.d_coll.size();
        }
    }
}

