/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.Occupant;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.Steer;
import inferno.sim.steering.simple.MaintainVel;
import inferno.sim.steering.simple.PostOpSteeringBehavior;
import java.io.Serializable;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.stat.IUrn;

public class ChangeProfileGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Predicate<Object> UI_PROP_FILTER = Filters.reject(OccProfileSim.PROP_INIT_ORIENT.key, OccProfileSim.PROP_REMOVE_WHEN_FINISHED.key, OccProfileSim.PROP_REAC_TIME.key);
    private final Predicate<Object> d_propFilter;
    private IUrn<OccProfileSim> d_profiles;

    public ChangeProfileGoal(Predicate<Object> propFilter) {
        this.d_propFilter = propFilter;
    }

    public void init(IUrn<OccProfileSim> profiles) {
        this.d_profiles = profiles;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new ChangeProfileGoalInstance(this);
    }

    public OccProfileSim getSampledProfile(Random rnd) {
        return this.d_profiles.getValue(rnd);
    }

    public IUrn<OccProfileSim> getProfileUrn() {
        return this.d_profiles;
    }

    public Predicate<Object> getPropFilter() {
        return this.d_propFilter;
    }

    public Set<OccProfileSim> getAllTargetProfiles() {
        return Collections.unmodifiableSet(this.d_profiles.getWeights().keySet());
    }

    @Override
    public <T> void getFutureProfileValues(Set<? super BehaviorSim> visitedBehaviors, OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        for (OccProfileSim profile : this.d_profiles.getWeights().keySet()) {
            if (profile.getProperty(OccProfileSim.PROP_NO_CHANGE).booleanValue()) continue;
            T value = profile.getProp(prop);
            result.accept(value);
        }
    }

    @Override
    public void getReferencedProfiles(Set<? super BehaviorSim> visitedBehaviors, Consumer<? super OccProfileSim> allUsedProfiles) {
        this.d_profiles.getWeights().keySet().forEach(allUsedProfiles);
    }

    public static class ChangeProfileGoalInstance
    implements IImmediateGoalInstance {
        static final long serialVersionUID = 1L;
        private ChangeProfileGoal d_goal;

        public ChangeProfileGoalInstance(ChangeProfileGoal goal) {
            this.d_goal = goal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            Occupant occ = agent.getOcc();
            Random rnd = kb.getTimeBasedRandom(occ, 734314857091L);
            OccProfileSim newProfile = this.d_goal.getSampledProfile(rnd);
            if (!newProfile.getProperty(OccProfileSim.PROP_NO_CHANGE).booleanValue() && newProfile != occ.parentProfile) {
                return new PostOpSteeringBehavior(new MaintainVel(), new ChangeProfileOp(newProfile, this.d_goal.d_propFilter));
            }
            return IImmediateGoalInstance.super.generateSteeringBehavior(kb, agent);
        }
    }

    private static class ChangeProfileOp
    implements Steer.IPostOp {
        private static final long serialVersionUID = 1L;
        public final OccProfileSim target;
        public final Predicate<Object> propFilter;

        public ChangeProfileOp(OccProfileSim target, Predicate<Object> propFilter) {
            this.target = target;
            this.propFilter = propFilter;
        }

        @Override
        public void accept(KB kb, OccAgent agent) {
            this.target.applyToOcc(agent.getOcc(), new Random(), agent.getOcc().rseed, prop -> {
                Object key = prop;
                if (prop instanceof IPropertySet.Prop) {
                    key = ((IPropertySet.Prop)((Object)prop)).key;
                }
                return this.propFilter.test(key);
            }, kb);
            agent.getOcc().parentProfile = this.target;
            agent.initVehicle(kb);
            agent.markModified(kb.getCurrentSimTime());
        }
    }
}

