/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import java.io.Serializable;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import thunderheadeng.util.stat.IUrn;

public class ChangeBehaviorGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    private IUrn<BehaviorSim> d_behaviors;

    public void init(IUrn<BehaviorSim> behaviors) {
        this.d_behaviors = behaviors;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public BehaviorSim getSampledBehavior(Random rnd) {
        return this.d_behaviors.getValue(rnd);
    }

    public IUrn<BehaviorSim> getBehaviorUrn() {
        return this.d_behaviors;
    }

    public Set<BehaviorSim> getAllTargetBehaviors() {
        return Collections.unmodifiableSet(this.d_behaviors.getWeights().keySet());
    }

    @Override
    public <T> void getFutureProfileValues(Set<? super BehaviorSim> visitedBehaviors, OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        for (BehaviorSim behavior : this.getAllTargetBehaviors()) {
            if (behavior == null) continue;
            behavior.getFutureProfileValues(visitedBehaviors, prop, result);
        }
    }

    @Override
    public void getReferencedProfiles(Set<? super BehaviorSim> visitedBehaviors, Consumer<? super OccProfileSim> allUsedProfiles) {
        for (BehaviorSim behavior : this.getAllTargetBehaviors()) {
            if (behavior == null) continue;
            behavior.getReferencedProfiles(visitedBehaviors, allUsedProfiles);
        }
    }

    public static class Instance
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        private ChangeBehaviorGoal d_goal;

        public Instance(ChangeBehaviorGoal goal) {
            this.d_goal = goal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            Random rnd = kb.getTimeBasedRandom(agent.getOcc(), 12058180617034L);
            BehaviorSim newBehavior = this.d_goal.d_behaviors.getValue(rnd);
            if (newBehavior != null) {
                agent.getOcc().behaviorStack.push(new BehaviorSim.BehaviorInProgress(newBehavior, -1));
            }
            return null;
        }
    }
}

