/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.AttachToAgentGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.PassiveModeGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.occsource.OccSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class AssistedEvacTeam
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String teamName;
    public final int teamId;
    public final Map<Integer, Integer> clientOrder;
    public final Map<OccAgent, AssistInfo> clients = new LinkedIdentityHashMap<OccAgent, AssistInfo>();
    private final List<AssistInfo> d_clientsToAdd = new ArrayList<AssistInfo>();
    private final List<OccAgent> d_clientsToRemove = new ArrayList<OccAgent>();
    public final Set<OccAgent> assistants = new LinkedIdentityHashSet<OccAgent>();
    private final List<OccAgent> d_assistantsToAdd = new ArrayList<OccAgent>();
    private final List<OccAgent> d_assistantsToRemove = new ArrayList<OccAgent>();
    private boolean d_finished = false;
    private transient Map<Pair<BehaviorSim, Integer>, Boolean> d_mightBecomeClientCache = null;

    public AssistedEvacTeam(String teamName, List<Integer> assistOrder, int teamId) {
        this.teamName = teamName;
        this.teamId = teamId;
        this.clientOrder = new HashMap<Integer, Integer>();
        this.setAssistOrder(assistOrder);
    }

    public void setAssistOrder(List<Integer> assistOrder) {
        this.clientOrder.clear();
        for (int m = 0; m < assistOrder.size(); ++m) {
            this.clientOrder.put(assistOrder.get(m), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(AssistInfo assist) {
        List<AssistInfo> list = this.d_clientsToAdd;
        synchronized (list) {
            this.d_clientsToAdd.add(assist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(OccAgent agent) {
        List<OccAgent> list = this.d_clientsToRemove;
        synchronized (list) {
            this.d_clientsToRemove.add(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssistant(OccAgent agent) {
        List<OccAgent> list = this.d_assistantsToAdd;
        synchronized (list) {
            this.d_assistantsToAdd.add(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssistant(OccAgent agent) {
        List<OccAgent> list = this.d_assistantsToRemove;
        synchronized (list) {
            this.d_assistantsToRemove.add(agent);
        }
    }

    public boolean isFinished() {
        return this.d_finished;
    }

    public void update(KB kb) {
        Comparator agentSorter = (a1, a2) -> Integer.compare(a1.getId(), a2.getId());
        ArrayList<OccAgent> removedClients = new ArrayList<OccAgent>(this.d_clientsToRemove.size());
        Collections.sort(this.d_clientsToRemove, agentSorter);
        for (OccAgent remove : this.d_clientsToRemove) {
            if (this.clients.remove(remove) == null) continue;
            removedClients.add(remove);
        }
        BiConsumer<Collection, Collection> removeFinished = (coll1, coll2) -> {
            Iterator it = coll1.iterator();
            while (it.hasNext()) {
                OccAgent agent = (OccAgent)it.next();
                if (!agent.isDone() && !agent.getAssistedEvacClientModule().map(AssistedEvacClientAgent::willEnd).orElse(false).booleanValue()) continue;
                it.remove();
                coll2.add(agent);
            }
        };
        removeFinished.accept(this.clients.keySet(), removedClients);
        ArrayList<AssistInfo> addedClients = new ArrayList<AssistInfo>(this.d_clientsToAdd.size());
        Collections.sort(this.d_clientsToAdd, (a1, a2) -> Integer.compare(a1.agent.getId(), a2.agent.getId()));
        for (AssistInfo assistInfo : this.d_clientsToAdd) {
            AssistInfo assistInfo2 = this.clients.put(assistInfo.agent, assistInfo);
            assert (assistInfo2 == null) : "Clients must be removed before being re-added to a team";
            if (assistInfo2 != null) continue;
            addedClients.add(assistInfo);
        }
        Collections.sort(this.d_assistantsToRemove, agentSorter);
        this.assistants.removeAll(this.d_assistantsToRemove);
        this.assistants.removeIf(a -> a.isDone());
        Collections.sort(this.d_assistantsToAdd, agentSorter);
        LinkedIdentityHashSet addedAssistants = new LinkedIdentityHashSet(this.d_assistantsToAdd.size());
        for (OccAgent occAgent : this.d_assistantsToAdd) {
            if (!this.assistants.add(occAgent)) continue;
            addedAssistants.add(occAgent);
        }
        IFilteredCollection<OccAgent> iFilteredCollection = theUtil.filter(this.assistants, Filters.reject(addedAssistants));
        if (!removedClients.isEmpty()) {
            for (OccAgent assistant : iFilteredCollection) {
                IGoalInstance ginst = assistant.getCurrentGoalInstance(kb);
                if (!(ginst instanceof AssistOccupantsGoal.Instance)) continue;
                ((AssistOccupantsGoal.Instance)ginst).removeGoals(removedClients);
            }
        }
        for (AssistInfo ai : addedClients) {
            ai.agent.initAssistedEvacClientModule(kb);
        }
        BiConsumer<Collection, Collection> biConsumer = (assistants, clients) -> {
            for (OccAgent assistant : assistants) {
                IGoalInstance ginst = assistant.getCurrentGoalInstance(kb);
                if (!(ginst instanceof AssistOccupantsGoal.Instance)) continue;
                ((AssistOccupantsGoal.Instance)ginst).addGoals((Collection<AssistInfo>)clients);
            }
        };
        biConsumer.accept(addedAssistants, this.clients.values());
        biConsumer.accept(iFilteredCollection, addedClients);
        this.d_clientsToRemove.clear();
        this.d_clientsToAdd.clear();
        this.d_assistantsToRemove.clear();
        this.d_assistantsToAdd.clear();
        this.d_finished = this.calcIsFinish(kb);
    }

    private boolean calcIsFinish(KB kb) {
        if (this.clients.keySet().stream().anyMatch(a -> a.getAssistedEvacClientModule().isPresent() && !a.getAssistedEvacClientModule().get().isFullyOccupied())) {
            return false;
        }
        if (this.d_mightBecomeClientCache == null) {
            this.d_mightBecomeClientCache = new HashMap<Pair<BehaviorSim, Integer>, Boolean>();
        }
        Predicate<WaitForAssistanceGoal> filter = g -> g.teams.contains(this);
        for (OccSource source : kb.getActiveOccSources()) {
            if (source.getFinishTime() < kb.getCurrentSimTime()) continue;
            for (BehaviorSim behavior : source.getBehaviors()) {
                boolean mightBecomeClient = this.d_mightBecomeClientCache.computeIfAbsent(new Pair<BehaviorSim, Integer>(behavior, 0), p -> !((BehaviorSim)p.v1).deepFlatten(WaitForAssistanceGoal.class, (BehaviorSim)p.v1, (Integer)p.v2, filter, true).isEmpty());
                if (!mightBecomeClient) continue;
                return false;
            }
        }
        for (OccAgent agent : kb.getActiveAgents()) {
            BehaviorSim.BehaviorInProgress behaviorInProgress = agent.getOcc().behaviorStack.peek();
            boolean mightBecomeClient = this.d_mightBecomeClientCache.computeIfAbsent(new Pair<BehaviorSim, Integer>(behaviorInProgress.behavior, behaviorInProgress.goalIndex), p -> !agent.getOcc().behavior.deepFlatten(WaitForAssistanceGoal.class, (BehaviorSim)p.v1, (Integer)p.v2, filter, true).isEmpty());
            if (!mightBecomeClient) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("AssistedEvacTeam: %s", this.teamName);
    }

    public static class AssistInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final OccAgent agent;
        public final AttachToAgentGoal attach;
        public final PassiveModeGoal passive;

        public AssistInfo(OccAgent agent, AttachToAgentGoal attach, PassiveModeGoal passive) {
            this.agent = agent;
            this.attach = attach;
            this.passive = passive;
        }
    }

    public static enum AssistedEvacuationRoleType {
        ASSISTING,
        NEEDS_ASSISTANCE,
        NONE;

    }
}

