/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ABoundedHistory;
import java.util.Objects;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class VelocityHistory
extends ABoundedHistory<Vector3f> {
    static final long serialVersionUID = 1L;

    public VelocityHistory(double maxTimeHint, double maxFreq) {
        super(maxTimeHint, maxFreq);
    }

    public VelocityHistory(int size, double maxFreq) {
        super(size, maxFreq);
    }

    @Override
    public void record(double t, Vector3d vel) {
        super.record(t, new Vector3f((float)vel.x, (float)vel.y, (float)vel.z));
    }

    public Vector3d getAverage(double tCurr, double tLen) {
        if (this.isEmpty()) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        double tBegin = tCurr - tLen;
        int beginEntryIx = this.findEntry(tBegin, true);
        if (beginEntryIx == -1) {
            beginEntryIx = 0;
        }
        int endEntryIx = this.getCount();
        tBegin = Math.max(tBegin, this.getEntry((int)beginEntryIx).t);
        tLen = tCurr - tBegin;
        Vector3d result = new Vector3d(0.0, 0.0, 0.0);
        for (int m = beginEntryIx; m < endEntryIx; ++m) {
            double t2;
            ABoundedHistory.Entry entry1 = this.getEntry(m);
            double t1 = Math.max(entry1.t, tBegin);
            if (m < endEntryIx - 1) {
                ABoundedHistory.Entry entry2 = this.getEntry(m + 1);
                t2 = entry2.t;
            } else {
                t2 = tCurr;
            }
            assert (t2 >= t1);
            double frac = t2 - t1;
            result.x += (double)((Vector3f)entry1.val).x * frac;
            result.y += (double)((Vector3f)entry1.val).y * frac;
            result.z += (double)((Vector3f)entry1.val).z * frac;
        }
        result.scale(1.0 / tLen);
        return result;
    }

    @Override
    protected Vector3f combine(Vector3f v1, Vector3f v2) {
        return v2;
    }

    @Override
    protected boolean canAddEntry(ABoundedHistory.Entry<Vector3f> currEntry, double t, Vector3f newVal) {
        return !Objects.equals(currEntry.val, newVal);
    }
}

