/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ABoundedHistory;
import thunderheadeng.util.theUtil;

public class DoubleHistory
extends ABoundedHistory<Double> {
    static final long serialVersionUID = 1L;

    public DoubleHistory(double maxTimeHint, double maxFreq) {
        super(maxTimeHint, maxFreq);
    }

    public DoubleHistory(int size, double maxFreq) {
        super(size, maxFreq);
    }

    @Override
    protected boolean canAddEntry(ABoundedHistory.Entry<Double> currEntry, double t, Double newVal) {
        return !theUtil.eq((Double)currEntry.val, newVal, 0.001);
    }

    @Override
    protected Double combine(Double v1, Double v2) {
        return v2;
    }

    public double getAverage(double tCurr, double tLen) {
        if (this.isEmpty()) {
            return 0.0;
        }
        double tBegin = tCurr - tLen;
        int beginEntryIx = this.findEntry(tBegin, true);
        if (beginEntryIx == -1) {
            beginEntryIx = 0;
        }
        int endEntryIx = this.getCount();
        tBegin = Math.max(tBegin, this.getEntry((int)beginEntryIx).t);
        tLen = tCurr - tBegin;
        double totVal = 0.0;
        for (int m = beginEntryIx; m < endEntryIx; ++m) {
            double t2;
            ABoundedHistory.Entry entry1 = this.getEntry(m);
            double t1 = Math.max(entry1.t, tBegin);
            if (m < endEntryIx - 1) {
                ABoundedHistory.Entry entry2 = this.getEntry(m + 1);
                t2 = entry2.t;
            } else {
                t2 = tCurr;
            }
            assert (t2 >= t1);
            double dt = t2 - t1;
            totVal += (Double)entry1.val * dt;
        }
        return totVal / tLen;
    }
}

