/*
 * Decompiled with CFR 0.152.
 */
package common.io.pfr;

import common.io.FileUtil;
import common.io.pfr.PFRFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.util.TypedProp;

public class PFRWriter {
    public static void createResultsFiles(String dirName, String inputFileName, String saveFileName, String occAnimFileName, String geomAnimFileName, String geomFileName, String viewsFileName) throws IOException {
        File inputFile = FileUtil.getInputFn(new File(dirName), inputFileName);
        File saveFile = new File(saveFileName);
        File occAnimFile = new File(occAnimFileName);
        File geomAnimFile = new File(geomAnimFileName);
        File meshFile = inputFile;
        File geomFile = new File(geomFileName);
        File viewsFile = new File(viewsFileName);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        PFRWriter.set(props, PFRFile.VERSION, PFRFile.Version.curr().ordinal());
        PFRWriter.set(props, PFRFile.OCC_ANIM_PROP, PFRWriter.getPath(saveFile, occAnimFile));
        PFRWriter.set(props, PFRFile.GEOM_ANIM_PROP, PFRWriter.getPath(saveFile, geomAnimFile));
        PFRWriter.set(props, PFRFile.MESH_PROP, PFRWriter.getPath(saveFile, meshFile));
        if (geomFile.exists()) {
            PFRWriter.set(props, PFRFile.IMPORT_GEOM_PROP, PFRWriter.getPath(saveFile, geomFile));
        }
        if (viewsFile.exists()) {
            PFRWriter.set(props, PFRFile.VIEWS_PROP, PFRWriter.getPath(saveFile, viewsFile));
        }
        try (PrintWriter writer = IOUtil.newPrintWriterUTF8(saveFile);){
            for (Map.Entry entry : props.entrySet()) {
                if (entry.getValue() == null) continue;
                Object val = (String)entry.getValue();
                if (!((String)val).isEmpty() && PFRWriter.isws(((String)val).charAt(0))) {
                    val = "\\" + (String)val;
                }
                writer.printf("%s=%s\n", entry.getKey(), val);
            }
        }
    }

    private static boolean isws(char c) {
        switch (c) {
            case '\t': 
            case '\f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static <T> void set(Map<String, String> props, TypedProp<T> prop, T value) {
        if (value != null) {
            props.put(prop.key.toString(), value.toString());
        }
    }

    private static String getPath(File saveFile, File file) {
        if (file == null) {
            return null;
        }
        return FilenameManager.getRelativeFilename(saveFile, file, true);
    }
}

