/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.vecmath.Vector3d;
import results.Intl;
import results.api.Events;
import results.nativebuffered.mv.MVAction;
import results.nativebuffered.mv.ResultsSceneView;
import results.nativebuffered.session.Session;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.theUtil;

public class MVCameras
implements IEventObserver,
IBindable {
    private final SessionMediator d_mediator;
    private final BooleanSupplier d_resetToFront;
    private final ResultsSceneView d_sceneView;
    private final List<BooleanAction> d_cameraActions;
    public final MVAction resetCameraAll;
    public final MVAction resetCameraSelected;
    public final MVAction fitCamera;

    public MVCameras(SessionMediator mediator, BooleanSupplier resetToFront, ResultsSceneView sceneView) {
        this.d_mediator = mediator;
        this.d_resetToFront = resetToFront;
        this.d_sceneView = sceneView;
        Session session = mediator.getSession();
        this.d_cameraActions = new ArrayList<BooleanAction>();
        for (Session.PredefCamera pcam : Session.PredefCamera.values()) {
            BooleanAction action = new BooleanAction(pcam.name, false, guiUtil.loadIcon(pcam.iconLoc), state -> {
                if (!state.booleanValue()) {
                    return;
                }
                mediator.getSession().set(Session.CAMERA, mediator.getSession().getPredefCamera(pcam));
            });
            this.d_cameraActions.add(action);
        }
        this.resetCameraAll = new MVAction(Intl.intl("Reset View to All Objects,R,Reset All,Reset view to all visible objects"), (Icon)guiUtil.loadTeciIcon("ZoomFit16.gif"), e -> this.resetCamera(ResultsSceneView.ObjectSet.ALL));
        this.resetCameraSelected = new MVAction(Intl.intl("Reset View to Selected Objects,E,Reset To Selection,Reset view to selected, visible objects"), (Icon)guiUtil.loadTeciIcon("ZoomSelectedObjs16.gif"), e -> this.resetCamera(ResultsSceneView.ObjectSet.SELECTED));
        this.fitCamera = new MVAction(Intl.intl("&Fill View,-,Fill view without resetting view angle"), (Icon)guiUtil.loadTeciIcon("fillview16.gif"), e -> {
            Camera c = session.get(Session.CAMERA);
            Set<Camera> cameras = Collections.singleton(c);
            Vector3d view = new Vector3d(c.getViewVector());
            Util3D.safeNormalize(view, 1.0E-6);
            sceneView.resetCamera(this.d_sceneView.getBounds(ResultsSceneView.ObjectSet.ALL), view, c.getUpVector(), cameras);
        });
        this.sync();
    }

    @Override
    public void connect() {
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public void disconnect() {
        this.d_mediator.getEvents().removeObserver(this);
    }

    private void sync() {
        this.syncActiveCamera();
    }

    private void syncActiveCamera() {
        Camera newCam = this.d_mediator.getSession().get(Session.CAMERA);
        Optional<Session.PredefCamera> pcam = Stream.of(Session.PredefCamera.values()).filter(pc -> newCam == this.d_mediator.getSession().getPredefCamera((Session.PredefCamera)((Object)pc))).findAny();
        assert (pcam.isPresent());
        pcam.ifPresent(pc -> {
            BooleanAction action = this.d_cameraActions.get(pc.ordinal());
            IListenerStripper listener = guiUtil.stripListeners(action::addPropertyChangeListener, action::getPropertyChangeListeners, action::removePropertyChangeListener);
            action.setSelected(true);
            listener.restore();
        });
    }

    private Vector3d[] getResetDirs(Camera camera, boolean resetToFront) {
        if (camera instanceof PerspectiveCamera) {
            if (resetToFront) {
                return new Vector3d[]{GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
            }
            return new Vector3d[]{GeomConstants.VEC3D_ZNEG, GeomConstants.VEC3D_YPOS};
        }
        Vector3d view = Util3D.normalize(new Vector3d(camera.getViewVector()));
        Vector3d up = camera.getUpVector();
        return new Vector3d[]{view, up};
    }

    public void resetCameras(Stream<Session.PredefCamera> cameras, ResultsSceneView.ObjectSet objs) {
        List<Camera> cams = cameras.map(p -> this.d_mediator.getSession().getPredefCamera((Session.PredefCamera)((Object)p))).collect(Collectors.toList());
        this.resetCameras(cams, objs);
    }

    public void resetCamera(ResultsSceneView.ObjectSet objs) {
        this.resetCameras(Collections.singleton(this.d_mediator.getSession().get(Session.CAMERA)), objs);
    }

    public void resetCameras(Collection<Camera> cameras, ResultsSceneView.ObjectSet objs) {
        AABox bounds = this.d_sceneView.getBounds(objs);
        for (Camera camera : cameras) {
            Vector3d[] resetDirs = this.getResetDirs(camera, this.d_resetToFront.getAsBoolean());
            AABox cbounds = camera.ensureValidForReset(bounds, 5.0);
            this.d_sceneView.resetCamera(cbounds, resetDirs[0], resetDirs[1], Collections.singleton(camera));
        }
    }

    public guiToolBar createCameraSelectionToolbar() {
        guiToolBar tb = new guiToolBar();
        guiUtil.addMEToolbarItems(tb, theUtil.toArray(this.d_cameraActions, BooleanAction.class));
        return tb;
    }

    public guiToolBar createCameraResetToolBar() {
        guiToolBar tb = new guiToolBar();
        tb.add(this.resetCameraAll);
        tb.add(this.resetCameraSelected);
        tb.add(this.fitCamera);
        return tb;
    }

    @Override
    public void update(thunderheadeng.util.Events events) {
        Session session;
        IEventRecord<Session> sevts = events.getEvents(Session.class, new Class[0]);
        if (sevts.isChanged(session = this.d_mediator.getSession(), (Object)Events.PATHFINDER_RESULTS_ATTACHED) || sevts.isChanged(session, (Object)Events.PATHFINDER_RESULTS_DETACHED)) {
            this.sync();
        } else if (sevts.isChanged(session, Session.CAMERA)) {
            this.syncActiveCamera();
        }
    }
}

