/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import results.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TypedProp;

public class ScreenshotDlg
extends guiDialog {
    private static final long serialVersionUID = 2096817224532083511L;
    private final ScreenshotPnl d_pnl;

    public ScreenshotDlg(Window parent, String title, Supplier<Dimension> windowSize) {
        super(parent, title, 9);
        this.d_pnl = new ScreenshotPnl(windowSize);
        this.getDialogPane().setLayout(new BorderLayout());
        this.getDialogPane().add((Component)this.d_pnl, "Center");
    }

    public void load(IPropertySet props) {
        this.d_pnl.load(props);
    }

    public void save(IPropertySet props) {
        this.d_pnl.save(props);
    }

    public static class ScreenshotPnl
    extends guiPanel {
        private static final long serialVersionUID = 5722107417432008536L;
        public static final TypedProp<Dimension> SIZE = new TypedProp<Dimension>((Object)1017850, Quality.HD_1080.size);
        public static final TypedProp<Boolean> LOD = new TypedProp<Boolean>((Object)4401551, false);
        public static final TypedProp<Boolean> VIEW_WHEN_FINISHED = new TypedProp<Boolean>((Object)10060794, true);
        private final guiComboBox<Quality> d_qualityCombo = new guiComboBox<Quality>(Quality.values());
        private final ValueField<Integer> d_widthFld;
        private final ValueField<Integer> d_heightFld;
        private final guiCheckBox d_lodCB;
        private final guiCheckBox d_watchCB;

        public ScreenshotPnl(Supplier<Dimension> windowSize) {
            this.d_qualityCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -498276895895443835L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(((Quality)((Object)value)).description);
                    return this;
                }
            });
            this.d_widthFld = ScreenshotPnl.format(ValueFields.intFld(IntVR.above(0, false)));
            this.d_heightFld = ScreenshotPnl.format(ValueFields.intFld(IntVR.above(0, false)));
            JButton useWindowSizeBtn = new JButton(Intl.intl("Use window size"));
            useWindowSizeBtn.addActionListener(e -> {
                Dimension d = (Dimension)windowSize.get();
                this.d_widthFld.setValue(d.width);
                this.d_heightFld.setValue(d.height);
            });
            this.d_qualityCombo.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.syncQuality();
            });
            this.d_lodCB = new guiCheckBox(Intl.intl("Enabled Level of Detail"));
            this.d_watchCB = new guiCheckBox(Intl.intl("View screenshot when finished"));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quality:"), this.d_qualityCombo, 0);
            gb.beginGroup("quality");
            gb.addRow(Intl.intl("Video Size:"), this.d_widthFld, "x", this.d_heightFld, Intl.intl("pixels"), useWindowSizeBtn);
            gb.endGroup();
            gb.addRow(this.d_lodCB, 0);
            gb.addRow(this.d_watchCB, 0);
            gb.finalizeRows();
            this.sync();
        }

        private static <T> ValueField<T> format(ValueField<T> field) {
            field.setColumns(6);
            return field;
        }

        private void sync() {
            this.syncQuality();
        }

        private void syncQuality() {
            Quality res = this.d_qualityCombo.getSelectedItem();
            boolean custom = res == Quality.CUSTOM;
            this.setGroupVisible("quality", custom);
            if (!custom) {
                this.d_widthFld.setValue(res.size.width);
                this.d_heightFld.setValue(res.size.height);
            }
            this.repack();
        }

        private void repack() {
            Window parent = SwingUtilities.getWindowAncestor(this);
            if (parent != null) {
                parent.pack();
            }
        }

        public void load(IPropertySet props) {
            Dimension size = props.get(SIZE);
            this.d_widthFld.setValue(size.width);
            this.d_heightFld.setValue(size.height);
            this.d_lodCB.setSelected(props.get(LOD));
            this.d_watchCB.setSelected(props.get(VIEW_WHEN_FINISHED));
            Quality preQual = Quality.get(size.width, size.height);
            this.d_qualityCombo.setSelectedItem((Object)preQual);
            this.sync();
        }

        public void save(IPropertySet props) {
            props.setIfNotDefault(SIZE, new Dimension((Integer)this.d_widthFld.getValue(), (Integer)this.d_heightFld.getValue()));
            props.setIfNotDefault(LOD, this.d_lodCB.isSelected());
            props.setIfNotDefault(VIEW_WHEN_FINISHED, this.d_watchCB.isSelected());
        }

        private static enum Quality {
            UHD_4k(Intl.intl("4k UHD"), 3840, 2160),
            HD_1080(Intl.intl("HD 1080"), 1920, 1080),
            HD_720(Intl.intl("HD 720"), 1280, 720),
            SD_480(Intl.intl("SD 480"), 640, 480),
            CUSTOM(Intl.intl("Custom"));

            public final String description;
            public final Dimension size;

            private Quality(String desc, int w, int h) {
                this.description = String.format("%s (%dx%d)", desc, w, h);
                this.size = new Dimension(w, h);
            }

            private Quality(String label) {
                this.description = label;
                this.size = null;
            }

            public static Quality get(int width, int height) {
                for (Quality q : Quality.values()) {
                    if (q.size.width != width || q.size.height != height) continue;
                    return q;
                }
                return CUSTOM;
            }
        }
    }
}

