/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import montecarlo.CreateCases;
import thunderheadeng.util.theUtil;

public class ProcessResults {
    private static final OutputRowFormat DATA_CSV = (id, min, max, avg, stddev) -> String.format("%s;%.2f;%.2f;%.2f;%.2f;%.2f;%.2f%n", id, min, max, avg - stddev, avg + stddev, avg, stddev);
    private static final OutputRowFormat DATA_HTML = (id, min, max, avg, stddev) -> String.format("%n\t\t\t\t\t['%s', %.2f, %.2f, %.2f, %.2f],", id, max, avg - stddev, avg + stddev, min);

    public static void main(String[] args) throws Exception {
        try {
            File root = new File(args[0]);
            File[] files = root.listFiles((dir, name) -> name.endsWith(".pth"));
            ArrayList<Path> outputFiles = new ArrayList<Path>();
            if (files == null) {
                throw new NullPointerException("No .pth files exist in root directory.");
            }
            for (File file : files) {
                outputFiles.add(Paths.get(file.getAbsolutePath(), new String[0]));
            }
            outputFiles.sort((p1, p2) -> {
                int id2;
                String[] path1 = p1.toString().split("_");
                String[] path2 = p2.toString().split("_");
                int id1 = Integer.parseInt(path1[path1.length - 1].split("\\.")[0]);
                if (id1 > (id2 = Integer.parseInt(path2[path2.length - 1].split("\\.")[0]))) {
                    return 1;
                }
                if (id1 < id2) {
                    return -1;
                }
                return 0;
            });
            ProcessResults.processNonItemizedDataCSV(outputFiles, Arrays.asList("Completion Times for All Occupants (s)", "Travel Distances for All Occupants (m)"));
            ProcessResults.processNonItemizedDataHTML(outputFiles, Arrays.asList("Completion Times for All Occupants (s)", "Travel Distances for All Occupants (m)"), Arrays.asList("Time (s)", "Distance (m)"));
            ProcessResults.processItemizedData(outputFiles, Arrays.asList("Completion Times by Behavior (s)", "Completion Times by Profile (s)", "Movement Distance by Behavior (m)", "Movement Distance by Profile (m)"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static double getAverageOfAverages(List<Double> averages) {
        int length = averages.size();
        return averages.stream().mapToDouble(d -> d).sum() / (double)length;
    }

    private static double getAverageStdDev(List<Double> stddevs) {
        int length = stddevs.size();
        return Math.sqrt(stddevs.stream().mapToDouble(d -> d * d).sum() / (double)length);
    }

    public static OutputData processOutputData(OutputRowFormat format, String header, List<Path> outputFiles) throws Exception {
        StringBuilder data = new StringBuilder();
        File outputFolder = null;
        double all_min = Double.MAX_VALUE;
        double all_max = 0.0;
        ArrayList<Double> averages = new ArrayList<Double>();
        ArrayList<Double> stddevs = new ArrayList<Double>();
        for (Path fp : outputFiles) {
            if (outputFolder == null) {
                outputFolder = fp.getParent().toFile();
            }
            try {
                NonItemizedResult nir = ProcessResults.parseNonItemizedData(fp, header);
                String[] splitPath = fp.toString().split("\\\\");
                String id = splitPath[splitPath.length - 1];
                all_min = Math.min(all_min, nir.min);
                all_max = Math.max(all_max, nir.max);
                averages.add(nir.avg);
                stddevs.add(nir.stddev);
                String dataRow = format.format(id, nir.min, nir.max, nir.avg, nir.stddev);
                data.append(dataRow);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        data.append(format.format("ALL", all_min, all_max, ProcessResults.getAverageOfAverages(averages), ProcessResults.getAverageStdDev(stddevs)));
        return new OutputData(outputFolder, data);
    }

    public static void processNonItemizedDataCSV(List<Path> outputFiles, List<String> headers) throws Exception {
        for (String header : headers) {
            OutputData output = ProcessResults.processOutputData(DATA_CSV, header, outputFiles);
            String template = ProcessResults.loadTemplate("non-itemized-result.csv.template");
            template = template.replace("{DATA}", output.data.toString());
            String fn = new File(output.folder, header + ".csv").getPath();
            Files.write(Paths.get(fn, new String[0]), template.getBytes(), new OpenOption[0]);
        }
    }

    public static void processNonItemizedDataHTML(List<Path> outputFiles, List<String> headers, List<String> v_axis_labels) throws Exception {
        for (int i = 0; i < headers.size(); ++i) {
            OutputData output = ProcessResults.processOutputData(DATA_HTML, headers.get(i), outputFiles);
            String template = ProcessResults.loadTemplate("non-itemized-result.html.template");
            template = template.replace("{DATA}", output.data.toString());
            template = template.replace("{TITLE}", headers.get(i));
            template = template.replace("{H_AXIS_TITLE}", "Case");
            template = template.replace("{V_AXIS_TITLE}", v_axis_labels.get(i));
            String fn = new File(output.folder, headers.get(i) + ".html").getPath();
            Files.write(Paths.get(fn, new String[0]), template.getBytes(), new OpenOption[0]);
        }
    }

    private static String loadTemplate(String fn) throws Exception {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream(fn);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        return data.toString();
    }

    private static NonItemizedResult parseNonItemizedData(Path fn, String header) throws Exception {
        String summaryFn = fn.toString().replace(".pth", "_summary.txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(summaryFn));){
            while (!reader.readLine().startsWith(header)) {
            }
            NonItemizedResult nonItemizedResult = new NonItemizedResult(fn.getFileName().toString(), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]));
            return nonItemizedResult;
        }
    }

    public static void processItemizedData(List<Path> outputFiles, List<String> headers) {
    }

    public static class NonItemizedResult {
        public final double min;
        public final double max;
        public final double avg;
        public final double stddev;
        public final String fn;

        public NonItemizedResult(String fn, double min, double max, double avg, double stddev) {
            this.fn = fn;
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.stddev = stddev;
        }
    }

    public static class OutputData {
        public final File folder;
        public final StringBuilder data;

        public OutputData(File folder, StringBuilder data) {
            this.folder = folder;
            this.data = data;
        }
    }

    private static interface OutputRowFormat {
        public String format(String var1, double var2, double var4, double var6, double var8);
    }
}

