/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools.queues;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import merlin.MerlinApp;
import merlin.builders.queues.QueuePathBuilder;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.tools.RoomSnapConstraint;
import merlin.mv.tools.queues.QueueElementTool;
import results.nativebuffered.Geometry;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitPoint3D;

public class QueuePathTool
extends QueueElementTool<QueuePathBuilder> {
    public QueuePathTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    private void updateLocation() {
        IsectInfo snap = this.getP1().getFinalSnap();
        if (snap != null && snap.obj instanceof IEgressOccupiable && snap.getFaceNormal != null) {
            ((QueuePathBuilder)this.props()).setTempLocation(new UnitPoint3D(snap.isectPoint, Geometry.LU), (IEgressOccupiable)snap.obj, snap.getFaceNormal.get());
        } else {
            ((QueuePathBuilder)this.props()).setTempLocation(new UnitPoint3D(this.getP1().referenceSnap, Geometry.LU), null, GeomConstants.VEC3D_ZPOS);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            ((QueuePathBuilder)this.props()).commit(e.getComponent());
            this.finish();
        }
    }

    private static class Func
    extends AToolFunction<QueuePathTool> {
        private Func() {
        }

        @Override
        public Cursor getCursor(QueuePathTool tool) {
            return null;
        }

        @Override
        public ISnapConstraint getSnapConstraint(QueuePathTool tool) {
            return new RoomSnapConstraint(MerlinApp.getAppData(), null);
        }

        @Override
        public void mousePressed(QueuePathTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.updateLocation();
        }

        @Override
        public void mouseReleased(QueuePathTool tool, MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    ((QueuePathBuilder)tool.props()).commitLoc();
                    break;
                }
                case 3: {
                    if (!((QueuePathBuilder)tool.props()).isValid()) break;
                    ((QueuePathBuilder)tool.props()).commit(e.getComponent());
                    tool.finish();
                }
            }
        }

        @Override
        public void mouseDragged(QueuePathTool tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(QueuePathTool tool, MouseEvent e) {
            tool.updateLocation();
        }
    }
}

