/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.BooleanSupplier;
import merlin.manip.ATransformManip;
import merlin.util.MerlinProps;
import thunderheadeng.scene3d.tools.AdvancedTool;

public class TransformToolHelper<T extends ATransformManip>
implements Observer {
    private final MerlinProps.WeakRef<T> d_props = new MerlinProps.WeakRef(this);
    private final Semaphore d_lock = new Semaphore(1);
    private final WeakReference<AdvancedTool> d_tool;

    public TransformToolHelper(AdvancedTool tool, T props) {
        this.d_tool = new WeakReference<AdvancedTool>(tool);
        this.d_props.set(props);
    }

    public T getProps() {
        return (T)((ATransformManip)this.d_props.val());
    }

    public void activate() {
        ((ATransformManip)this.d_props.val()).activate();
    }

    public void deactivate() {
        ((ATransformManip)this.d_props.val()).deactivate();
    }

    public boolean tryCancel(BooleanSupplier cancel) {
        if (!this.d_lock.tryAcquire()) {
            return false;
        }
        boolean result = cancel.getAsBoolean();
        this.d_lock.release();
        return result;
    }

    @Override
    public void update(Observable o, Object arg) {
        Optional<AdvancedTool> tool = Optional.ofNullable(this.d_tool.get());
        ATransformManip xform = (ATransformManip)this.d_props.val();
        if (xform.aPropChanged(ATransformManip.OBJS_TRANSFORMED)) {
            tool.ifPresent(t -> t.finish());
        }
        if (xform.aPropChanged(ATransformManip.CANCELLED)) {
            tool.ifPresent(t -> t.cancel());
        }
        if (xform.aPropChanged(ATransformManip.TRANSFORM_CHANGED, ATransformManip.COPY_MODE_CHANGED)) {
            tool.ifPresent(t -> t.repaintSurface());
        }
    }
}

