/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import inferno.util.ModifiableInt;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.mv.tools.RoomSnapConstraint;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NewNavMeshRegionTool<T extends MerlinProps>
extends MerlinTool<T>
implements MouseHistory.IListener {
    private static final Logger LOGGER = Logger.getLogger(NewNavMeshRegionTool.class.getSimpleName());
    private final MouseHistory d_points;
    private final GeomDisplay d_display;
    private final BiConsumer<T, ? super IGeomNode> d_create;
    private static final IPropsSrc s_edgeProps = new UniformProps(new IPrimProps.Edge(Color.GREEN, 3.0, IPrimProps.DEF_STIPPLE, 0));
    private static final IPropsSrc s_faceProps = new UniformProps(new IPrimProps.Face(new Color(0, 255, 0, 128), null, 0));

    public NewNavMeshRegionTool(ModelView mv, MerlinData md, String objDesc, String toolDesc, String axisAlignedDesc, String addMorePointsDesc, BiConsumer<T, ? super IGeomNode> create) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func(md, tool -> {
            String msg = "";
            int nPoints = tool.d_points.getHistory().size();
            if (nPoints == 0) {
                return toolDesc;
            }
            int nCommitted = tool.d_points.committedSize();
            if (nPoints >= 1) {
                msg = String.format(Intl.intl("%1$s - Point %2$d: %3$s"), objDesc, nCommitted + 1, tool.toString(tool.d_points.getHistory().peekLast().p));
            }
            Mode mode = tool.getMode();
            switch (mode) {
                case BLOCK: {
                    if (!msg.isEmpty()) {
                        msg = msg + " - ";
                    }
                    msg = msg + axisAlignedDesc;
                    break;
                }
                case UNKNOWN: {
                    if (!msg.isEmpty()) {
                        msg = msg + " - ";
                    }
                    msg = msg + toolDesc;
                    break;
                }
                case POLY: {
                    if (nCommitted < 3) break;
                    if (!msg.isEmpty()) {
                        msg = msg + " - ";
                    }
                    msg = msg + addMorePointsDesc;
                }
            }
            return msg;
        }));
        this.clearSnapInfo();
        this.setCancelOnRightClick(false);
        this.d_create = create;
        this.d_points = new MouseHistory();
        this.d_points.setDuplicatesAllowed(false);
        this.d_display = new GeomDisplay(mv.getDisplayProps(), new ImportedGeom(""));
        this.d_points.addListener(this);
    }

    @Override
    public void activate() {
        super.activate();
        this.getModelView().getToolScenes()[0].addObjects(this.d_display);
    }

    @Override
    public void deactivate() {
        this.getModelView().getToolScenes()[0].removeObjects(this.d_display);
        super.deactivate();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.updateDisplay();
    }

    private IGeomNode getAABlockShape() {
        Point3d min = new Point3d(this.d_points.getHistory().peekFirst().p);
        Point3d max = new Point3d(this.d_points.getHistory().peekLast().p);
        Util3D.rectify(min, max);
        double offset = 0.25;
        if (!theUtil.eq(min.z, max.z, 1.0E-6)) {
            offset = 0.001;
        }
        min.z -= offset;
        max.z += offset;
        AABox box = new AABox(min, max);
        AABoxGeom geom = new AABoxGeom(box);
        return GeomNodeUtil.newNode(geom);
    }

    protected void updateDisplay() {
        List<Point3d> points = this.d_points.getAllPoints();
        ImportedGeom ig = (ImportedGeom)this.d_display.getSource();
        IGeomNode geom = GeomNodeUtil.EMPTY_NODE;
        IPropsSrc props = DisplayGeom.EMPTY.props;
        Mode mode = this.getMode();
        switch (mode) {
            case BLOCK: {
                assert (points.size() >= 2);
                geom = this.getAABlockShape();
                props = s_faceProps;
                break;
            }
            case POLY: {
                if (points.size() <= 1) break;
                geom = GeomNodeUtil.newNode(new PolyLine(points.toArray(new Point3d[points.size()])));
                props = s_edgeProps;
                break;
            }
        }
        ig.setGeom(geom);
        ig.setDisplayProps(props);
        this.d_display.update();
    }

    @Override
    public void reset() {
        this.d_points.reset();
        this.updateDisplay();
        super.reset();
    }

    private Collection<Pair<Point3d, Plane3d>> getRoomPoints(MerlinData md, SnapInfo si) {
        if (si.constrained.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Pair<Point3d, Plane3d>> snaps = new HashSet<Pair<Point3d, Plane3d>>();
        for (IsectInfo snap : si.getFinalSnaps()) {
            if (snap.getFaceNormal == null) continue;
            Vector3d normal = new Vector3d(snap.getFaceNormal.get());
            Util3D.safeNormalize(normal, 0.0);
            snaps.add(new Pair<Point3d, Plane3d>(snap.isectPoint, new Plane3d(normal, snap.isectPoint)));
        }
        return snaps;
    }

    private boolean xAndYDifferent(MouseHistory.Point p1, MouseHistory.Point p2) {
        return !theUtil.eq(p1.p.x, p2.p.x, 1.0E-6) && !theUtil.eq(p1.p.y, p2.p.y, 1.0E-6);
    }

    private Mode getMode() {
        NewNavMeshRegionTool tool = this;
        int nPoints = tool.d_points.getHistory().size();
        if (nPoints == 0) {
            return Mode.UNKNOWN;
        }
        int nCommitted = tool.d_points.committedSize();
        if (nCommitted > 0 && nCommitted <= 2 && nPoints == 2 && tool.d_points.getHistory().peekLast().dragged && this.xAndYDifferent(tool.d_points.getHistory().peekFirst(), tool.d_points.getHistory().peekLast())) {
            return Mode.BLOCK;
        }
        if (nCommitted == 0) {
            return Mode.UNKNOWN;
        }
        if (nPoints >= 1) {
            return Mode.POLY;
        }
        return Mode.UNKNOWN;
    }

    private IGeomNode getShape(MerlinData md) {
        IGeomNode result;
        Plane3d plane2;
        Mode mode = this.getMode();
        if (mode == Mode.BLOCK) {
            LOGGER.log(Level.FINE, "Constructing AA box");
            return this.getAABlockShape();
        }
        ArrayList<MouseHistory.Point> points = new ArrayList<MouseHistory.Point>(this.d_points.getCommittedHistory());
        LOGGER.log(Level.FINE, "Constructing poly %d", points.size());
        Function<Plane3d, List> mapPointsToPlane = plane -> points.stream().map(p -> plane.projectOntoPlane(p.p)).collect(Collectors.toList());
        Function<Plane3d, IGeomNode> getGeomForPlane = plane -> {
            Model faceModel = new Model();
            List projPoints = (List)mapPointsToPlane.apply((Plane3d)plane);
            if (!faceModel.addPolygonFace(0, (Plane3d)plane, (Point3d[])theUtil.toArray(projPoints)) || faceModel.getFaces().isEmpty()) {
                return null;
            }
            double minDist = -0.25;
            double maxDist = 0.25;
            for (MouseHistory.Point p : points) {
                double dist = plane.dot(p.p);
                if (dist < minDist) {
                    minDist = dist;
                }
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            double offsetExtrusion = minDist;
            double offsetBase = maxDist;
            Vector3d offsetDir = Util3D.scale(plane.getNormal(), offsetBase);
            TransformInfo tiUp = TransformUtil.translate(offsetDir).getInfo();
            Vector3d extrudeDir = Util3D.scale(plane.getNormal(), offsetExtrusion - offsetBase);
            ArrayList<ExtrudedPoly> geoms = new ArrayList<ExtrudedPoly>(faceModel.getFaces().size());
            for (Face face : faceModel.getFaces()) {
                IFace gface = face.toGeomFace();
                IFace tface = gface.transform(tiUp, 1);
                if (!(tface instanceof IPolygon)) continue;
                ExtrudedPoly epoly = new ExtrudedPoly((IPolygon)tface, extrudeDir);
                geoms.add(epoly);
            }
            IGeom geom = GeomUtil.group(geoms);
            return GeomNodeUtil.newNode(geom);
        };
        List roomPoints = points.stream().flatMap(p -> this.getRoomPoints(md, p.snap).stream()).collect(Collectors.toList());
        ArrayList usedRoomPlanes = new ArrayList();
        for (Pair rp : roomPoints) {
            boolean found = false;
            for (Pair pair : usedRoomPlanes) {
                if (!((Plane3d)pair.v1).epsilonEquals((Plane3d)rp.v2, 1.0E-6)) continue;
                ++((ModifiableInt)pair.v2).value;
                found = true;
            }
            if (found) continue;
            usedRoomPlanes.add(new Pair(rp.v2, new ModifiableInt(1)));
        }
        if (!usedRoomPlanes.isEmpty()) {
            HashMap planeAreas = new HashMap();
            double maxPlaneArea = 0.0;
            for (Pair pair : usedRoomPlanes) {
                List projPoints = mapPointsToPlane.apply((Plane3d)pair.v1);
                double area = Util3D.simplePolygonArea(projPoints);
                if (area > maxPlaneArea) {
                    maxPlaneArea = area;
                }
                planeAreas.put(pair.v1, area);
            }
            Comparator planeComparator = maxPlaneArea > 0.0 ? (e1, e2) -> Double.compare((Double)planeAreas.get(e2.v1), (Double)planeAreas.get(e1.v1)) : (e1, e2) -> Integer.compare(((ModifiableInt)e2.v2).value, ((ModifiableInt)e1.v2).value);
            Optional<IGeomNode> optional = usedRoomPlanes.stream().sorted(planeComparator).map(entry -> (IGeomNode)getGeomForPlane.apply((Plane3d)entry.v1)).filter(geom -> geom != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        ArrayList<Point3d> planePoints = new ArrayList<Point3d>();
        for (MouseHistory.Point p2 : points) {
            Optional<Point3d> snappedToRoom;
            if (!p2.snapped || !(snappedToRoom = p2.snap.snaps.stream().filter(isect -> isect.obj instanceof IEgressOccupiable).map(isect -> isect.isectPoint).findAny()).isPresent()) continue;
            planePoints.add(snappedToRoom.get());
        }
        if (planePoints.size() >= 3 && (plane2 = Util3D.simplePolygonPlane(planePoints, true, 1.0E-6)) != null && (result = getGeomForPlane.apply(plane2)) != null) {
            return result;
        }
        planePoints.clear();
        planePoints.addAll(theUtil.map(points, p -> p.p));
        Plane3d plane3 = Util3D.simplePolygonPlane(planePoints, true, 1.0E-6);
        if (plane3 != null && (result = getGeomForPlane.apply(plane3)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void finish() {
        MerlinData data = MerlinApp.getApp().getData();
        IGeomNode shape = this.getShape(data);
        if (shape != null) {
            this.d_create.accept(this.props(), shape);
        }
        this.reset();
        super.finish();
    }

    @Override
    public boolean cancel() {
        this.reset();
        return super.cancel();
    }

    protected static class Func
    extends AToolFunction<NewNavMeshRegionTool> {
        private final MerlinData d_md;
        private final Function<NewNavMeshRegionTool, String> d_getToolMsg;

        public Func(MerlinData md, Function<NewNavMeshRegionTool, String> getToolMsg) {
            this.d_md = md;
            this.d_getToolMsg = getToolMsg;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getSnapInfo(NewNavMeshRegionTool tool) {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
        }

        @Override
        public ISnapConstraint getSnapConstraint(NewNavMeshRegionTool tool) {
            return new RoomSnapConstraint(this.d_md, tool.getDefaultConstraint());
        }

        @Override
        public Cursor getCursor(NewNavMeshRegionTool tool) {
            return null;
        }

        @Override
        public void mousePressed(NewNavMeshRegionTool tool, MouseEvent e) {
            tool.d_points.mousePressed(tool, e, tool.getP1());
            tool.updateStatusMessage();
        }

        @Override
        public void mouseReleased(NewNavMeshRegionTool tool, MouseEvent e) {
            tool.d_points.mouseReleased(tool, e, tool.getP1());
            tool.updateStatusMessage();
            Mode mode = tool.getMode();
            if (e.getButton() == 3) {
                if (mode == Mode.POLY && tool.d_points.committedSize() >= 3) {
                    tool.finish();
                } else {
                    tool.cancel();
                }
                return;
            }
            if (mode == Mode.BLOCK && tool.d_points.committedSize() == 2) {
                tool.finish();
                return;
            }
        }

        @Override
        public void mouseDragged(NewNavMeshRegionTool tool, MouseEvent e) {
            tool.d_points.mouseDragged(tool, e, tool.getP1());
            tool.updateStatusMessage();
        }

        @Override
        public void mouseMoved(NewNavMeshRegionTool tool, MouseEvent e) {
            tool.d_points.mouseMoved(tool, e, tool.getP1());
            tool.updateStatusMessage();
        }

        @Override
        public String getStatusMessage(NewNavMeshRegionTool tool) {
            return this.d_getToolMsg.apply(tool);
        }
    }

    private static enum Mode {
        UNKNOWN,
        POLY,
        BLOCK;

    }
}

