/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.ImportedGeom;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.units.UnitDouble;

public class MeasureTool
extends CursorTool {
    private final GeomDispMgr.Display d_actor;
    private IMeasureListener d_measureListener;
    private final List<Point3d> d_points;

    public MeasureTool(ModelView mv) {
        super(mv, NavtoolUtil.newPannableDrawTool(new Func()));
        this.setCancelOnRightClick(false);
        this.setSnapInfo(SnapMode.ANY, null);
        this.d_points = new ArrayList<Point3d>();
        this.d_actor = new GeomDispMgr.Display(mv.getDisplayProps(), this.createDisplay(this.d_points));
    }

    protected IMerlinGeomSrc createDisplay(List<Point3d> points) {
        if (this.d_points.size() < 2) {
            return new ImportedGeom("");
        }
        PolyLine pl = new PolyLine(this.d_points.toArray(new Point3d[this.d_points.size()]));
        IPrimProps.Edge props = new IPrimProps.Edge(Color.YELLOW, 3.0, IPrimProps.DEF_STIPPLE, 0);
        return new ImportedGeom("", new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(pl), (IPrimProps)props));
    }

    public IMerlinDisplay getDisplay() {
        return this.d_actor;
    }

    public void setListener(IMeasureListener listener) {
        this.d_measureListener = listener;
    }

    private UnitDouble measurePath() {
        ArrayList<Point3d> filtered = new ArrayList<Point3d>(this.d_points.size());
        for (Point3d p : this.d_points) {
            filtered.add(this.filterPoint(p));
        }
        double length = 0.0;
        for (int m = 0; m < filtered.size() - 1; ++m) {
            Point3d p1 = (Point3d)filtered.get(m);
            Point3d p2 = (Point3d)filtered.get(m + 1);
            length += p1.distance(p2);
        }
        return new UnitDouble(length, Geometry.LENGTH_UNIT);
    }

    @Override
    public boolean cancel() {
        this.pauseRepaint();
        this.d_points.clear();
        this.updateActor(this.d_points);
        boolean canceled = super.cancel();
        this.resumeRepaint();
        return canceled;
    }

    private Point3d filterPoint(Point3d p) {
        Camera cam = this.getView().getCamera();
        if (cam instanceof PerspectiveCamera) {
            return p;
        }
        Plane3d viewPlane = cam.getRefPlane();
        CursorTool.Ray pickRay = this.getPickRay(p);
        Point3d filtered = Inter3D.rayPlaneIntersection(pickRay.begin, pickRay.dir, viewPlane, 1.0E-6);
        return filtered != null ? filtered : p;
    }

    private void updateActor(List<Point3d> points) {
        this.d_actor.setSource(this.createDisplay(points));
        this.repaintSurface();
    }

    protected static class Func
    extends AToolFunction<MeasureTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(MeasureTool tool) {
            return null;
        }

        @Override
        public void mouseDragged(MeasureTool tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(MeasureTool tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(MeasureTool tool, MouseEvent e) {
            tool.d_points.add(new Point3d(tool.getP1().referenceSnap));
            tool.updateActor(tool.d_points);
            tool.d_points.remove(tool.d_points.size() - 1);
        }

        @Override
        public void mouseReleased(MeasureTool tool, MouseEvent e) {
            if (e.getButton() == 1) {
                tool.d_points.add(new Point3d(tool.getP1().referenceSnap));
                tool.updateActor(tool.d_points);
            } else if (e.getButton() == 3) {
                tool.updateActor(tool.d_points);
                tool.resumeRepaint();
                if (tool.d_measureListener != null) {
                    tool.d_measureListener.measurementMade(tool.measurePath());
                }
                tool.pauseRepaint();
                tool.d_points.clear();
                tool.updateActor(tool.d_points);
                tool.finish();
            }
        }

        @Override
        public String getStatusMessage(MeasureTool tool) {
            Point3d p = tool.getP1().referenceSnap;
            String msg = String.format(Intl.intl("Point %d: %s"), tool.d_points.size() + 1, tool.toString(p));
            if (tool.d_points.size() > 0) {
                tool.d_points.add(p);
                UnitDouble len = tool.measurePath();
                tool.d_points.remove(tool.d_points.size() - 1);
                msg = msg + "        ";
                msg = msg + String.format(Intl.intl("[total length = %s]"), tool.toString(len.getValue(Geometry.LENGTH_UNIT)));
            }
            return msg;
        }
    }

    public static interface IMeasureListener {
        public void measurementMade(UnitDouble var1);
    }
}

