/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.propConnections;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import merlin.MerlinApp;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.mv.gui.propConnections.APropEditorListener;
import merlin.mv.gui.propConnections.IPropConnection;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.util.Events;

public abstract class APropConnection<T extends JComponent>
extends APropEditorListener
implements IPropConnection {
    private static final int TYPE_DELAY = 200;
    private Object d_prop;
    private T d_control;
    private Collection<ICompElement> d_data;
    private Action d_listenerAction;
    private Semaphore d_lock;
    private boolean d_live;

    public APropConnection(Object prop, T control) {
        this.d_prop = prop;
        this.d_control = control;
        this.d_live = true;
        this.d_lock = new Semaphore(1);
        this.d_listenerAction = new AbstractAction(){
            private static final long serialVersionUID = -4648901793085810153L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                APropConnection.this.onControlChanged();
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        ((JComponent)this.d_control).getInputMap().put(enter, "enter");
        ((JComponent)this.d_control).getActionMap().put("enter", this.d_listenerAction);
    }

    protected Object getProp() {
        return this.d_prop;
    }

    public T getControl() {
        return this.d_control;
    }

    public void setUpdateLock(Semaphore lock) {
        this.d_lock = lock;
    }

    public Semaphore getUpdateLock() {
        return this.d_lock;
    }

    protected boolean isLocked() {
        return this.d_lock.availablePermits() == 0;
    }

    public Collection<ICompElement> getObjs() {
        return this.d_data;
    }

    protected boolean isDataEmpty() {
        return this.d_data == null || this.d_data.isEmpty();
    }

    protected boolean isModified(T comp) {
        return !(this.d_control instanceof Modifiable) || ((Modifiable)this.d_control).isModified();
    }

    protected void setModified(T comp, boolean modified) {
        if (comp instanceof Modifiable) {
            ((Modifiable)comp).setModified(modified);
        }
    }

    public abstract void setProp(Object var1, Collection<? extends ICompElement> var2, T var3);

    public abstract void initFromProp(Object var1, Collection<? extends ICompElement> var2, T var3);

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    public void setLive(boolean live) {
        this.d_live = live;
    }

    public boolean isLive() {
        return this.d_live;
    }

    @Override
    public void onControlChanged() {
        if (this.d_live) {
            this.commit();
        }
    }

    @Override
    public void commit() {
        if (!this.d_lock.tryAcquire()) {
            return;
        }
        try {
            if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            md.pauseUpdates();
            this.setProp(this.d_prop, this.d_data, this.d_control);
            md.resumeUpdates();
            this.setModified(this.d_control, false);
        }
        finally {
            this.d_lock.release();
        }
    }

    @Override
    public void update(Events events) {
        if (!this.d_lock.tryAcquire()) {
            return;
        }
        try {
            if (this.isDataEmpty()) {
                return;
            }
            this.initFromProp();
        }
        finally {
            this.d_lock.release();
        }
    }

    protected void initFromProp() {
        this.initFromProp(this.d_prop, this.d_data, this.d_control);
    }

    @Override
    public void bind(Collection<ICompElement> objs) {
        this.d_data = objs;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!APropConnection.this.d_lock.tryAcquire()) {
                    return;
                }
                try {
                    if (APropConnection.this.isDataEmpty()) {
                        return;
                    }
                    APropConnection.this.initFromProp();
                }
                finally {
                    APropConnection.this.d_lock.release();
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void release() {
        this.d_data = Collections.EMPTY_LIST;
    }
}

