/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntPredicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.value.AValEditor;
import merlin.gui.value.MultiValEditor;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;

public class WaitSrcEditorPnl
extends MultiValEditor<IWaitUntilSrc> {
    private static final long serialVersionUID = 1L;
    public static final int OPT_SINGLE_TIME = 1;
    public static final int OPT_INTERVAL = 2;
    public static final int OPT_LIST = 4;
    public static final int OPT_ALL = 7;

    public static Collection<MultiValEditor.Entry<IWaitUntilSrc, ? extends IWaitUntilSrc>> getEntries(int unit, int options) {
        ArrayList<MultiValEditor.Entry<IWaitUntilSrc, ? extends IWaitUntilSrc>> entries = new ArrayList<MultiValEditor.Entry<IWaitUntilSrc, ? extends IWaitUntilSrc>>();
        IntPredicate opt = i -> (i & options) == i;
        if (opt.test(1)) {
            SimpleWaitSrcEditor simpleEditor = new SimpleWaitSrcEditor(unit);
            entries.add(new MultiValEditor.Entry<IWaitUntilSrc, IWaitUntilSrc.SimpleWaitUntilSrc>(Intl.intl("Wait until a specific time"), Intl.intl("Enter a single time. Occupants will wait until this time."), simpleEditor, waitSrc -> waitSrc != null, () -> true, IWaitUntilSrc::convertToSimple));
        }
        if (opt.test(4)) {
            ListWaitSrcEditor listEditor = new ListWaitSrcEditor(unit);
            entries.add(new MultiValEditor.Entry<IWaitUntilSrc, IWaitUntilSrc.ListedWaitUntilSrc>(Intl.intl("Wait until next scheduled time"), Intl.intl("Enter a list of times. Occupants will wait until the next time in the list."), listEditor, waitSrc -> waitSrc != null, () -> true, IWaitUntilSrc::convertToList));
        }
        if (opt.test(2)) {
            IntervalWaitSrcEditor intervalEditor = new IntervalWaitSrcEditor(unit);
            entries.add(new MultiValEditor.Entry<IWaitUntilSrc, IWaitUntilSrc.CycledWaitUntilSrc>(Intl.intl("Wait until next periodic time"), Intl.intl("Enter a periodic function. Occupants will wait until the next time in this function."), intervalEditor, waitSrc -> waitSrc != null, () -> true, IWaitUntilSrc::convertToIntervals));
        }
        return entries;
    }

    public WaitSrcEditorPnl(int unit) {
        this(unit, 7);
    }

    public WaitSrcEditorPnl(int unit, int options) {
        super(IWaitUntilSrc.class, WaitSrcEditorPnl.getEntries(unit, options), true);
    }

    private static UnitDoubleVR getTimeRange() {
        return UnitDoubleVR.above(0.0, SI.SECOND, true);
    }

    private static class ListWaitSrcEditor
    extends AValEditor<IWaitUntilSrc.ListedWaitUntilSrc> {
        private static final long serialVersionUID = 1L;
        private final guiTable d_table;

        public ListWaitSrcEditor(int unit) {
            super(IWaitUntilSrc.ListedWaitUntilSrc.class);
            String[] headers = new String[]{Intl.intl("Time")};
            Class[] clazzes = new Class[]{UnitDouble.class};
            guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, clazzes), 30);
            this.d_table = this.registerEd(ed.getTable());
            this.d_table.addValueChangedListener("value");
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getUnit(unit)));
            this.d_table.setNullValuesAllowed(false);
            this.d_table.autoSizeColumns(500);
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(200);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.min(500, this.d_table.getPreferredSize().height)));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(ed);
            gbh.finalizeRows();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.addRow(this, 1.0);
        }

        @Override
        protected void loadValue(IWaitUntilSrc.ListedWaitUntilSrc value) {
            IListenerStripper stripper = guiUtil.stripListeners(this.d_table);
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            int count = model.getRowCount();
            for (int i = count - 1; i >= 0; --i) {
                model.removeRow(i);
            }
            if (value != null) {
                List<ICurve> curves = value.d_goTimes;
                for (int i = 0; i < curves.size(); ++i) {
                    UnitDouble time = curves.get(i).getAvg();
                    model.setValueAt(time, i, 0);
                }
            }
            stripper.restore();
        }

        @Override
        protected IWaitUntilSrc.ListedWaitUntilSrc saveValue() {
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            int rows = model.getRowCount();
            ArrayList<ICurve> times = new ArrayList<ICurve>(rows);
            for (int r = 0; r < rows; ++r) {
                UnitDouble time = (UnitDouble)model.getValueAt(r, 0);
                if (time == null) continue;
                times.add(new ConstantCurve(time));
            }
            return new IWaitUntilSrc.ListedWaitUntilSrc(times);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            UnitDoubleVR range = WaitSrcEditorPnl.getTimeRange();
            int rowCount = model.getRowCount();
            UnitDouble prevVal = null;
            for (int rowIx = 0; rowIx < rowCount; ++rowIx) {
                UnitDouble val = (UnitDouble)model.getValueAt(rowIx, 0);
                if (val == null) continue;
                if (prevVal != null) {
                    if (val.compareTo(prevVal) <= 0) {
                        this.d_table.flagInvalidCell(rowIx, 0, showWarn, allowModify, Intl.intl("Wait times must be listed in ascending order."));
                        return false;
                    }
                    prevVal = val;
                    continue;
                }
                if (!range.checkValue(val)) {
                    String error = range.describeRange();
                    this.d_table.flagInvalidCell(rowIx, 0, showWarn, allowModify, error);
                    return false;
                }
                prevVal = val;
            }
            return true;
        }
    }

    private static class IntervalWaitSrcEditor
    extends AValEditor<IWaitUntilSrc.CycledWaitUntilSrc> {
        private static final long serialVersionUID = 1L;
        private VerboseCurveEditor d_initTimeEditor;
        private VerboseCurveEditor d_intervalEditor;

        public IntervalWaitSrcEditor(int unit) {
            super(IWaitUntilSrc.CycledWaitUntilSrc.class);
            UnitDoubleVR range = WaitSrcEditorPnl.getTimeRange();
            this.d_initTimeEditor = this.registerEd(new VerboseCurveEditor(unit, false, range));
            this.d_intervalEditor = this.registerEd(new VerboseCurveEditor(unit, false, range));
            GridBagHelper gbh = new GridBagHelper(this, false);
            gbh.addRow(new guiLabel(Intl.intl("Time offset:")), this.d_initTimeEditor, 1.0, 0);
            gbh.addRow(new guiLabel(Intl.intl("Time interval:")), this.d_intervalEditor, 1.0, 0);
            gbh.finalizeRows();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        protected void loadValue(IWaitUntilSrc.CycledWaitUntilSrc value) {
            IListenerStripper initStripper = guiUtil.stripListeners(this.d_initTimeEditor);
            IListenerStripper ntrvlStripper = guiUtil.stripListeners(this.d_intervalEditor);
            this.d_initTimeEditor.setValue(value.d_initialTime);
            this.d_intervalEditor.setValue(value.d_intervalTime);
            initStripper.restore();
            ntrvlStripper.restore();
        }

        @Override
        protected IWaitUntilSrc.CycledWaitUntilSrc saveValue() {
            return new IWaitUntilSrc.CycledWaitUntilSrc((ICurve)this.d_initTimeEditor.getValue(), (ICurve)this.d_intervalEditor.getValue());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            ICurve initCurve = (ICurve)this.d_initTimeEditor.getValue();
            ICurve intervalCurve = (ICurve)this.d_intervalEditor.getValue();
            if (initCurve == null || intervalCurve == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("A value must be entered for all parameters."));
                }
                return false;
            }
            return true;
        }
    }

    private static class SimpleWaitSrcEditor
    extends AValEditor<IWaitUntilSrc.SimpleWaitUntilSrc> {
        private static final long serialVersionUID = 1L;
        private VerboseCurveEditor d_editor;

        public SimpleWaitSrcEditor(int unit) {
            super(IWaitUntilSrc.SimpleWaitUntilSrc.class);
            this.d_editor = this.registerEd(new VerboseCurveEditor(unit, false, WaitSrcEditorPnl.getTimeRange()));
            GridBagHelper gbh = new GridBagHelper(this, false);
            gbh.addRow(Intl.intl("Time:"), this.d_editor, 1.0, 0);
            gbh.finalizeRows();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        protected void loadValue(IWaitUntilSrc.SimpleWaitUntilSrc value) {
            ICurve distribution = value.d_waitTime;
            this.d_editor.setValue(distribution);
        }

        @Override
        protected IWaitUntilSrc.SimpleWaitUntilSrc saveValue() {
            ICurve times = (ICurve)this.d_editor.getValue();
            return new IWaitUntilSrc.SimpleWaitUntilSrc(times);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }
    }
}

