/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.mv.gui.LocationPanel;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.QuadConsumer;

public class RoomLocPanel<T extends MerlinProps>
extends LocationPanel<T> {
    private static final long serialVersionUID = 1L;
    private final QuadConsumer<T, IEgressOccupiable, Vector3d, UnitPoint3D> d_setLocation;
    private final Function<T, UnitPoint3D> d_getLocation;

    public RoomLocPanel(QuadConsumer<T, IEgressOccupiable, Vector3d, UnitPoint3D> setLocation, Function<T, UnitPoint3D> getLocation, Object ... interestingChanges) {
        super(1, interestingChanges);
        this.d_setLocation = setLocation;
        this.d_getLocation = getLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateToProps(T props) {
        MerlinData md = MerlinApp.getApp().getData();
        md.beginRead();
        try {
            UnitPoint3D specPoint = this.getValue();
            Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
            p1.z += 1.0E-6;
            AABox modelBounds = MerlinApp.getApp().getData().geomLocation.getBounds();
            Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
            GeomUtil.FindResult findResult = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 1);
            IEgressOccupiable room = findResult != null ? findResult.room : null;
            Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
            UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
            this.d_setLocation.accept(props, room, norm, p);
        }
        finally {
            md.endRead();
        }
    }

    @Override
    protected void updateFromProps(T props) {
        this.setValue(this.d_getLocation.apply(props));
    }
}

