/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddOccupantSourceAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.gui.APropEditPanel;
import merlin.gui.MerlinComboBox;
import merlin.gui.guiUtil;
import merlin.mv.gui.NewRectPanel;
import merlin.util.MerlinProps;
import merlin.util.OccSourceProps;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.Predicates;

public class NewOccSourcePanel
extends APropEditPanel<OccSourceProps> {
    private static final long serialVersionUID = 6852839832673403317L;
    private final NewRectPanel d_rectPanel;
    private final CompPanel<EgressDoor> d_doorPanel;
    private final CompPanel<IEgressOccupiable> d_roomPanel;
    private final guiRadioButton d_boxRB;
    private final guiRadioButton d_doorRB;
    private final guiRadioButton d_roomRB;
    private final MerlinProps.WeakRef<OccSourceProps> d_props = new MerlinProps.WeakRef(this);

    public NewOccSourcePanel(MerlinData md) {
        super(OccSourceProps.COMP_SET);
        this.d_rectPanel = new NewRectPanel(md, new guiPanel[0]);
        this.d_doorPanel = new CompPanel<EgressDoor>(md, EgressDoor.class);
        this.d_roomPanel = new CompPanel<IEgressComp>(md, IEgressOccupiable.class, OccSourceObj.occsAllowedFilter());
        guiPanel optionPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(optionPnl);
        this.d_boxRB = new guiRadioButton(Intl.intl("From rectangle"), true);
        this.d_doorRB = new guiRadioButton(Intl.intl("From door"), false);
        this.d_roomRB = new guiRadioButton(Intl.intl("From room"), false);
        guiUtil.group(new AbstractButton[]{this.d_boxRB, this.d_doorRB, this.d_roomRB});
        gb.addRow(this.d_boxRB);
        gb.addRow(this.d_doorRB);
        gb.addRow(this.d_roomRB);
        CardLayout cardLayout = new CardLayout();
        guiPanel cardPanel = new guiPanel(cardLayout);
        cardPanel.add((Component)this.d_rectPanel, NewOccSourcePanelOptions.FROM_RECTANGLE.toString());
        cardPanel.add(this.d_doorPanel, NewOccSourcePanelOptions.FROM_DOOR.toString());
        cardPanel.add(this.d_roomPanel, NewOccSourcePanelOptions.FROM_ROOM.toString());
        NewOccSourceActionListener actionListener = new NewOccSourceActionListener(this.d_boxRB, this.d_doorRB, this.d_roomRB, cardLayout, cardPanel);
        this.d_boxRB.addActionListener(actionListener);
        this.d_doorRB.addActionListener(actionListener);
        this.d_roomRB.addActionListener(actionListener);
        this.addSection(optionPnl);
        this.addSeparator();
        this.addSection(cardPanel);
    }

    @Override
    public void setProps(OccSourceProps props) {
        this.d_props.set(props);
        if (props == null) {
            return;
        }
        this.updateFromProps(props);
    }

    @Override
    public OccSourceProps props() {
        return this.d_props.val();
    }

    @Override
    protected void updateFromProps(OccSourceProps props) {
        switch (props.state) {
            case FROM_RECTANGLE: {
                this.d_rectPanel.setProps(props);
                break;
            }
            case FROM_DOOR: {
                this.d_doorPanel.compCB.setSelectedItem(props.component);
                break;
            }
            case FROM_ROOM: {
                this.d_roomPanel.compCB.setSelectedItem(props.component);
            }
        }
    }

    public static enum NewOccSourcePanelOptions {
        FROM_RECTANGLE,
        FROM_DOOR,
        FROM_ROOM;

    }

    private class NewOccSourceActionListener
    implements ActionListener {
        private final guiRadioButton boxRB;
        private final CardLayout cardLayout;
        private final guiPanel cardPanel;
        private final guiRadioButton doorRB;
        private final guiRadioButton roomRB;

        public NewOccSourceActionListener(guiRadioButton boxRB, guiRadioButton doorRB, guiRadioButton roomRB, CardLayout cardLayout, guiPanel cardPanel) {
            this.boxRB = boxRB;
            this.doorRB = doorRB;
            this.roomRB = roomRB;
            this.cardLayout = cardLayout;
            this.cardPanel = cardPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.boxRB.isSelected()) {
                this.cardLayout.show(this.cardPanel, NewOccSourcePanelOptions.FROM_RECTANGLE.toString());
                this.cardPanel.setPreferredSize(NewOccSourcePanel.this.d_rectPanel.getPreferredSize());
                NewOccSourcePanel.this.props().setState(NewOccSourcePanelOptions.FROM_RECTANGLE);
            } else if (this.doorRB.isSelected()) {
                this.cardLayout.show(this.cardPanel, NewOccSourcePanelOptions.FROM_DOOR.toString());
                this.cardPanel.setPreferredSize(NewOccSourcePanel.this.d_doorPanel.getPreferredSize());
                NewOccSourcePanel.this.props().setState(NewOccSourcePanelOptions.FROM_DOOR);
            } else {
                assert (this.roomRB.isSelected());
                this.cardLayout.show(this.cardPanel, NewOccSourcePanelOptions.FROM_ROOM.toString());
                this.cardPanel.setPreferredSize(NewOccSourcePanel.this.d_roomPanel.getPreferredSize());
                NewOccSourcePanel.this.props().setState(NewOccSourcePanelOptions.FROM_ROOM);
            }
        }
    }

    private class CompPanel<T extends IEgressComp>
    extends guiPanel {
        private static final long serialVersionUID = 1418367488414789391L;
        MerlinComboBox<T> compCB;

        public CompPanel(MerlinData md, Class<T> clazz) {
            this(md, clazz, Predicates.alwaysTrue());
        }

        public CompPanel(MerlinData md, Class<T> clazz, Predicate<? super T> filter) {
            this.compCB = new MerlinComboBox(md, clazz, filter, (IMerlinObj[])new IEgressComp[0]);
            Dimension psCB = this.compCB.getPreferredSize();
            psCB.width = 100;
            this.compCB.setPreferredSize(psCB);
            JButton createBtn = new JButton(Intl.intl("Create"));
            Dimension ps = createBtn.getPreferredSize();
            ps.height -= 4;
            createBtn.setPreferredSize(ps);
            createBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final IEgressComp selectedComp = (IEgressComp)CompPanel.this.compCB.getSelectedItem();
                    if (selectedComp == null) {
                        return;
                    }
                    AMerlinOp modOp = new AMerlinOp(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run(MerlinApp app, MerlinData md) {
                            INameGenerator nameGenerator = md.occSourceNameGen;
                            md.beginWrite();
                            try {
                                Undo.begin(Intl.intl("New Occupants Source"));
                                try {
                                    AddOccupantSourceAction.addOccSources(md, nameGenerator, Collections.singleton(selectedComp));
                                }
                                finally {
                                    Undo.end(md);
                                }
                            }
                            finally {
                                md.endWrite();
                            }
                        }
                    };
                    UIHook.run(null, "NewOccSourcePanel.addOccSource", modOp, 6);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.compCB, createBtn);
        }
    }
}

