/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import merlin.Intl;
import merlin.builders.AgentRegionDropper;
import merlin.data.MerlinData;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.OccAreaMgr;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.APropEditPanel;
import merlin.gui.DistributionEditor;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.gui.guiUtil;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import merlin.util.OccAreaListCellRenderer;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;

public class NewAgentRegionPanel
extends APropEditPanel<AgentRegionDropper> {
    private static final long serialVersionUID = -10777475736080672L;
    private final APropEditPanel<AgentRegionDropper> d_countPanel;
    private final APropEditPanel<AgentRegionDropper> d_spacingPanel;

    public NewAgentRegionPanel(MerlinData md) {
        super(new Object[0]);
        this.d_countPanel = new CountPanel(md);
        this.d_spacingPanel = new SpacingProfilePanel(md);
        this.addSection(this.d_spacingPanel);
        this.addSeparator();
        this.addSection(this.d_countPanel);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    private class SpacingProfilePanel
    extends APropEditPanel<AgentRegionDropper> {
        private static final long serialVersionUID = 2923119494224293604L;
        private final DistributionEditor<OccProfile> d_profilesDistEd;
        private final DistributionEditor<Behavior> d_behaviorsDistEd;
        private final guiRadioButton d_uniformRB;
        private final guiRadioButton d_randomRB;
        private final Semaphore d_lock;

        public SpacingProfilePanel(MerlinData md) {
            super(AgentRegionDropper.SPACING_CHANGED, AgentRegionDropper.PROFILE_CHANGED, AgentRegionDropper.BEHAVIOR_CHANGED);
            this.d_lock = new Semaphore(1);
            Pair<guiRadioButton, guiRadioButton> placementBtns = guiUtil.createPlacementButtons();
            this.d_uniformRB = (guiRadioButton)this.initButton((AbstractButton)placementBtns.v1, new IPropEditCommand[0]);
            this.d_randomRB = (guiRadioButton)this.initButton((AbstractButton)placementBtns.v2, new IPropEditCommand[0]);
            Observer distListener = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    SpacingProfilePanel.this.updateToProps((AgentRegionDropper)SpacingProfilePanel.this.props());
                }
            };
            this.d_profilesDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
            this.d_behaviorsDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
            this.d_profilesDistEd.addObserver(distListener);
            this.d_behaviorsDistEd.addObserver(distListener);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 2;
            gb.addRow(Intl.intl("Placement:"), this.d_uniformRB, this.d_randomRB);
            gb.addRow(Intl.intl("Profile:"), this.d_profilesDistEd, 1.0, 2);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorsDistEd, 1.0, 2);
        }

        @Override
        protected void updateFromProps(AgentRegionDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            if (props != null) {
                this.d_profilesDistEd.setValue((OccProfile)((Object)props.getProfileDist()));
                this.d_behaviorsDistEd.setValue((Behavior)((Object)props.getBehaviorDist()));
                this.d_uniformRB.setSelected(props.getSpacing() == 0);
                this.d_randomRB.setSelected(props.getSpacing() == 1);
            }
            this.d_lock.release();
        }

        @Override
        protected void updateToProps(AgentRegionDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (props == null) {
                    return;
                }
                props.pause();
                props.setProfileDist((IUrn)this.d_profilesDistEd.getValue());
                props.setBehaviorDist((IUrn)this.d_behaviorsDistEd.getValue());
                if (this.d_uniformRB.isSelected()) {
                    props.setSpacing(0);
                } else {
                    props.setSpacing(1);
                }
                props.resume();
            }
            finally {
                this.d_lock.release();
            }
        }
    }

    private class CountPanel
    extends APropEditPanel<AgentRegionDropper> {
        private static final long serialVersionUID = -8532636617530946868L;
        private final IOccArea OAREA_CUSTOM;
        private guiRadioButton d_rbByNumber;
        private guiIntField d_fldByNumber;
        private guiRadioButton d_rbByDensity;
        private guiComboBox<IOccArea> d_cbByDensity;
        private MerlinUDF d_fldByDensity;

        public CountPanel(MerlinData md) {
            super(AgentRegionDropper.COUNT_CHANGED);
            this.OAREA_CUSTOM = new OccArea(Intl.intl("Custom:"), new UnitDouble(5.0, EnglishUS.unit(4)));
            this.d_rbByNumber = new guiRadioButton(Intl.intl("Count:"));
            this.d_rbByDensity = new guiRadioButton(Intl.intl("Density:"));
            new guiButtonGroup(this.d_rbByNumber, this.d_rbByDensity);
            this.d_fldByNumber = new guiIntField(0, IntVR.above(0, true));
            LinkStatus.link((AbstractButton)this.d_rbByNumber, this.d_fldByNumber);
            this.d_cbByDensity = new guiComboBox();
            this.d_cbByDensity.addItem((IOccArea)this.OAREA_CUSTOM);
            for (IOccArea oArea : OccAreaMgr.getNonEmptySpecs()) {
                this.d_cbByDensity.addItem((IOccArea)oArea);
            }
            OccAreaListCellRenderer.RendNoPreview rend = new OccAreaListCellRenderer.RendNoPreview();
            this.d_cbByDensity.setRenderer(rend);
            this.d_fldByDensity = new MerlinUDF(2);
            UnitDouble dMin = new UnitDouble(0.0, SIUS.unit(2));
            this.d_fldByDensity.setValueRange(UnitDoubleVR.above(dMin, true));
            LinkStatus.link((AbstractButton)this.d_rbByDensity, this.d_cbByDensity, this.d_fldByDensity);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_rbByNumber, this.d_fldByNumber);
            gb.addRow(this.d_rbByDensity, this.d_cbByDensity, this.d_fldByDensity);
            this.addDefaultListener(this.d_rbByNumber, this.d_rbByDensity);
            this.addDefaultTFAction(this.d_fldByNumber, this.d_fldByDensity);
            this.d_cbByDensity.addItemListener(new UpdateListener());
            this.d_cbByDensity.setSelectedItem(this.OAREA_CUSTOM);
            this.updateDensityField();
            this.d_rbByNumber.setSelected(true);
        }

        private void updateDensityField() {
            IOccArea selItem = this.d_cbByDensity.getSelectedItem();
            boolean custom = selItem == this.OAREA_CUSTOM;
            this.d_fldByDensity.setEditable(custom);
            this.d_fldByDensity.setValue(selItem.getArea());
            this.d_fldByDensity.setToolTipText(this.d_fldByDensity.getText());
        }

        @Override
        protected void updateFromProps(AgentRegionDropper props) {
            if (props.getOccCount() instanceof ConstOccCount) {
                ConstOccCount cc = (ConstOccCount)props.getOccCount();
                this.d_fldByNumber.setValue(cc.count);
            } else if (props.getOccCount() instanceof IOccArea) {
                IOccArea oArea = (IOccArea)props.getOccCount();
                UnitDouble udArea = oArea.getArea();
                this.d_fldByDensity.setValue(udArea);
                this.d_fldByDensity.setToolTipText(this.d_fldByDensity.getText());
            }
        }

        @Override
        protected void updateToProps(AgentRegionDropper props) {
            if (this.d_rbByNumber.isSelected()) {
                props.setOccCount(new ConstOccCount((Integer)this.d_fldByNumber.getValue()));
            } else if (this.d_rbByDensity.isSelected()) {
                boolean custom;
                IOccArea selItem = this.d_cbByDensity.getSelectedItem();
                boolean bl = custom = selItem == this.OAREA_CUSTOM;
                if (custom) {
                    props.setOccCount(new OccArea((UnitDouble)this.d_fldByDensity.getValue()));
                } else {
                    props.setOccCount(selItem);
                }
            }
        }

        private class UpdateListener
        implements ItemListener {
            private UpdateListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                CountPanel.this.updateDensityField();
                CountPanel.this.updateToProps((AgentRegionDropper)CountPanel.this.props());
            }
        }
    }
}

