/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.gui.value.AValEditor;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class DiscreteCurveEditor<T extends IUrn<UnitDouble>>
extends AValEditor<T> {
    private static final long serialVersionUID = 5596382924189611784L;
    private final guiTable d_table;
    private final Unit d_unit;
    private final Semaphore d_valLock = new Semaphore(1);
    private final guiLabel d_sumDistriPercent;

    public DiscreteCurveEditor(int unit) {
        super(IUrn.class);
        UnitSystem us = MerlinApp.getApp().getUnitSystem();
        this.d_unit = us.getUnit(unit);
        this.d_sumDistriPercent = new guiLabel();
        this.getSumDistriPercent().setForeground(Color.BLUE);
        String[] headers = new String[]{Intl.intl("%"), Intl.intl("Values")};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{Double.class, UnitDouble.class}), 6);
        this.d_table = this.registerEd(ed.getTable());
        this.d_table.setNullValuesAllowed(false);
        this.d_table.getModel().addTableModelListener(e -> {
            if (this.d_valLock.tryAcquire()) {
                this.updateValue();
                this.d_valLock.release();
            }
            this.updateSumDistriPercent();
        });
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(this.d_unit));
        this.d_table.autoSizeColumns(700);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.max(300, this.d_table.getPreferredSize().height)));
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(ed);
        gb.addRow(this.getSumDistriPercent());
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this, 1.0);
    }

    @Override
    protected void loadValue(T value) {
        if (!this.d_valLock.tryAcquire()) {
            return;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int count = model.getRowCount();
        for (int m = count - 1; m >= 0; --m) {
            model.removeRow(m);
        }
        if (value != null) {
            Map weights = value.getWeights();
            int ix = 0;
            for (Map.Entry entry : weights.entrySet()) {
                model.setValueAt(100.0 * entry.getValue(), ix, 0);
                model.setValueAt(((UnitDouble)entry.getKey()).convert(this.d_unit), ix, 1);
                ++ix;
            }
        }
        this.updateSumDistriPercent();
        this.setModified(false);
        this.d_valLock.release();
    }

    @Override
    protected T saveValue() {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        HashMap<UnitDouble, Double> vals = new HashMap<UnitDouble, Double>();
        for (int row = 0; row < rows; ++row) {
            Double x = (Double)model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(row, 1);
            if (x == null || y == null) continue;
            Double tempSum = vals.containsKey(y) ? (Double)vals.get(y) : Double.valueOf(0.0);
            tempSum = tempSum + x / 100.0;
            vals.put(y, tempSum);
        }
        return (T)UrnUtil.newUrn(vals);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        for (int m = 0; m < this.d_table.getRowCount(); ++m) {
            Double val = (Double)this.d_table.getValueAt(m, 0);
            if (val == null || !(val < 0.0) && !(val > 100.0)) continue;
            if (showWarn) {
                String msg = Intl.intl("Each percentage must be >= 0 && <= 100.");
                this.d_table.flagInvalidCell(m, 0, showWarn, allowModify, msg);
            }
            return false;
        }
        double totalPercent = this.getTotalPercent();
        if (!this.testOneHundredPercent(totalPercent)) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("The total distribution must add to 100%."), Intl.intl("Invalid Distribution"), 0);
            }
            return false;
        }
        return true;
    }

    private double getTotalPercent() {
        double percent = 0.0;
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            Double val = (Double)this.d_table.getValueAt(m, 0);
            if (val == null) continue;
            percent += val.doubleValue();
        }
        return percent;
    }

    public guiLabel getSumDistriPercent() {
        return this.d_sumDistriPercent;
    }

    private void updateSumDistriPercent() {
        double sum = this.getTotalPercent();
        Color c = !this.testOneHundredPercent(sum) ? Color.RED : Color.BLUE;
        this.getSumDistriPercent().setForeground(c);
        String text = String.format(Intl.intl("Total Distribution: %.0f%%"), sum);
        this.getSumDistriPercent().setText(text);
    }

    private boolean testOneHundredPercent(double sum) {
        return theUtil.eq(sum, 100.0, 1.0E-6);
    }
}

