/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.awt.FontMetrics;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import merlin.Intl;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseDistributedValEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.APopupValEditor;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.IDistributedVal;

public class CompactDistributedValPnl
extends APopupValEditor<IDistributedVal<UnitDouble>> {
    private static final long serialVersionUID = 1L;
    private final String d_name;
    private final JEditorPane d_editor;
    private final int d_unit;
    private final UnitDoubleVR d_range;
    private final Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> d_options;
    private boolean d_modified = false;

    public CompactDistributedValPnl(String name, int unit) {
        this(name, unit, UnitDoubleVR.above(0.0, SIUS.unit(unit), true));
    }

    public CompactDistributedValPnl(String name, int unit, UnitDoubleVR range) {
        this(name, unit, range, VerboseDistributedValEditor.OPT_ALL);
    }

    public CompactDistributedValPnl(String name, int unit, UnitDoubleVR range, EnumSet<VerboseDistributedValEditor.Type> options) {
        this(name, unit, range, VerboseDistributedValEditor.getTypeTest(options));
    }

    public CompactDistributedValPnl(String name, int unit, UnitDoubleVR range, Predicate<? super Class<? extends IDistributedVal<UnitDouble>>> typeFilter) {
        super(IDistributedVal.class);
        this.d_options = typeFilter;
        this.d_unit = unit;
        this.d_name = name;
        this.d_range = range;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && CompactDistributedValPnl.this.d_editor.isEnabled()) {
                    CompactDistributedValPnl.this.editValue();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this, false);
        this.add(gb);
        gb.finalizeRows();
        this.loadValue((IDistributedVal)this.getValue());
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this.d_editor);
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    @Override
    public boolean editValue() {
        VerboseDistributedValEditor pnl = new VerboseDistributedValEditor(this.d_unit, true, this.d_options, this.d_range);
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), this.d_name, 9);
        this.applyButtonLabels(dlg);
        GridBagHelper bg = new GridBagHelper(dlg.getDialogPane());
        bg.addRow(pnl);
        bg.finalizeRows();
        pnl.setValue(this.getValue());
        if (dlg.doModal() == 1) {
            this.setValue(pnl.getValue());
            return true;
        }
        return false;
    }

    @Override
    public void loadValue(IDistributedVal<UnitDouble> c) {
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        String str = CompactDistributedValPnl.format(c);
        String shortened = guiUtil.shorten(str, 100, fm);
        String lblStr = "<html><a href=\"blank\">" + shortened + "</a></html>";
        this.d_editor.setText(lblStr);
        if (!str.equals(shortened)) {
            this.d_editor.setToolTipText(str);
        } else {
            this.d_editor.setToolTipText(null);
        }
        this.setModified(true);
        this.revalidate();
    }

    @Override
    protected IDistributedVal<UnitDouble> saveValue() {
        return (IDistributedVal)this.getValue();
    }

    public static String format(IDistributedVal<UnitDouble> curve) {
        if (curve == null) {
            return Intl.intl("[mixed]");
        }
        String desc = guiCurveUtil.format(curve);
        return desc;
    }
}

